# Transfer Flow Smoke Tests

This lightweight PHP script exercises a couple of core helpers used by the transfer workflow to give confidence in the behavior of stock adjustments and notification delivery:

- **Region stock adjustments** – bumps and restores a product quantity for region `1` to ensure `mbh_increment_region_stock` and `mbh_decrement_region_stock` keep the numbers consistent.
- **Notification insertion** – exercises `mbh_notify_user` to confirm a message is stored as expected for user `21` and checks the stored payload.

The script runs inside a single transaction that is rolled back at the end, so it is safe to execute against your existing local database.

## Running the checks

```bash
php tests/run_transfer_checks.php
```

The exit code will be `0` when all checks pass and `1` when any assertion fails. Expect output similar to:

```
[PASS] Region stock adjustments
[PASS] Notification insertion
```
