<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../config/database.php';

$conn = get_db_connection();
if (!$conn) {
    die("Failed to connect to database.\n");
}

echo "Updating paid invoices using loan_payment records...\n";
$updateLoanFlagSql = "
    UPDATE paid_invoices pi
    JOIN (
        SELECT invoice_id, SUM(payment_amount) AS total_paid
        FROM loan_payment
        GROUP BY invoice_id
    ) lp ON lp.invoice_id = pi.id
    SET pi.is_loan_sale = 1,
        pi.loan_amount_bif = GREATEST(pi.loan_amount_bif, lp.total_paid)
";
$stmt = $conn->prepare($updateLoanFlagSql);
if (!$stmt) {
    die("Preparation failed: " . $conn->error . "\n");
}
$stmt->execute();
echo "Rows matched/updated via loan_payment: {$stmt->affected_rows}\n";
$stmt->close();

echo "Marking paid invoices whose payment_notes mention loan as loan sales...\n";
$stmt = $conn->prepare("
    UPDATE paid_invoices
    SET is_loan_sale = 1
    WHERE payment_details LIKE '%Type Paiement: Crédit%'
      AND is_loan_sale = 0
");
if (!$stmt) {
    die("Preparation failed: " . $conn->error . "\n");
}
$stmt->execute();
echo "Rows updated via payment_details flag: {$stmt->affected_rows}\n";
$stmt->close();

$conn->close();
echo "Done.\n";
