<?php
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/auth.php';
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/functions.php';
require_login();

// Restrict to admin roles
$allowed_roles = ['DG', 'Board', 'DGA', 'Admin'];
if (!in_array($_SESSION['role_name'], $allowed_roles)) {
    header("Location: /masunzu_bar_hotel/dashboards/admin_dashboard.php");
    exit;
}

// Fetch user
$user_id = (int)($_GET['id'] ?? 0);
$conn = get_db_connection();
$stmt = $conn->prepare("
    SELECT u.id, u.username, u.full_name, u.email, u.mobile1, u.mobile2, u.position, 
           u.role_id, u.is_active, u.address, u.province_id, u.region_id, 
           u.created_at, u.updated_at,
           r.name AS role_name, 
           p.name AS province_name,
           rg.name AS region_name
    FROM user u 
    LEFT JOIN role r ON u.role_id = r.id 
    LEFT JOIN province p ON u.province_id = p.id
    LEFT JOIN region rg ON u.region_id = rg.id
    WHERE u.id = ?
");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->num_rows === 1 ? $result->fetch_assoc() : null;
$stmt->close();

// Fetch user departments
$userDepartments = [];
$deptStmt = $conn->prepare("
    SELECT d.label 
    FROM user_department ud 
    JOIN department d ON ud.department_id = d.id 
    WHERE ud.user_id = ?
    ORDER BY d.label
");
$deptStmt->bind_param("i", $user_id);
$deptStmt->execute();
$deptResult = $deptStmt->get_result();
while ($row = $deptResult->fetch_assoc()) {
    $userDepartments[] = $row['label'];
}
$deptStmt->close();
$conn->close();

if (!$user) {
    header("Location: /masunzu_bar_hotel/modules/users/manage.php");
    exit;
}

$viewedUser = $user;
include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/header.php';
$user = $viewedUser;
?>
<div class="form-container" style="padding: 20px; background-color: #F4F0E4; min-height: 70vh;">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
        <h1 style="color: #4B2F1F; font-size: 28px; font-weight: bold; margin: 0;">Détails de l'utilisateur</h1>
        <div>
            <a href="/masunzu_bar_hotel/modules/users/edit_user.php?id=<?php echo (int)$user['id']; ?>" 
               style="background-color: #F4A261; color: #000; padding: 10px 20px; border-radius: 8px; text-decoration: none; font-weight: bold; margin-right: 10px;">
                Modifier
            </a>
            <a href="/masunzu_bar_hotel/modules/users/manage.php" 
               style="background-color: #4B2F1F; color: #F4F0E4; padding: 10px 20px; border-radius: 8px; text-decoration: none; font-weight: bold;">
                Retour à la liste
            </a>
        </div>
    </div>

    <div class="form-content" style="background-color: #FFFFFF; padding: 30px; border-radius: 10px; box-shadow: 0 4px 8px rgba(0,0,0,0.1); max-width: 700px; margin: 0 auto;">
        
        <!-- User Status Badge -->
        <div style="text-align: center; margin-bottom: 25px;">
            <span style="display: inline-block; padding: 8px 20px; border-radius: 20px; font-weight: bold; font-size: 14px;
                         background-color: <?php echo $user['is_active'] ? '#e6ffe6' : '#ffe6e6'; ?>; 
                         color: <?php echo $user['is_active'] ? '#2E7D32' : '#C62828'; ?>;">
                <?php echo $user['is_active'] ? '✓ Utilisateur Actif' : '✗ Utilisateur Inactif'; ?>
            </span>
        </div>

        <!-- User Info Grid -->
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 20px;">
            
            <!-- Basic Information -->
            <div style="background-color: #FDFBF7; padding: 20px; border-radius: 10px; border: 1px solid rgba(75,47,31,0.1);">
                <h3 style="color: #4B2F1F; margin: 0 0 15px; font-size: 18px; border-bottom: 2px solid #F4A261; padding-bottom: 8px;">
                    Informations de base
                </h3>
                
                <div style="margin-bottom: 12px;">
                    <label style="display: block; color: #6B4F2F; font-size: 12px; text-transform: uppercase; letter-spacing: 0.05em; margin-bottom: 3px;">Nom d'utilisateur</label>
                    <p style="margin: 0; color: #2C1810; font-size: 16px; font-weight: 600;"><?php echo htmlspecialchars($user['username'] ?? 'N/A'); ?></p>
                </div>
                
                <div style="margin-bottom: 12px;">
                    <label style="display: block; color: #6B4F2F; font-size: 12px; text-transform: uppercase; letter-spacing: 0.05em; margin-bottom: 3px;">Nom complet</label>
                    <p style="margin: 0; color: #2C1810; font-size: 16px; font-weight: 600;"><?php echo htmlspecialchars($user['full_name'] ?? 'N/A'); ?></p>
                </div>
                
                <div style="margin-bottom: 12px;">
                    <label style="display: block; color: #6B4F2F; font-size: 12px; text-transform: uppercase; letter-spacing: 0.05em; margin-bottom: 3px;">Fonction</label>
                    <p style="margin: 0; color: #2C1810; font-size: 16px;"><?php echo htmlspecialchars($user['position'] ?? 'N/A'); ?></p>
                </div>
                
                <div>
                    <label style="display: block; color: #6B4F2F; font-size: 12px; text-transform: uppercase; letter-spacing: 0.05em; margin-bottom: 3px;">Rôle</label>
                    <p style="margin: 0; color: #2C1810; font-size: 16px;">
                        <span style="background-color: #4B2F1F; color: #F4F0E4; padding: 4px 12px; border-radius: 4px; font-size: 14px;">
                            <?php echo htmlspecialchars($user['role_name'] ?? 'Non assigné'); ?>
                        </span>
                    </p>
                </div>
            </div>
            
            <!-- Contact Information -->
            <div style="background-color: #FDFBF7; padding: 20px; border-radius: 10px; border: 1px solid rgba(75,47,31,0.1);">
                <h3 style="color: #4B2F1F; margin: 0 0 15px; font-size: 18px; border-bottom: 2px solid #F4A261; padding-bottom: 8px;">
                    Coordonnées
                </h3>
                
                <div style="margin-bottom: 12px;">
                    <label style="display: block; color: #6B4F2F; font-size: 12px; text-transform: uppercase; letter-spacing: 0.05em; margin-bottom: 3px;">Email</label>
                    <p style="margin: 0; color: #2C1810; font-size: 16px;">
                        <a href="mailto:<?php echo htmlspecialchars($user['email'] ?? ''); ?>" style="color: #4B2F1F; text-decoration: none;">
                            <?php echo htmlspecialchars($user['email'] ?? 'N/A'); ?>
                        </a>
                    </p>
                </div>
                
                <div style="margin-bottom: 12px;">
                    <label style="display: block; color: #6B4F2F; font-size: 12px; text-transform: uppercase; letter-spacing: 0.05em; margin-bottom: 3px;">Téléphone principal</label>
                    <p style="margin: 0; color: #2C1810; font-size: 16px;">
                        <?php if (!empty($user['mobile1'])): ?>
                            <a href="tel:<?php echo htmlspecialchars($user['mobile1']); ?>" style="color: #4B2F1F; text-decoration: none;">
                                <?php echo htmlspecialchars($user['mobile1']); ?>
                            </a>
                        <?php else: ?>
                            <span style="color: #999;">Non renseigné</span>
                        <?php endif; ?>
                    </p>
                </div>
                
                <div style="margin-bottom: 12px;">
                    <label style="display: block; color: #6B4F2F; font-size: 12px; text-transform: uppercase; letter-spacing: 0.05em; margin-bottom: 3px;">Téléphone secondaire</label>
                    <p style="margin: 0; color: #2C1810; font-size: 16px;">
                        <?php if (!empty($user['mobile2'])): ?>
                            <a href="tel:<?php echo htmlspecialchars($user['mobile2']); ?>" style="color: #4B2F1F; text-decoration: none;">
                                <?php echo htmlspecialchars($user['mobile2']); ?>
                            </a>
                        <?php else: ?>
                            <span style="color: #999;">Non renseigné</span>
                        <?php endif; ?>
                    </p>
                </div>
                
                <div>
                    <label style="display: block; color: #6B4F2F; font-size: 12px; text-transform: uppercase; letter-spacing: 0.05em; margin-bottom: 3px;">Adresse</label>
                    <p style="margin: 0; color: #2C1810; font-size: 16px;"><?php echo htmlspecialchars($user['address'] ?? 'N/A') ?: '<span style="color: #999;">Non renseignée</span>'; ?></p>
                </div>
            </div>
            
            <!-- Assignment Information -->
            <div style="background-color: #FDFBF7; padding: 20px; border-radius: 10px; border: 1px solid rgba(75,47,31,0.1);">
                <h3 style="color: #4B2F1F; margin: 0 0 15px; font-size: 18px; border-bottom: 2px solid #F4A261; padding-bottom: 8px;">
                    Affectations
                </h3>
                
                <div style="margin-bottom: 12px;">
                    <label style="display: block; color: #6B4F2F; font-size: 12px; text-transform: uppercase; letter-spacing: 0.05em; margin-bottom: 3px;">Dépôt</label>
                    <p style="margin: 0; color: #2C1810; font-size: 16px;"><?php echo htmlspecialchars($user['province_name'] ?? 'Non assigné'); ?></p>
                </div>
                
                <div style="margin-bottom: 12px;">
                    <label style="display: block; color: #6B4F2F; font-size: 12px; text-transform: uppercase; letter-spacing: 0.05em; margin-bottom: 3px;">Région</label>
                    <p style="margin: 0; color: #2C1810; font-size: 16px;"><?php echo htmlspecialchars($user['region_name'] ?? 'Non assignée'); ?></p>
                </div>
                
                <div>
                    <label style="display: block; color: #6B4F2F; font-size: 12px; text-transform: uppercase; letter-spacing: 0.05em; margin-bottom: 3px;">Départements</label>
                    <?php if (!empty($userDepartments)): ?>
                        <div style="display: flex; flex-wrap: wrap; gap: 6px; margin-top: 5px;">
                            <?php foreach ($userDepartments as $dept): ?>
                                <span style="background-color: #F4A261; color: #000; padding: 4px 10px; border-radius: 4px; font-size: 13px;">
                                    <?php echo htmlspecialchars($dept); ?>
                                </span>
                            <?php endforeach; ?>
                        </div>
                    <?php else: ?>
                        <p style="margin: 0; color: #999; font-size: 16px;">Aucun département assigné</p>
                    <?php endif; ?>
                </div>
            </div>
            
            <!-- Account Information -->
            <div style="background-color: #FDFBF7; padding: 20px; border-radius: 10px; border: 1px solid rgba(75,47,31,0.1);">
                <h3 style="color: #4B2F1F; margin: 0 0 15px; font-size: 18px; border-bottom: 2px solid #F4A261; padding-bottom: 8px;">
                    Informations du compte
                </h3>
                
                <div style="margin-bottom: 12px;">
                    <label style="display: block; color: #6B4F2F; font-size: 12px; text-transform: uppercase; letter-spacing: 0.05em; margin-bottom: 3px;">ID Utilisateur</label>
                    <p style="margin: 0; color: #2C1810; font-size: 16px;">#<?php echo (int)$user['id']; ?></p>
                </div>
                
                <div style="margin-bottom: 12px;">
                    <label style="display: block; color: #6B4F2F; font-size: 12px; text-transform: uppercase; letter-spacing: 0.05em; margin-bottom: 3px;">Date de création</label>
                    <p style="margin: 0; color: #2C1810; font-size: 16px;">
                        <?php echo date('d/m/Y à H:i', strtotime($user['created_at'] ?? 'now')); ?>
                    </p>
                </div>
                
                <div>
                    <label style="display: block; color: #6B4F2F; font-size: 12px; text-transform: uppercase; letter-spacing: 0.05em; margin-bottom: 3px;">Dernière modification</label>
                    <p style="margin: 0; color: #2C1810; font-size: 16px;">
                        <?php echo date('d/m/Y à H:i', strtotime($user['updated_at'] ?? 'now')); ?>
                    </p>
                </div>
            </div>
            
        </div>
    </div>
</div>
<?php include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/footer.php'; ?>



