<?php
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/auth.php';
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/functions.php';
require_login();

$allowed_roles = ['DG', 'Board', 'DGA', 'Admin'];
if (!in_array($_SESSION['role_name'], $allowed_roles, true)) {
    header("Location: /masunzu_bar_hotel/dashboards/admin_dashboard.php");
    exit;
}

$startDate = $_GET['start_date'] ?? date('Y-m-d', strtotime('-7 days'));
$endDate = $_GET['end_date'] ?? date('Y-m-d');
$selectedUserId = isset($_GET['user_id']) ? (int)$_GET['user_id'] : 0;
$export = isset($_GET['export']);

$conn = get_db_connection();
if (!$conn) {
    die('Impossible de se connecter à la base de données.');
}

$userOptions = [];
$userResult = $conn->query("SELECT id, full_name FROM user ORDER BY full_name");
if ($userResult instanceof mysqli_result) {
    while ($row = $userResult->fetch_assoc()) {
        $userOptions[] = $row;
    }
    $userResult->free();
}

$activeSql = "SELECT us.*, u.full_name, u.username 
              FROM user_session us
              JOIN user u ON us.user_id = u.id
              WHERE us.logout_time IS NULL
              ORDER BY us.login_time DESC";
$activeSessions = [];
if ($activeStmt = $conn->prepare($activeSql)) {
    $activeStmt->execute();
    $activeSessions = $activeStmt->get_result()->fetch_all(MYSQLI_ASSOC);
    $activeStmt->close();
}

$historySql = "SELECT us.*, u.full_name, u.username 
               FROM user_session us
               JOIN user u ON us.user_id = u.id
               WHERE 1=1";
$types = '';
$params = [];
if (!empty($startDate)) {
    $historySql .= " AND us.login_time >= ?";
    $types .= 's';
    $params[] = $startDate . ' 00:00:00';
}
if (!empty($endDate)) {
    $historySql .= " AND us.login_time <= ?";
    $types .= 's';
    $params[] = $endDate . ' 23:59:59';
}
if ($selectedUserId > 0) {
    $historySql .= " AND us.user_id = ?";
    $types .= 'i';
    $params[] = $selectedUserId;
}
$historySql .= " ORDER BY us.login_time DESC";

$historyRows = [];
$historyStmt = $conn->prepare($historySql);
if ($historyStmt) {
    if ($types !== '') {
        $historyStmt->bind_param($types, ...$params);
    }
    $historyStmt->execute();
    $historyRows = $historyStmt->get_result()->fetch_all(MYSQLI_ASSOC);
    $historyStmt->close();
}

function mbh_session_duration_hours(array $session): float
{
    $start = strtotime($session['login_time']);
    $endSource = $session['logout_time'] ?: ($session['last_activity'] ?? null);
    if (!$endSource) {
        $endSource = date('Y-m-d H:i:s');
    }
    $end = strtotime($endSource);
    if ($start === false || $end === false || $end <= $start) {
        return 0.0;
    }
    return round(($end - $start) / 3600, 2);
}

if ($export) {
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename="session_history_' . date('Ymd_His') . '.csv"');
    $output = fopen('php://output', 'w');
    fputcsv($output, ['Utilisateur', 'Nom d\'utilisateur', 'Date connexion', 'Dernière activité', 'Déconnexion', 'Heures', 'Adresse IP', 'Navigateur']);
    foreach ($historyRows as $row) {
        fputcsv($output, [
            $row['full_name'],
            $row['username'],
            $row['login_time'],
            $row['last_activity'],
            $row['logout_time'],
            mbh_session_duration_hours($row),
            $row['ip_address'],
            $row['user_agent'],
        ]);
    }
    fclose($output);
    $conn->close();
    exit;
}

$conn->close();
include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/header.php';
?>
<div style="padding:20px; background-color:#F4F0E4; min-height:calc(100vh - 70px);">
    <!-- Header with Stats -->
    <div style="display:flex; justify-content:space-between; align-items:flex-start; flex-wrap:wrap; gap:16px; margin-bottom:20px;">
        <div>
            <h1 style="color:#4B2F1F; font-size:28px; font-weight:700; margin:0 0 8px;">Sessions Utilisateurs & Historique</h1>
            <p style="color:#6B4F2F; margin:0; font-size:14px;">
                Surveillez les sessions actives, consultez l'historique des connexions et exportez des rapports CSV.
            </p>
        </div>
        <div style="display:flex; gap:12px; flex-wrap:wrap;">
            <div style="background:linear-gradient(135deg, #2A9D8F 0%, #1E7A6E 100%); color:#fff; padding:12px 20px; border-radius:10px; text-align:center; min-width:120px;">
                <p style="margin:0; font-size:11px; text-transform:uppercase; letter-spacing:0.05em; opacity:0.9;">Actives</p>
                <p style="margin:4px 0 0; font-size:20px; font-weight:700;"><?php echo count($activeSessions); ?></p>
            </div>
            <div style="background:linear-gradient(135deg, #4B2F1F 0%, #6B4F2F 100%); color:#F4F0E4; padding:12px 20px; border-radius:10px; text-align:center; min-width:120px;">
                <p style="margin:0; font-size:11px; text-transform:uppercase; letter-spacing:0.05em; opacity:0.9;">Historique</p>
                <p style="margin:4px 0 0; font-size:20px; font-weight:700;"><?php echo count($historyRows); ?></p>
            </div>
        </div>
    </div>

    <!-- Active Sessions -->
    <div style="background:#fff; padding:20px; border-radius:12px; box-shadow:0 2px 8px rgba(0,0,0,0.06); margin-bottom:20px;">
        <h2 style="color:#4B2F1F; margin:0 0 16px; font-size:18px; font-weight:600;">Sessions Actives</h2>
            <?php if (empty($activeSessions)): ?>
                <p style="color:#6B4F2F; text-align:center; padding:20px;">✓ Aucune session active actuellement.</p>
            <?php else: ?>
                <div style="overflow-x:auto;">
                    <table style="width:100%; border-collapse:collapse; font-size:14px;">
                        <thead style="background:#4B2F1F; color:#F4F0E4;">
                            <tr>
                                <th style="padding:12px 14px; text-align:left; font-size:12px; text-transform:uppercase; letter-spacing:0.03em;">Utilisateur</th>
                                <th style="padding:12px 14px; text-align:left; font-size:12px; text-transform:uppercase; letter-spacing:0.03em;">Connecté depuis</th>
                                <th style="padding:12px 14px; text-align:left; font-size:12px; text-transform:uppercase; letter-spacing:0.03em;">Dernière activité</th>
                                <th style="padding:12px 14px; text-align:left; font-size:12px; text-transform:uppercase; letter-spacing:0.03em;">Durée (h)</th>
                                <th style="padding:12px 14px; text-align:left; font-size:12px; text-transform:uppercase; letter-spacing:0.03em;">Adresse IP</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($activeSessions as $session): ?>
                                <tr style="border-bottom:1px solid #F0F0F0;">
                                    <td style="padding:12px 14px;">
                                        <strong style="color:#2C1810;"><?php echo htmlspecialchars($session['full_name']); ?></strong><br>
                                        <span style="color:#6B4F2F; font-size:12px;">@<?php echo htmlspecialchars($session['username']); ?></span>
                                    </td>
                                    <td style="padding:12px 14px; color:#2C1810;"><?php echo date('d/m/Y H:i', strtotime($session['login_time'])); ?></td>
                                    <td style="padding:12px 14px; color:#2C1810;"><?php echo date('d/m/Y H:i', strtotime($session['last_activity'])); ?></td>
                                    <td style="padding:12px 14px;">
                                        <span style="background:#e8f5e9; color:#2E7D32; padding:4px 10px; border-radius:12px; font-weight:600; font-size:13px;">
                                            <?php echo number_format(mbh_session_duration_hours($session), 2); ?>h
                                        </span>
                                    </td>
                                    <td style="padding:12px 14px; font-family:monospace; color:#4B2F1F;"><?php echo htmlspecialchars($session['ip_address'] ?? 'N/A'); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>

    <!-- Filters -->
    <div style="background:#fff; padding:20px; border-radius:12px; box-shadow:0 2px 8px rgba(0,0,0,0.06); margin-bottom:20px;">
        <form method="GET" style="display:grid; grid-template-columns: repeat(5, 1fr); gap:15px; align-items:end;">
            <div>
                <label style="display:block; font-size:12px; font-weight:600; color:#4B2F1F; margin-bottom:5px;">Utilisateur</label>
                <select name="user_id" style="width:100%; padding:10px; border:1px solid #B08968; border-radius:6px; font-size:14px; box-sizing:border-box;">
                    <option value="0">Tous les utilisateurs</option>
                    <?php foreach ($userOptions as $option): ?>
                        <option value="<?php echo (int)$option['id']; ?>" <?php echo $selectedUserId === (int)$option['id'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($option['full_name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div>
                <label style="display:block; font-size:12px; font-weight:600; color:#4B2F1F; margin-bottom:5px;">Date début</label>
                <input type="date" name="start_date" value="<?php echo htmlspecialchars($startDate); ?>" style="width:100%; padding:10px; border:1px solid #B08968; border-radius:6px; font-size:14px; box-sizing:border-box;">
            </div>
            <div>
                <label style="display:block; font-size:12px; font-weight:600; color:#4B2F1F; margin-bottom:5px;">Date fin</label>
                <input type="date" name="end_date" value="<?php echo htmlspecialchars($endDate); ?>" style="width:100%; padding:10px; border:1px solid #B08968; border-radius:6px; font-size:14px; box-sizing:border-box;">
            </div>
            <div>
                <button type="submit" style="width:100%; background:#4B2F1F; color:#F4F0E4; padding:11px; border:none; border-radius:6px; font-weight:600; cursor:pointer; font-size:14px;">Filtrer</button>
            </div>
            <div>
                <form method="GET" style="margin:0;">
                    <input type="hidden" name="user_id" value="<?php echo htmlspecialchars((string)$selectedUserId); ?>">
                    <input type="hidden" name="start_date" value="<?php echo htmlspecialchars($startDate); ?>">
                    <input type="hidden" name="end_date" value="<?php echo htmlspecialchars($endDate); ?>">
                    <input type="hidden" name="export" value="1">
                    <button type="submit" style="width:100%; background:#2A9D8F; color:#fff; padding:11px; border:none; border-radius:6px; font-weight:600; cursor:pointer; font-size:14px;">📥 Exporter CSV</button>
                </form>
            </div>
        </form>
    </div>

    <!-- History Table -->
    <div style="background:#fff; border-radius:12px; box-shadow:0 2px 8px rgba(0,0,0,0.06); overflow:hidden;">
        <div style="padding:16px 20px; border-bottom:1px solid #F0F0F0; background:#FDFBF7;">
            <span style="font-weight:600; color:#4B2F1F;">Historique des connexions</span>
            <span style="color:#6B4F2F; font-size:13px; margin-left:10px;"><?php echo count($historyRows); ?> enregistrement<?php echo count($historyRows) !== 1 ? 's' : ''; ?></span>
        </div>
        <div style="overflow-x:auto;">
            <table style="width:100%; border-collapse:collapse; font-size:14px; min-width:900px;">
                <thead style="background:#4B2F1F; color:#F4F0E4;">
                    <tr>
                        <th style="padding:14px 16px; text-align:left; font-size:12px; text-transform:uppercase; letter-spacing:0.03em; font-weight:600;">Utilisateur</th>
                        <th style="padding:14px 16px; text-align:left; font-size:12px; text-transform:uppercase; letter-spacing:0.03em; font-weight:600;">Nom d'utilisateur</th>
                        <th style="padding:14px 16px; text-align:left; font-size:12px; text-transform:uppercase; letter-spacing:0.03em; font-weight:600;">Connexion</th>
                        <th style="padding:14px 16px; text-align:left; font-size:12px; text-transform:uppercase; letter-spacing:0.03em; font-weight:600;">Déconnexion</th>
                        <th style="padding:14px 16px; text-align:center; font-size:12px; text-transform:uppercase; letter-spacing:0.03em; font-weight:600;">Durée</th>
                        <th style="padding:14px 16px; text-align:left; font-size:12px; text-transform:uppercase; letter-spacing:0.03em; font-weight:600;">Adresse IP</th>
                        <th style="padding:14px 16px; text-align:left; font-size:12px; text-transform:uppercase; letter-spacing:0.03em; font-weight:600;">Navigateur</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($historyRows)): ?>
                        <tr>
                            <td colspan="7" style="padding:40px; text-align:center; color:#6B4F2F;">
                                <div style="font-size:48px; margin-bottom:10px;">📭</div>
                                <p style="margin:0; font-weight:600;">Aucune session trouvée</p>
                                <p style="margin:5px 0 0; font-size:13px;">Modifiez les filtres pour voir d'autres résultats.</p>
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($historyRows as $row): 
                            $isActive = empty($row['logout_time']);
                            $duration = mbh_session_duration_hours($row);
                        ?>
                            <tr style="border-bottom:1px solid #F0F0F0; <?php echo $isActive ? 'background-color:#FFF8E1;' : ''; ?>">
                                <td style="padding:14px 16px; font-weight:500; color:#2C1810;"><?php echo htmlspecialchars($row['full_name']); ?></td>
                                <td style="padding:14px 16px; color:#6B4F2F;">@<?php echo htmlspecialchars($row['username']); ?></td>
                                <td style="padding:14px 16px; color:#2C1810;"><?php echo date('d/m/Y H:i', strtotime($row['login_time'])); ?></td>
                                <td style="padding:14px 16px;">
                                    <?php if ($isActive): ?>
                                        <span style="background:#e8f5e9; color:#2E7D32; padding:3px 10px; border-radius:12px; font-size:12px; font-weight:600;">Active</span>
                                    <?php else: ?>
                                        <span style="color:#2C1810;"><?php echo date('d/m/Y H:i', strtotime($row['logout_time'])); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td style="padding:14px 16px; text-align:center;">
                                    <span style="background:<?php echo $duration > 8 ? '#ffebee' : '#e3f2fd'; ?>; color:<?php echo $duration > 8 ? '#C62828' : '#1565C0'; ?>; padding:4px 10px; border-radius:12px; font-weight:600; font-size:13px;">
                                        <?php echo number_format($duration, 2); ?>h
                                    </span>
                                </td>
                                <td style="padding:14px 16px; font-family:monospace; font-size:13px; color:#4B2F1F;"><?php echo htmlspecialchars($row['ip_address'] ?? 'N/A'); ?></td>
                                <td style="padding:14px 16px; color:#6B4F2F; font-size:13px; max-width:200px; overflow:hidden; text-overflow:ellipsis; white-space:nowrap;" title="<?php echo htmlspecialchars($row['user_agent'] ?? ''); ?>">
                                    <?php 
                                    $ua = $row['user_agent'] ?? '';
                                    if (stripos($ua, 'Chrome') !== false) echo '🌐 Chrome';
                                    elseif (stripos($ua, 'Firefox') !== false) echo '🦊 Firefox';
                                    elseif (stripos($ua, 'Safari') !== false) echo '🧭 Safari';
                                    elseif (stripos($ua, 'Edge') !== false) echo '🔷 Edge';
                                    else echo htmlspecialchars(substr($ua, 0, 30)) . (strlen($ua) > 30 ? '...' : '');
                                    ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/footer.php'; ?>
