good!  i went on DGA profile to approve the expense , but the approve expense page returned nothing : Object not found!
The requested URL was not found on this server. The link on the referring page seems to be wrong or outdated. Please inform the author of that page about the error.

If you think this is a server error, please contact the webmaster.

Error 404
127.0.0.1
Apache/2.4.56 (Unix) OpenSSL/1.1.1t PHP/8.2.4 mod_perl/2.0.12 Perl/v5.34.1  http://127.0.0.1/masunzu_bar_hotel/modules/admin/approve_expenses.php, you can also change the header.php to  add the other expenses pages , also I liked the feature of combining buttons as drop down menu is cool you can implementfor other features on all profiles , remember , here is the actual header: <?php
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/functions.php';

// Check if user is logged in
if (!is_logged_in()) {
    error_log("User not logged in, redirecting from header.php");
    header("Location: /masunzu_bar_hotel/modules/login/login.php");
    exit;
}

// Initialize database connection
$header_conn = get_db_connection();
if (!$header_conn) {
    error_log("Database connection failed in header.php: " . mysqli_connect_error());
    echo "<p style='color: #FF0000; text-align: center; padding: 20px;'>Database connection failed. Contact administrator.</p>";
    exit;
}

// Fetch user role and province
$stmt = $header_conn->prepare("SELECT u.full_name, r.name AS role_name, u.province_id, r.id AS role_id FROM user u JOIN role r ON u.role_id = r.id WHERE u.id = ?");
$stmt->bind_param("i", $_SESSION['user_id']);
$stmt->execute();
$user_result = $stmt->get_result();
$user = $user_result->fetch_assoc();
$stmt->close();
$header_conn->close();

if (!$user) {
    error_log("User data not found for user_id {$_SESSION['user_id']} in header.php");
    header("Location: /masunzu_bar_hotel/modules/login/logout.php");
    exit;
}

// Set session variables
$_SESSION['full_name'] = $user['full_name'];
$_SESSION['role_name'] = $user['role_name'];
$_SESSION['role_id'] = $user['role_id'];

// Handle province_id based on role
if (!isset($_SESSION['province_id'])) {
    if (in_array($user['role_id'], [1, 2, 3, 12])) { // Admin, DG, DGA, Stock Manager Assistant
        $_SESSION['province_id'] = null; // No province required
    } else {
        $_SESSION['province_id'] = $user['province_id'] ?? null;
        if (is_null($_SESSION['province_id'])) {
            error_log("No province_id for user {$user['full_name']} (ID: {$_SESSION['user_id']}, Role ID: {$user['role_id']})");
            echo "<p style='color: #FF0000; text-align: center; padding: 20px;'>Error: No province assigned. Contact administrator.</p>";
            include __DIR__ . '/footer.php';
            exit;
        }
    }
}

// Define role-specific dashboard paths
$dashboard_map = [
    'Board' => 'admin_dashboard.php',
    'DG' => 'admin_dashboard.php',
    'DGA' => 'admin_dashboard.php',
    'Procurement Manager' => 'procurement_dashboard.php',
    'Operation Manager' => 'operation_dashboard.php',
    'Finance Head' => 'finance_dashboard.php',
    'Marketing Head' => 'marketing_dashboard.php',
    'Stock Manager' => 'stock_manager_dashboard.php',
    'Accountant' => 'accountant_dashboard.php',
    'Marketing Agent' => 'marketing_dashboard.php',
    'Caissier_Comptable' => 'cashier_dashboard.php',
    'Stock Manager Assistant' => 'stock_manager_assistant_dashboard.php'
];
$dashboard = $dashboard_map[$_SESSION['role_name']] ?? 'unauthorized.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($lang['dashboard'] ?? 'Dashboard', ENT_QUOTES, 'UTF-8'); ?> - Masunzu Bar Hotel</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #F4F0E4;
            color: #4B2F1F;
            margin: 0;
            padding: 0;
        }
        header {
            background-color: #4B2F1F;
            color: #F4F0E4;
            padding: 15px;
            text-align: center;
            box-shadow: 0 2px 4px rgba(0,0,0,0.3);
        }
        header h1 {
            margin: 0;
            font-size: 32px;
            font-weight: bold;
        }
        nav {
            background-color: #4B2F1F;
            padding: 15px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            width: 100%;
            box-sizing: border-box;
            position: sticky;
            top: 0;
            z-index: 1000;
            box-shadow: 0 2px 4px rgba(0,0,0,0.3);
            backdrop-filter: blur(5px);
        }
        nav div:first-child {
            display: flex;
            flex-wrap: wrap;
            gap: 15px;
            align-items: center;
        }
        nav a {
            color: #F4F0E4;
            text-decoration: none;
            font-weight: 500;
            padding: 12px 20px;
            border-radius: 8px;
            font-size: 16px;
            transition: all 0.3s ease;
            position: relative;
        }
        nav a:hover, nav a.active {
            background-color: #F4A261;
            color: #4B2F1F;
            transform: translateY(-2px);
            box-shadow: 0 2px 4px rgba(0,0,0,0.2);
        }
        nav a::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 2px;
            background-color: #F4A261;
            transform: scaleX(0);
            transform-origin: bottom right;
            transition: transform 0.3s ease;
        }
        nav a:hover::after, nav a.active::after {
            transform: scaleX(1);
            transform-origin: bottom left;
        }
        .dropdown {
            position: relative;
            display: inline-block;
        }
        .dropdown:hover .dropdown-content {
            display: block;
        }
        .dropdown-content {
            display: none;
            position: absolute;
            background-color: #FFFFFF;
            min-width: 200px;
            box-shadow: 0 8px 16px rgba(0,0,0,0.2);
            z-index: 1;
            border-radius: 8px;
            overflow: hidden;
            top: 100%;
            left: 0;
        }
        .dropdown-content a {
            display: block;
            padding: 12px 16px;
            text-decoration: none;
            color: #4B2F1F;
            font-size: 14px;
            border-bottom: 1px solid #F4F0E4;
            background-color: #FFFFFF;
        }
        .dropdown-content a:hover {
            background-color: #F4A261;
            color: #4B2F1F;
        }
        .dropdown-content a.active {
            background-color: #F4A261;
            color: #4B2F1F;
        }
        .user-menu {
            position: relative;
            display: inline-block;
        }
        .user-icon {
            background-color: #F4A261;
            color: #4B2F1F;
            border: none;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            cursor: pointer;
            font-size: 18px;
            font-weight: bold;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s ease;
        }
        .user-icon:hover {
            background-color: #F4F0E4;
            transform: scale(1.1);
        }
        .dropdown-content.user-dropdown {
            right: 0;
            left: auto;
        }
        .dropdown-content .user-info {
            background-color: #4B2F1F;
            color: #F4F0E4;
            padding: 12px 16px;
            font-size: 14px;
            font-weight: 500;
            text-align: center;
            border-bottom: 1px solid #F4F0E4;
        }
        @media (max-width: 768px) {
            nav {
                flex-direction: column;
                align-items: flex-start;
                padding: 15px;
            }
            nav div:first-child {
                flex-direction: column;
                width: 100%;
                gap: 10px;
            }
            nav a {
                width: 100%;
                text-align: center;
                padding: 10px;
                font-size: 14px;
            }
            .dropdown-content {
                position: static;
                width: 100%;
                box-shadow: none;
                border: 1px solid #4B2F1F;
            }
            .user-menu {
                align-self: flex-end;
                margin-top: 10px;
            }
            .user-icon {
                width: 36px;
                height: 36px;
                font-size: 16px;
            }
            .dropdown-content.user-dropdown {
                min-width: 160px;
            }
        }
    </style>
</head>
<body>
    <header>
        <h1>Masunzu Bar Hotel</h1>
    </header>
    <nav>
        <div>
            <a href="/masunzu_bar_hotel/dashboards/<?php echo htmlspecialchars($dashboard, ENT_QUOTES, 'UTF-8'); ?>" <?php echo strpos($_SERVER['REQUEST_URI'], $dashboard) !== false ? 'class="active"' : ''; ?>>Dashboard</a>
            <?php if (in_array($_SESSION['role_name'], ['DG', 'Board', 'DGA', 'Admin'])): ?>
                <a href="/masunzu_bar_hotel/modules/users/manage.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'manage.php') !== false ? 'class="active"' : ''; ?>>Users</a>
                <a href="/masunzu_bar_hotel/modules/admin/reports.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'reports.php') !== false ? 'class="active"' : ''; ?>>Reports</a>
                <a href="/masunzu_bar_hotel/modules/admin/approve_invoices.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'approve_invoices.php') !== false ? 'class="active"' : ''; ?>>Invoices</a>
                <a href="/masunzu_bar_hotel/modules/admin/approve_expenses.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'approve_expenses.php') !== false ? 'class="active"' : ''; ?>>Expenses</a>
                <a href="/masunzu_bar_hotel/modules/admin/track_transactions.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'track_transactions.php') !== false ? 'class="active"' : ''; ?>>Transactions</a>
                <a href="/masunzu_bar_hotel/modules/admin/manage_company_info.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'manage_company_info.php') !== false ? 'class="active"' : ''; ?>>Company</a>
                <a href="/masunzu_bar_hotel/modules/accounting/manage_accountant.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'manage_accountant.php') !== false ? 'class="active"' : ''; ?>>Accountants</a>
                <a href="/masunzu_bar_hotel/modules/accounting/view_transactions.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'view_transactions.php') !== false ? 'class="active"' : ''; ?>>View Transactions</a>
            <?php elseif ($_SESSION['role_name'] === 'Operation Manager'): ?>
                <a href="/masunzu_bar_hotel/modules/operation/create_product.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'create_product.php') !== false ? 'class="active"' : ''; ?>>Product</a>
                <a href="/masunzu_bar_hotel/modules/operation/add_main_stock.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'add_main_stock.php') !== false ? 'class="active"' : ''; ?>>Stock</a>
                <a href="/masunzu_bar_hotel/modules/operation/initiate_transfer.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'initiate_transfer.php') !== false ? 'class="active"' : ''; ?>>Transfer</a>
                <a href="/masunzu_bar_hotel/modules/operation/stock_transfer_history.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'stock_transfer_history.php') !== false ? 'class="active"' : ''; ?>>History</a>
            <?php elseif ($_SESSION['role_name'] === 'Stock Manager'): ?>
                <a href="/masunzu_bar_hotel/modules/operation/receive_stock.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'receive_stock.php') !== false ? 'class="active"' : ''; ?>>Receive</a>
                <a href="/masunzu_bar_hotel/modules/operation/receiving_stock_history.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'receiving_stock_history.php') !== false ? 'class="active"' : ''; ?>>Receiving</a>
                <a href="/masunzu_bar_hotel/modules/operation/stock_transfer_history.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'stock_transfer_history.php') !== false ? 'class="active"' : ''; ?>>History</a>
                <a href="/masunzu_bar_hotel/modules/cashiers/sold_products.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'sold_products.php') !== false ? 'class="active"' : ''; ?>>Sales</a>
            <?php elseif ($_SESSION['role_name'] === 'Caissier_Comptable'): ?>
                <a href="/masunzu_bar_hotel/modules/cashiers/create_sale.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'create_sale.php') !== false ? 'class="active"' : ''; ?>>Direct Sales</a>
                <a href="/masunzu_bar_hotel/modules/cashiers/create_invoice.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'create_invoice.php') !== false ? 'class="active"' : ''; ?>>Invoice</a>
                <a href="/masunzu_bar_hotel/modules/cashiers/process_payment.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'process_payment.php') !== false ? 'class="active"' : ''; ?>>Payment</a>
                <a href="/masunzu_bar_hotel/modules/cashiers/balance_management.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'balance_management.php') !== false ? 'class="active"' : ''; ?>>Balance</a>
                <a href="/masunzu_bar_hotel/modules/cashiers/transaction_history.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'transaction_history.php') !== false ? 'class="active"' : ''; ?>>Transactions</a>
                <a href="/masunzu_bar_hotel/modules/cashiers/sold_products.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'sold_products.php') !== false ? 'class="active"' : ''; ?>>Sales</a>
                <a href="/masunzu_bar_hotel/modules/banking/deposit.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'deposit.php') !== false ? 'class="active"' : ''; ?>>Deposits</a>
                <a href="/masunzu_bar_hotel/modules/cashiers/transfer_cash.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'transfer_cash.php') !== false ? 'class="active"' : ''; ?>>Transfer</a>
            <?php elseif ($_SESSION['role_name'] === 'Marketing Agent'): ?>
                <a href="/masunzu_bar_hotel/modules/cashiers/create_sale.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'create_sale.php') !== false ? 'class="active"' : ''; ?>>Sale</a>
                <a href="/masunzu_bar_hotel/modules/cashiers/create_invoice.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'create_invoice.php') !== false ? 'class="active"' : ''; ?>>Invoice</a>
                <a href="/masunzu_bar_hotel/modules/cashiers/transaction_history.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'transaction_history.php') !== false ? 'class="active"' : ''; ?>>Transactions</a>
                <a href="/masunzu_bar_hotel/modules/customers/manage_customers.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'manage_customers.php') !== false ? 'class="active"' : ''; ?>>Customers</a>
                <a href="/masunzu_bar_hotel/modules/credits/track.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'track.php') !== false ? 'class="active"' : ''; ?>>Loans</a>
            <?php elseif ($_SESSION['role_name'] === 'Stock Manager Assistant'): ?>
                <a href="/masunzu_bar_hotel/modules/operation/receive_stock.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'receive_stock.php') !== false ? 'class="active"' : ''; ?>>Receive</a>
                <a href="/masunzu_bar_hotel/modules/operation/stock_transfer_history.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'stock_transfer_history.php') !== false ? 'class="active"' : ''; ?>>History</a>
            <?php elseif ($_SESSION['role_name'] === 'Procurement Manager'): ?>
                <a href="/masunzu_bar_hotel/modules/procurement/purchase_orders.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'purchase_orders.php') !== false ? 'class="active"' : ''; ?>>Orders</a>
                <a href="/masunzu_bar_hotel/modules/procurement/supplier_management.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'supplier_management.php') !== false ? 'class="active"' : ''; ?>>Suppliers</a>
            <?php elseif ($_SESSION['role_name'] === 'Finance Head'): ?>
                <a href="/masunzu_bar_hotel/modules/finance/transactions.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'transactions.php') !== false ? 'class="active"' : ''; ?>>Transactions</a>
                <a href="/masunzu_bar_hotel/modules/finance/credits.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'credits.php') !== false ? 'class="active"' : ''; ?>>Loans</a>
            <?php elseif ($_SESSION['role_name'] === 'Marketing Head'): ?>
                <a href="/masunzu_bar_hotel/modules/marketing/campaign_management.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'campaign_management.php') !== false ? 'class="active"' : ''; ?>>Campaigns</a>
                <a href="/masunzu_bar_hotel/modules/marketing/market_analysis.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'market_analysis.php') !== false ? 'class="active"' : ''; ?>>Analysis</a>
            <?php elseif ($_SESSION['role_name'] === 'Accountant'): ?>
                <a href="/masunzu_bar_hotel/modules/accounting/receive_cash.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'receive_cash.php') !== false ? 'class="active"' : ''; ?>>Receive Cash</a>
                <a href="/masunzu_bar_hotel/modules/accounting/accountant_balance.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'accountant_balance.php') !== false ? 'class="active"' : ''; ?>>Balance</a>
                <a href="/masunzu_bar_hotel/modules/accounting/accountant_stock.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'accountant_stock.php') !== false ? 'class="active"' : ''; ?>>Stock</a>
                <a href="/masunzu_bar_hotel/modules/accounting/bank_accounts.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'bank_accounts.php') !== false ? 'class="active"' : ''; ?>>Bank Accounts</a>
            <?php endif; ?>
            <div class="dropdown">
                <a href="#" class="dropbtn <?php echo strpos($_SERVER['REQUEST_URI'], '/modules/expenses/') !== false ? 'active' : ''; ?>">Expenses</a>
                <div class="dropdown-content">
                    <a href="/masunzu_bar_hotel/modules/expenses/create.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'create.php') !== false ? 'class="active"' : ''; ?>>Create Expense</a>
                    <a href="/masunzu_bar_hotel/modules/expenses/payments.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'payments.php') !== false ? 'class="active"' : ''; ?>>Payments</a>
                    <a href="/masunzu_bar_hotel/modules/expenses/receipts.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'receipts.php') !== false ? 'class="active"' : ''; ?>>Receipts</a>
                    <a href="/masunzu_bar_hotel/modules/expenses/expenses_history.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'expenses_history.php') !== false ? 'class="active"' : ''; ?>>History</a>
                </div>
            </div>
            <?php if (in_array($_SESSION['role_id'], [1, 2, 3, 10, 12])): ?>
                <a href="/masunzu_bar_hotel/modules/customers/manage_customers.php" <?php echo strpos($_SERVER['REQUEST_URI'], 'manage_customers.php') !== false ? 'class="active"' : ''; ?>>Customers</a>
            <?php endif; ?>
        </div>
        <div class="user-menu">
            <button class="user-icon" aria-label="User Menu"><?php echo htmlspecialchars(substr($_SESSION['full_name'] ?? 'U', 0, 1), ENT_QUOTES, 'UTF-8'); ?></button>
            <div class="dropdown-content user-dropdown">
                <div class="user-info"><?php echo htmlspecialchars($_SESSION['full_name'] ?? 'Unknown', ENT_QUOTES, 'UTF-8') . ' (' . htmlspecialchars($_SESSION['role_name'] ?? 'Unknown', ENT_QUOTES, 'UTF-8') . ')'; ?></div>
                <a href="/masunzu_bar_hotel/modules/users/profile.php">Profile</a>
                <a href="/masunzu_bar_hotel/modules/users/change_password.php">Password</a>
                <a href="/masunzu_bar_hotel/modules/login/logout.php">Logout</a>
            </div>
        </div>
    </nav>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const userIcon = document.querySelector('.user-icon');
            const userDropdown = document.querySelector('.dropdown-content.user-dropdown');
            const dropdowns = document.querySelectorAll('.dropdown');

            // Toggle user dropdown
            userIcon.addEventListener('click', function(event) {
                event.stopPropagation();
                userDropdown.style.display = userDropdown.style.display === 'block' ? 'none' : 'block';
            });

            // Toggle expense dropdown on dropbtn click
            dropdowns.forEach(dropdown => {
                const dropbtn = dropdown.querySelector('.dropbtn');
                const dropdownContent = dropdown.querySelector('.dropdown-content');

                dropbtn.addEventListener('click', function(event) {
                    event.stopPropagation();
                    // Close other dropdowns
                    dropdowns.forEach(otherDropdown => {
                        if (otherDropdown !== dropdown) {
                            otherDropdown.querySelector('.dropdown-content').style.display = 'none';
                        }
                    });
                    // Toggle current dropdown
                    dropdownContent.style.display = dropdownContent.style.display === 'block' ? 'none' : 'block';
                });

                // Allow navigation for dropdown-content links
                dropdownContent.querySelectorAll('a').forEach(link => {
                    link.addEventListener('click', function(event) {
                        event.stopPropagation(); // Prevent closing dropdown
                        window.location.href = this.getAttribute('href'); // Navigate to link
                    });
                });
            });

            // Close all dropdowns when clicking outside
            document.addEventListener('click', function(event) {
                if (!userIcon.contains(event.target) && !userDropdown.contains(event.target)) {
                    userDropdown.style.display = 'none';
                }
                dropdowns.forEach(dropdown => {
                    const dropdownContent = dropdown.querySelector('.dropdown-content');
                    if (!dropdown.contains(event.target)) {
                        dropdownContent.style.display = 'none';
                    }
                });
            });
        });
    </script>
</body>
</html>
