<?php
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/auth.php';
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/functions.php';
require_login();

$conn = get_db_connection();
if (!$conn) {
    die("<p style='color:red;text-align:center;padding:20px;'>Database connection failed.</p>");
}

// === GET PRODUCT ID ===
$product_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($product_id <= 0) {
    die("<p style='color:red;text-align:center;padding:20px;'>Invalid product ID.</p>");
}

// === FETCH PRODUCT ===
$stmt = $conn->prepare("SELECT * FROM product WHERE id = ?");
$stmt->bind_param("i", $product_id);
$stmt->execute();
$product = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$product) {
    die("<p style='color:red;text-align:center;padding:20px;'>Product not found.</p>");
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Product</title>
    <link rel="stylesheet" href="/masunzu_bar_hotel/assets/css/style.css">
    <style>
        :root {
            --primary: #4B2F1F;
            --accent: #F4A261;
            --light: #F4F0E4;
            --dark: #2E1A12;
            --gray: #6c757d;
        }
        body {
            font-family: 'Segoe UI', Arial, sans-serif;
            margin: 0;
            padding: 0;
            background: linear-gradient(135deg, var(--primary) 0%, var(--accent) 100%);
            min-height: 100vh;
        }
        .container {
            max-width: 600px;
            margin: 40px auto;
            padding: 0 15px;
        }
        .card {
            background: var(--light);
            border-radius: 12px;
            padding: 30px;
            box-shadow: 0 6px 15px rgba(0,0,0,0.2);
        }
        .card h2 {
            color: var(--primary);
            margin: 0 0 25px;
            font-size: 1.5rem;
            border-bottom: 2px solid var(--accent);
            padding-bottom: 12px;
        }
        .view-section {
            margin-bottom: 20px;
            padding: 15px;
            background: rgba(75,47,31,0.05);
            border-left: 4px solid var(--accent);
            border-radius: 6px;
        }
        .view-label {
            font-weight: 700;
            color: var(--primary);
            font-size: 13px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 6px;
        }
        .view-value {
            color: var(--dark);
            font-size: 16px;
            word-break: break-word;
            line-height: 1.5;
        }
        .btn-group {
            display: flex;
            gap: 10px;
            margin-top: 30px;
            justify-content: flex-end;
        }
        .btn {
            padding: 10px 20px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            font-size: 14px;
            font-weight: 600;
            transition: all 0.2s;
        }
        .btn-primary {
            background: var(--primary);
            color: var(--light);
        }
        .btn-primary:hover {
            background: var(--accent);
            color: var(--primary);
            transform: translateY(-1px);
        }
        .btn-secondary {
            background: var(--gray);
            color: white;
        }
        .btn-secondary:hover {
            background: #5a6268;
            transform: translateY(-1px);
        }
        .product-title {
            color: var(--primary);
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <?php require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/header.php'; ?>
    
    <div class="container">
        <div class="card">
            <h2><?= htmlspecialchars($product['name']) ?></h2>
            
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 20px;">
                <div class="view-section">
                    <div class="view-label">Volume</div>
                    <div class="view-value"><?= htmlspecialchars($product['volume_cl']) ?> CL</div>
                </div>
                <div class="view-section">
                    <div class="view-label">Bottles/Crate</div>
                    <div class="view-value"><?= htmlspecialchars($product['crate_quantity']) ?></div>
                </div>
            </div>

            <div class="view-section" style="margin-bottom: 20px;">
                <div class="view-label">Price / Crate</div>
                <div class="view-value" style="font-size: 20px; color: var(--accent); font-weight: 700;">
                    <?= number_format($product['price_per_crate']) ?> BIF
                </div>
            </div>

            <div class="view-section">
                <div class="view-label">Low Stock Alert (Crates)</div>
                <div class="view-value"><?= $product['low_stock_alert_crates'] ? htmlspecialchars($product['low_stock_alert_crates']) : '—' ?></div>
            </div>

            <div class="view-section">
                <div class="view-label">Expiration Date</div>
                <div class="view-value"><?= $product['expiration_date'] ? htmlspecialchars($product['expiration_date']) : '—' ?></div>
            </div>

            <div class="view-section">
                <div class="view-label">Created</div>
                <div class="view-value"><?= htmlspecialchars(substr($product['created_at'], 0, 16)) ?></div>
            </div>

            <div class="btn-group">
                <a href="/masunzu_bar_hotel/modules/inventory/product_catalog.php" class="btn btn-secondary">← Back to Catalog</a>
                <a href="product_history.php?id=<?= $product['id'] ?>" class="btn btn-secondary">📊 View History</a>
                <?php 
                    $role_names = ['DG', 'DGA', 'Board', 'Admin'];
                    $show_edit = in_array($_SESSION['role_name'] ?? '', $role_names);
                    if ($show_edit): 
                ?>
                    <a href="edit_product.php?id=<?= $product['id'] ?>" class="btn btn-primary">Edit Product</a>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <?php require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/footer.php'; ?>
</body>
</html>
