<?php
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/auth.php';
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/functions.php';
require_login();

// Restrict to Operation Manager role
if ($_SESSION['role_name'] !== 'Operation Manager') {
    error_log("Unauthorized access to transfer_details.php by user {$_SESSION['full_name']} (Role: {$_SESSION['role_name']})");
    header("Location: /masunzu_bar_hotel/dashboards/" . strtolower(str_replace(' ', '_', $_SESSION['role_name'])) . "_dashboard.php");
    exit;
}

// Check for shipment_id
$shipment_id = $_GET['shipment_id'] ?? '';
if (!$shipment_id) {
    header("Location: history.php");
    exit;
}

// Initialize database connection
$conn = get_db_connection();
if (!$conn) {
    error_log("Database connection failed in transfer_details.php: " . mysqli_connect_error());
    echo "<p style='color: #FF0000; text-align: center; padding: 20px;'>Database connection failed. Contact administrator.</p>";
    include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/footer.php';
    exit;
}

// Fetch transfer details
$query = "SELECT st.shipment_id, st.operation_manager_id, st.stock_manager_id, st.product_id, st.quantity, st.unit_type, 
                 st.province_id, st.status, st.sent_at, st.received_at, st.estimated_arrival, st.driver_name, 
                 st.driver_mobile, st.plate_number, st.total_amount, st.total_products, 
                 p.name AS product_name, p.crate_quantity, pr.name AS province_name, 
                 u1.full_name AS sent_by, u2.full_name AS received_by
          FROM stock_transfer st
          LEFT JOIN product p ON st.product_id = p.id
          LEFT JOIN province pr ON st.province_id = pr.id
          LEFT JOIN user u1 ON st.operation_manager_id = u1.id
          LEFT JOIN user u2 ON st.stock_manager_id = u2.id
          WHERE st.shipment_id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param('i', $shipment_id);
$stmt->execute();
$transfers = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();
$conn->close();

if (empty($transfers)) {
    echo "<p style='color: #FF0000; text-align: center; padding: 20px;'>No transfer found for Shipment ID: " . htmlspecialchars($shipment_id) . "</p>";
    include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/footer.php';
    exit;
}

include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/header.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>
<body>
    <div class="container" style="padding: 20px; background: linear-gradient(135deg, #4B2F1F 0%, #F4A261 100%); min-height: 100vh; box-sizing: border-box;">
        <div style="max-width: 1200px; margin: 30px auto;">
            <h1 style="color: #4B2F1F; font-size: 28px; font-weight: bold; text-align: center; margin-bottom: 20px;">Transfer Details - Shipment ID: <?php echo htmlspecialchars($shipment_id); ?></h1>
            <div style="background-color: #FFFFFF; padding: 20px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                <h2 style="color: #4B2F1F; font-size: 22px; margin-bottom: 15px;">Transfer Details</h2>
                <table style="width: 100%; border-collapse: collapse;">
                    <tr style="border-bottom: 1px solid #F4F0E4;">
                        <th style="padding: 10px; text-align: left; color: #4B2F1F;">Field</th>
                        <th style="padding: 10px; text-align: left; color: #4B2F1F;">Value</th>
                    </tr>
                    <tr>
                        <td style="padding: 10px;">Shipment ID</td>
                        <td style="padding: 10px;"><?php echo htmlspecialchars($transfers[0]['shipment_id']); ?></td>
                    </tr>
                    <tr>
                        <td style="padding: 10px;">Sent By</td>
                        <td style="padding: 10px;"><?php echo htmlspecialchars($transfers[0]['sent_by'] ?? 'Unknown', ENT_QUOTES, 'UTF-8'); ?></td>
                    </tr>
                    <tr>
                        <td style="padding: 10px;">Received By</td>
                        <td style="padding: 10px;"><?php echo htmlspecialchars($transfers[0]['received_by'] ?? 'Pending', ENT_QUOTES, 'UTF-8'); ?></td>
                    </tr>
                    <tr>
                        <td style="padding: 10px;">Global Amount</td>
                        <td style="padding: 10px;"><?php echo number_format($transfers[0]['total_amount'], 0, ',', '.'); ?></td>
                    </tr>
                    <tr>
                        <td style="padding: 10px;">Status</td>
                        <td style="padding: 10px;"><?php echo htmlspecialchars(ucfirst($transfers[0]['status'])); ?></td>
                    </tr>
                    <tr>
                        <td style="padding: 10px;">Sent At</td>
                        <td style="padding: 10px;"><?php echo date('Y-m-d H:i', strtotime($transfers[0]['sent_at'])); ?></td>
                    </tr>
                    <tr>
                        <td style="padding: 10px;">Estimated Arrival</td>
                        <td style="padding: 10px;"><?php echo date('Y-m-d H:i', strtotime($transfers[0]['estimated_arrival'])); ?></td>
                    </tr>
                    <tr>
                        <td style="padding: 10px;">Received At</td>
                        <td style="padding: 10px;"><?php echo $transfers[0]['received_at'] ? date('Y-m-d H:i', strtotime($transfers[0]['received_at'])) : 'Not received'; ?></td>
                    </tr>
                    <tr>
                        <td style="padding: 10px;">Driver Name</td>
                        <td style="padding: 10px;"><?php echo htmlspecialchars($transfers[0]['driver_name'] ?? 'N/A', ENT_QUOTES, 'UTF-8'); ?></td>
                    </tr>
                    <tr>
                        <td style="padding: 10px;">Driver Mobile</td>
                        <td style="padding: 10px;"><?php echo htmlspecialchars($transfers[0]['driver_mobile'] ?? 'N/A', ENT_QUOTES, 'UTF-8'); ?></td>
                    </tr>
                    <tr>
                        <td style="padding: 10px;">Plate Number</td>
                        <td style="padding: 10px;"><?php echo htmlspecialchars($transfers[0]['plate_number'] ?? 'N/A', ENT_QUOTES, 'UTF-8'); ?></td>
                    </tr>
                </table>
                <h2 style="color: #4B2F1F; font-size: 22px; margin: 20px 0 15px;">Products Transferred</h2>
                <table style="width: 100%; border-collapse: collapse;">
                    <thead>
                        <tr style="background-color: #4B2F1F; color: #F4F0E4;">
                            <th style="padding: 10px; text-align: left;">Product</th>
                            <th style="padding: 10px; text-align: left;">Province</th>
                            <th style="padding: 10px; text-align: left;">Quantity</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($transfers as $transfer): ?>
                            <?php
                                $quantityCrates = (int)($transfer['quantity'] ?? 0);
                                $productName = $transfer['product_name'] ?? 'Unknown product';
                                $provinceName = $transfer['province_name'] ?? 'N/A';
                            ?>
                            <tr style="border-bottom: 1px solid #F4F0E4;">
                                <td style="padding: 10px;"><?php echo htmlspecialchars($productName, ENT_QUOTES, 'UTF-8'); ?></td>
                                <td style="padding: 10px;"><?php echo htmlspecialchars($provinceName, ENT_QUOTES, 'UTF-8'); ?></td>
                                <td style="padding: 10px;">
                                    <?php echo format_quantity($quantityCrates); ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                <a href="history.php" style="display: inline-block; margin-top: 20px; background-color: #4B2F1F; color: #F4F0E4; padding: 10px 20px; border-radius: 8px; text-decoration: none; font-size: 14px;">Back to History</a>
            </div>
        </div>
        <style>
            table tr:hover {
                background-color: #F4A26120;
            }
            a:hover {
                background-color: #F4A261;
                color: #4B2F1F;
                transform: translateY(-2px);
                box-shadow: 0 4px 8px rgba(0,0,0,0.3);
            }
            @media (max-width: 768px) {
                .container {
                    padding: 10px;
                }
                .container > div {
                    max-width: 90%;
                }
                h1, h2 {
                    font-size: 20px;
                }
                table th, table td {
                    font-size: 13px;
                }
            }
            @media (max-width: 480px) {
                .container {
                    padding: 5px;
                }
                .container > div {
                    max-width: 95%;
                }
                h1, h2 {
                    font-size: 18px;
                }
                table th, table td, a {
                    font-size: 12px;
                }
            }
        </style>
    </div>
</body>
<?php include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/footer.php'; ?>
