<?php
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/auth.php';
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/functions.php';
require_login();

// Restrict to Stock Manager role
$conn = get_db_connection();
if (!$conn) {
    error_log("Database connection failed in stock_transfer_history.php");
    echo "<p style='color: #FF0000; text-align: center; padding: 20px;'>Database connection failed. Contact administrator.</p>";
    include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/footer.php';
    exit;
}
$stmt = $conn->prepare("SELECT r.name FROM role r JOIN user u ON u.role_id = r.id WHERE u.id = ?");
$stmt->bind_param("i", $_SESSION['user_id']);
$stmt->execute();
$role = $stmt->get_result()->fetch_assoc()['name'] ?? '';
$stmt->close();
if ($role !== 'Stock Manager') {
    error_log("Unauthorized access to stock_transfer_history.php by user {$_SESSION['full_name']} (Role: $role)");
    header("Location: /masunzu_bar_hotel/dashboards/" . strtolower(str_replace(' ', '_', $role)) . "_dashboard.php");
    exit;
}

// Fetch province_id
$province_id = $_SESSION['province_id'] ?? null;
if ($province_id === null || $province_id === '') {
    $stmt = $conn->prepare("SELECT province_id FROM user WHERE id = ?");
    $stmt->bind_param("i", $_SESSION['user_id']);
    $stmt->execute();
    $province_id = $stmt->get_result()->fetch_assoc()['province_id'] ?? null;
    $_SESSION['province_id'] = $province_id;
    $stmt->close();
}
$province_id = $_SESSION['province_id'] ?? null;
if ($province_id === null || $province_id === '') {
    error_log("No province_id for user {$_SESSION['full_name']} (ID: {$_SESSION['user_id']})");
    echo "<p style='color: #FF0000; text-align: center; padding: 20px;'>Error: No province assigned. Contact administrator.</p>";
    include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/footer.php';
    exit;
}
$province_id = (int)$province_id;

// Fetch stock transfer history
$stmt = $conn->prepare("
    SELECT t.id, t.shipment_id, t.sent_at, t.received_at, t.estimated_arrival, t.driver_name, t.driver_mobile, t.plate_number, 
           t.total_amount, t.total_products, p.name AS product_name, t.quantity, p.crate_quantity, t.status
    FROM stock_transfer t
    JOIN product p ON t.product_id = p.id
    WHERE t.province_id = ? AND t.status IN ('pending', 'confirmed', 'rejected')
    ORDER BY t.sent_at DESC
");
$stmt->bind_param("i", $province_id);
$stmt->execute();
$transfers = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();

// Fetch stock split history
$stmt = $conn->prepare("
    SELECT s.id, p.name AS product_name, s.quantity_to_wholesale, s.quantity_to_retail, s.split_at
    FROM stock_split s
    JOIN product p ON s.product_id = p.id
    WHERE s.province_id = ? AND s.stock_manager_id = ?
    ORDER BY s.split_at DESC
");
$stmt->bind_param("ii", $province_id, $_SESSION['user_id']);
$stmt->execute();
$splits = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();

$conn->close();
include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/header.php';
?>
<div class="container" style="padding: 20px; background: linear-gradient(135deg, #4B2F1F 0%, #F4A261 100%); min-height: 100vh;">
    <div class="content" style="background-color: #F4F0E4; padding: 30px; border-radius: 12px; box-shadow: 0 6px 12px rgba(0,0,0,0.15); max-width: 1200px; margin: 30px auto;">
        <h2 style="color: #4B2F1F; font-size: 28px; margin-bottom: 15px; font-weight: 600; text-align: center;">Stock Transfer and Split History</h2>
        <p style="color: #4B2F1F; font-size: 16px; text-align: center;">History for <?php echo htmlspecialchars($_SESSION['full_name'] ?? 'Unknown', ENT_QUOTES, 'UTF-8'); ?> (Stock Manager)</p>
        
        <h3 style="color: #4B2F1F; margin-top: 20px; margin-bottom: 10px;">Stock Transfer History</h3>
        <?php if (empty($transfers)): ?>
            <p style="color: #4B2F1F; font-size: 16px; text-align: center;">No stock transfers found.</p>
        <?php else: ?>
            <div style="overflow-x: auto;">
                <table style="width: 100%; border-collapse: collapse; background-color: #FFFFFF; border-radius: 8px; overflow: hidden; margin-bottom: 20px;">
                    <thead>
                        <tr style="background-color: #4B2F1F; color: #F4F0E4;">
                            <th style="padding: 15px; text-align: left; width: 5%;">ID</th>
                            <th style="padding: 15px; text-align: left; width: 5%;">Shipment ID</th>
                            <th style="padding: 15px; text-align: left; width: 15%;">Product</th>
                            <th style="padding: 15px; text-align: left; width: 7%;">Bottles</th>
                            <th style="padding: 15px; text-align: left; width: 7%;">Crates</th>
                            <th style="padding: 15px; text-align: left; width: 10%;">Status</th>
                            <th style="padding: 15px; text-align: left; width: 10%;">Sent At</th>
                            <th style="padding: 15px; text-align: left; width: 10%;">Received At</th>
                            <th style="padding: 15px; text-align: left; width: 10%;">Estimated Arrival</th>
                            <th style="padding: 15px; text-align: left; width: 10%;">Driver</th>
                            <th style="padding: 15px; text-align: left; width: 8%;">Mobile</th>
                            <th style="padding: 15px; text-align: left; width: 8%;">Plate Number</th>
                            <th style="padding: 15px; text-align: left; width: 10%;">Total Amount (BIF)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($transfers as $transfer): ?>
                            <tr style="border-bottom: 1px solid #F4F0E4;">
                                <td style="padding: 15px; text-align: left;"><?php echo htmlspecialchars($transfer['id'], ENT_QUOTES, 'UTF-8'); ?></td>
                                <td style="padding: 15px; text-align: left;">
                                    <a href="/masunzu_bar_hotel/modules/operation/transfer_details.php?shipment_id=<?php echo htmlspecialchars($transfer['shipment_id'], ENT_QUOTES, 'UTF-8'); ?>" style="color: #4B2F1F; text-decoration: underline;">
                                        <?php echo htmlspecialchars($transfer['shipment_id'], ENT_QUOTES, 'UTF-8'); ?>
                                    </a>
                                </td>
                                <td style="padding: 15px; text-align: left;"><?php echo htmlspecialchars($transfer['product_name'], ENT_QUOTES, 'UTF-8'); ?></td>
                                <td style="padding: 15px; text-align: left;"><?php echo number_format($transfer['quantity'], 0, ',', '.'); ?></td>
                                <td style="padding: 15px; text-align: left;"><?php echo number_format($transfer['quantity'] / ($transfer['crate_quantity'] ?? 12), 1, '.', ''); ?></td>
                                <td style="padding: 15px; text-align: left;"><?php echo htmlspecialchars(ucfirst($transfer['status']), ENT_QUOTES, 'UTF-8'); ?></td>
                                <td style="padding: 15px; text-align: left;"><?php echo date('Y-m-d H:i', strtotime($transfer['sent_at'])); ?></td>
                                <td style="padding: 15px; text-align: left;"><?php echo $transfer['received_at'] ? date('Y-m-d H:i', strtotime($transfer['received_at'])) : 'N/A'; ?></td>
                                <td style="padding: 15px; text-align: left;"><?php echo date('Y-m-d H:i', strtotime($transfer['estimated_arrival'])); ?></td>
                                <td style="padding: 15px; text-align: left;"><?php echo htmlspecialchars($transfer['driver_name'], ENT_QUOTES, 'UTF-8'); ?></td>
                                <td style="padding: 15px; text-align: left;"><?php echo htmlspecialchars($transfer['driver_mobile'], ENT_QUOTES, 'UTF-8'); ?></td>
                                <td style="padding: 15px; text-align: left;"><?php echo htmlspecialchars($transfer['plate_number'], ENT_QUOTES, 'UTF-8'); ?></td>
                                <td style="padding: 15px; text-align: left;"><?php echo number_format($transfer['total_amount'], 2, ',', '.'); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
        
        <h3 style="color: #4B2F1F; margin-top: 20px; margin-bottom: 10px;">Stock Split History</h3>
        <?php if (empty($splits)): ?>
            <p style="color: #4B2F1F; font-size: 16px; text-align: center;">No stock splits found.</p>
        <?php else: ?>
            <div style="overflow-x: auto;">
                <table style="width: 100%; border-collapse: collapse; background-color: #FFFFFF; border-radius: 8px; overflow: hidden; margin-bottom: 20px;">
                    <thead>
                        <tr style="background-color: #4B2F1F; color: #F4F0E4;">
                            <th style="padding: 15px; text-align: left; width: 10%;">ID</th>
                            <th style="padding: 15px; text-align: left; width: 25%;">Product</th>
                            <th style="padding: 15px; text-align: left; width: 15%;">To Wholesale</th>
                            <th style="padding: 15px; text-align: left; width: 15%;">To Retail</th>
                            <th style="padding: 15px; text-align: left; width: 35%;">Split At</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($splits as $split): ?>
                            <tr style="border-bottom: 1px solid #F4F0E4;">
                                <td style="padding: 15px; text-align: left;"><?php echo htmlspecialchars($split['id'], ENT_QUOTES, 'UTF-8'); ?></td>
                                <td style="padding: 15px; text-align: left;"><?php echo htmlspecialchars($split['product_name'], ENT_QUOTES, 'UTF-8'); ?></td>
                                <td style="padding: 15px; text-align: left;"><?php echo number_format($split['quantity_to_wholesale'], 0, ',', '.'); ?></td>
                                <td style="padding: 15px; text-align: left;"><?php echo number_format($split['quantity_to_retail'], 0, ',', '.'); ?></td>
                                <td style="padding: 15px; text-align: left;"><?php echo date('Y-m-d H:i', strtotime($split['split_at'])); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
    <style>
        table { min-width: 800px; }
        a:hover {
            background-color: #F4A261;
            color: #4B2F1F;
            transition: all 0.3s ease;
        }
        @media (max-width: 768px) {
            .container { padding: 15px; }
            .content { padding: 20px; }
            h2 { font-size: 24px; }
            h3 { font-size: 20px; }
            p { font-size: 14px; }
            table { font-size: 14px; }
        }
        @media (max-width: 480px) {
            h2 { font-size: 20px; }
            h3 { font-size: 18px; }
            p { font-size: 12px; }
            table { font-size: 12px; }
        }
    </style>
</div>
<?php include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/footer.php'; ?>
