<?php
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/auth.php';
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/functions.php';
require_login();

// Restrict to Operation Manager role
if ($_SESSION['role_name'] !== 'Operation Manager') {
    error_log("Unauthorized access to history.php by user {$_SESSION['full_name']} (Role: {$_SESSION['role_name']})");
    header("Location: /masunzu_bar_hotel/dashboards/" . strtolower(str_replace(' ', '_', $_SESSION['role_name'])) . "_dashboard.php");
    exit;
}

// Initialize database connection
$conn = get_db_connection();
if (!$conn) {
    error_log("Database connection failed in history.php: " . mysqli_connect_error());
    echo "<p style='color: #FF0000; text-align: center; padding: 20px;'>Database connection failed. Contact administrator.</p>";
    include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/footer.php';
    exit;
}

// Fetch products and provinces for filters
$products_query = $conn->query("SELECT id, name, crate_quantity FROM product ORDER BY name");
$products = $products_query->fetch_all(MYSQLI_ASSOC);
$provinces_query = $conn->query("SELECT id, name FROM province ORDER BY name");
$provinces = $provinces_query->fetch_all(MYSQLI_ASSOC);

// Fetch users for sent/received by names
$users_query = $conn->query("SELECT id, full_name FROM user WHERE role_id IN (5, 8)"); // Operation Manager and Stock Manager
$users = $users_query->fetch_all(MYSQLI_ASSOC);
$user_map = array_column($users, 'full_name', 'id');

// Handle filters
$where_clauses = [];
$params = [];
$param_types = '';
$start_date = $_GET['start_date'] ?? '';
$end_date = $_GET['end_date'] ?? '';
$product_id = $_GET['product_id'] ?? '';
$province_id = $_GET['province_id'] ?? '';

if ($start_date) {
    $where_clauses[] = "DATE(sent_at) >= ?";
    $params[] = $start_date;
    $param_types .= 's';
}
if ($end_date) {
    $where_clauses[] = "DATE(sent_at) <= ?";
    $params[] = $end_date;
    $param_types .= 's';
}
if ($product_id) {
    $where_clauses[] = "product_id = ?";
    $params[] = $product_id;
    $param_types .= 'i';
}
if ($province_id) {
    $where_clauses[] = "province_id = ?";
    $params[] = $province_id;
    $param_types .= 'i';
}

// Fetch stock transfer history
$transfer_query = "SELECT st.shipment_id, st.operation_manager_id, st.stock_manager_id, st.total_amount, st.status, st.sent_at, 
                         st.quantity, st.unit_type, p.name AS product_name, p.crate_quantity, pr.name AS province_name
                  FROM stock_transfer st
                  LEFT JOIN product p ON st.product_id = p.id
                  LEFT JOIN province pr ON st.province_id = pr.id";
if (!empty($where_clauses)) {
    $transfer_query .= " WHERE " . implode(' AND ', $where_clauses);
}
$transfer_query .= " ORDER BY st.sent_at DESC";
$stmt = $conn->prepare($transfer_query);
if ($param_types) {
    $stmt->bind_param($param_types, ...$params);
}
$stmt->execute();
$transfers = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();

// Calculate metrics for today (2025-10-19)
$total_bottles_today = 0;
$total_crates_today = 0;
$total_transfers = count(array_unique(array_column($transfers, 'shipment_id')));
$current_date = date('Y-m-d'); // Use current date: 2025-10-19

foreach ($transfers as $transfer) {
    if (date('Y-m-d', strtotime($transfer['sent_at'])) === $current_date) {
        // Calculate bottles
        $bottles = $transfer['unit_type'] === 'crates' ? $transfer['quantity'] * $transfer['crate_quantity'] : $transfer['quantity'];
        $total_bottles_today += $bottles;
        // Calculate crates
        $crates = $transfer['unit_type'] === 'crates' ? $transfer['quantity'] : $transfer['quantity'] / $transfer['crate_quantity'];
        $total_crates_today += $crates;
    }
}

$conn->close();
include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/header.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
</head>
<body>
    <div class="container" style="padding: 20px; background: linear-gradient(135deg, #4B2F1F 0%, #F4A261 100%); min-height: 100vh; box-sizing: border-box;">
        <div style="max-width: 1200px; margin: 30px auto;">
            <h1 style="color: #4B2F1F; font-size: 28px; font-weight: bold; text-align: center; margin-bottom: 20px;">Stock Transfer History</h1>
            
            <!-- Summary Metrics -->
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; margin-bottom: 30px;">
                <div style="background-color: #FFFFFF; padding: 15px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); text-align: center;">
                    <h3 style="color: #4B2F1F; font-size: 18px; margin-bottom: 10px;">Total Transfers</h3>
                    <p style="color: #4B2F1F; font-size: 24px; font-weight: bold;"><?php echo number_format($total_transfers, 0, ',', '.'); ?></p>
                </div>
                <div style="background-color: #FFFFFF; padding: 15px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); text-align: center;">
                    <h3 style="color: #4B2F1F; font-size: 18px; margin-bottom: 10px;">Total Bottles Transferred Today</h3>
                    <p style="color: #4B2F1F; font-size: 24px; font-weight: bold;"><?php echo number_format($total_bottles_today, 0, ',', '.'); ?></p>
                </div>
                <div style="background-color: #FFFFFF; padding: 15px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); text-align: center;">
                    <h3 style="color: #4B2F1F; font-size: 18px; margin-bottom: 10px;">Total Crates Transferred Today</h3>
                    <p style="color: #4B2F1F; font-size: 24px; font-weight: bold;"><?php echo number_format($total_crates_today, 0, ',', '.'); ?></p>
                </div>
            </div>

            <!-- Filters -->
            <div style="background-color: #FFFFFF; padding: 20px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); margin-bottom: 30px;">
                <form method="GET" style="display: flex; flex-wrap: wrap; gap: 15px;">
                    <div style="flex: 1; min-width: 150px;">
                        <label for="start_date" style="color: #4B2F1F; font-size: 14px; font-weight: 500;">Start Date</label>
                        <input type="date" id="start_date" name="start_date" value="<?php echo htmlspecialchars($start_date); ?>" style="width: 100%; padding: 10px; border: 1px solid #4B2F1F; border-radius: 8px; font-size: 14px;">
                    </div>
                    <div style="flex: 1; min-width: 150px;">
                        <label for="end_date" style="color: #4B2F1F; font-size: 14px; font-weight: 500;">End Date</label>
                        <input type="date" id="end_date" name="end_date" value="<?php echo htmlspecialchars($end_date); ?>" style="width: 100%; padding: 10px; border: 1px solid #4B2F1F; border-radius: 8px; font-size: 14px;">
                    </div>
                    <div style="flex: 1; min-width: 150px;">
                        <label for="product_id" style="color: #4B2F1F; font-size: 14px; font-weight: 500;">Product</label>
                        <select id="product_id" name="product_id" style="width: 100%; padding: 10px; border: 1px solid #4B2F1F; border-radius: 8px; font-size: 14px;">
                            <option value="">All Products</option>
                            <?php foreach ($products as $product): ?>
                                <option value="<?php echo $product['id']; ?>" <?php echo $product_id == $product['id'] ? 'selected' : ''; ?>>
                                    <?php echo htmlspecialchars($product['name'], ENT_QUOTES, 'UTF-8'); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div style="flex: 1; min-width: 150px;">
                        <label for="province_id" style="color: #4B2F1F; font-size: 14px; font-weight: 500;">Province</label>
                        <select id="province_id" name="province_id" style="width: 100%; padding: 10px; border: 1px solid #4B2F1F; border-radius: 8px; font-size: 14px;">
                            <option value="">All Provinces</option>
                            <?php foreach ($provinces as $province): ?>
                                <option value="<?php echo $province['id']; ?>" <?php echo $province_id == $province['id'] ? 'selected' : ''; ?>>
                                    <?php echo htmlspecialchars($province['name'], ENT_QUOTES, 'UTF-8'); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div style="flex: 1; min-width: 150px; display: flex; align-items: flex-end;">
                        <button type="submit" style="background-color: #4B2F1F; color: #F4F0E4; padding: 10px; border: none; border-radius: 8px; font-size: 14px; cursor: pointer; width: 100%;">Apply Filters</button>
                    </div>
                </form>
            </div>

            <!-- Stock Transfer History -->
            <div style="background-color: #FFFFFF; padding: 20px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); margin-bottom: 30px;">
                <h2 style="color: #4B2F1F; font-size: 22px; margin-bottom: 15px;">Stock Transfer History</h2>
                <div style="margin-bottom: 15px;">
                    <input type="text" id="transferSearch" placeholder="Search transfers..." style="width: 100%; padding: 10px; border: 1px solid #4B2F1F; border-radius: 8px; font-size: 14px;">
                </div>
                <?php if (empty($transfers)): ?>
                    <p style="color: #4B2F1F;">No stock transfers found.</p>
                <?php else: ?>
                    <div style="overflow-x: auto;">
                        <table id="stockTable" style="width: 100%; border-collapse: collapse;">
                            <thead>
                                <tr style="background-color: #4B2F1F; color: #F4F0E4;">
                                    <th style="padding: 10px; text-align: left;">Shipment ID</th>
                                    <th style="padding: 10px; text-align: left;">Sent By</th>
                                    <th style="padding: 10px; text-align: left;">Received By</th>
                                    <th style="padding: 10px; text-align: left;">Global Amount</th>
                                    <th style="padding: 10px; text-align: left;">Status</th>
                                    <th style="padding: 10px; text-align: left;">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $current_shipment_id = null;
                                foreach ($transfers as $transfer):
                                    $is_new_shipment = $transfer['shipment_id'] !== $current_shipment_id;
                                    $current_shipment_id = $transfer['shipment_id'];
                                    $sent_by = isset($user_map[$transfer['operation_manager_id']]) ? $user_map[$transfer['operation_manager_id']] : 'Unknown';
                                    $received_by = isset($user_map[$transfer['stock_manager_id']]) ? $user_map[$transfer['stock_manager_id']] : 'Pending';
                                ?>
                                    <tr style="border-bottom: 1px solid #F4F0E4;" data-search="<?php echo htmlspecialchars(strtolower($transfer['product_name'] . ' ' . $transfer['province_name'] . ' ' . $transfer['shipment_id'] . ' ' . $sent_by . ' ' . $received_by), ENT_QUOTES, 'UTF-8'); ?>">
                                        <td style="padding: 10px;"><?php echo $is_new_shipment ? htmlspecialchars($transfer['shipment_id']) : ''; ?></td>
                                        <td style="padding: 10px;"><?php echo htmlspecialchars($sent_by); ?></td>
                                        <td style="padding: 10px;"><?php echo htmlspecialchars($received_by); ?></td>
                                        <td style="padding: 10px;"><?php echo $is_new_shipment ? number_format($transfer['total_amount'], 0, ',', '.') : ''; ?></td>
                                        <td style="padding: 10px;"><?php echo htmlspecialchars(ucfirst($transfer['status'])); ?></td>
                                        <td style="padding: 10px;">
                                            <?php if ($is_new_shipment): ?>
                                                <a href="transfer_details.php?shipment_id=<?php echo $transfer['shipment_id']; ?>" style="background-color: #4B2F1F; color: #F4F0E4; padding: 8px 12px; border-radius: 8px; text-decoration: none; font-size: 14px;">View More</a>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <script>
            $(document).ready(function() {
                $('#product_id, #province_id').select2({
                    placeholder: "Select an option",
                    allowClear: true,
                    width: '100%'
                });

                // Search functionality for transfers
                document.getElementById('transferSearch').addEventListener('input', function(e) {
                    const searchTerm = e.target.value.toLowerCase();
                    const rows = document.querySelectorAll('#stockTable tbody tr');
                    rows.forEach(row => {
                        const searchData = row.getAttribute('data-search');
                        row.style.display = searchData.includes(searchTerm) ? '' : 'none';
                    });
                });
            });
        </script>
        <style>
            table tr:hover {
                background-color: #F4A26120;
            }
            input:focus, select:focus {
                outline: none;
                border-color: #F4A261;
                box-shadow: 0 0 5px rgba(244, 162, 97, 0.5);
            }
            button:hover, a:hover {
                background-color: #F4A261;
                color: #4B2F1F;
                transform: translateY(-2px);
                box-shadow: 0 4px 8px rgba(0,0,0,0.3);
            }
            .select2-container {
                width: 100% !important;
            }
            .select2-selection--single {
                border: 1px solid #4B2F1F !important;
                border-radius: 8px !important;
                padding: 8px !important;
                font-size: 14px !important;
                height: auto !important;
            }
            .select2-selection__rendered {
                color: #4B2F1F !important;
            }
            .select2-selection__arrow {
                height: 34px !important;
            }
            @media (max-width: 768px) {
                .container {
                    padding: 10px;
                }
                .container > div {
                    max-width: 90%;
                }
                h1, h2 {
                    font-size: 20px;
                }
                h3 {
                    font-size: 16px;
                }
                label, select, input, button, table th, table td, a {
                    font-size: 13px;
                }
                .select2-selection--single {
                    padding: 6px !important;
                    font-size: 13px !important;
                }
            }
            @media (max-width: 480px) {
                .container {
                    padding: 5px;
                }
                .container > div {
                    max-width: 95%;
                }
                h1, h2 {
                    font-size: 18px;
                }
                h3 {
                    font-size: 14px;
                }
                label, select, input, button, table th, table td, a {
                    font-size: 12px;
                }
                .select2-selection--single {
                    padding: 5px !important;
                    font-size: 12px !important;
                }
                .select2-selection__arrow {
                    height: 30px !important;
                }
            }
        </style>
    </div>
</body>
<?php include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/footer.php'; ?>