<?php
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/auth.php';
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/functions.php';
require_login();

// Restrict to Operation Manager role
if ($_SESSION['role_name'] !== 'Operation Manager') {
    error_log("Unauthorized access to distribution.php by user {$_SESSION['full_name']} ({$_SESSION['role_name']})");
    header("Location: /masunzu_bar_hotel/dashboards/admin_dashboard.php");
    exit;
}

// Fetch provinces and stock for distribution
$conn = get_db_connection();
if (!$conn) {
    die("Database connection failed");
}
$provinces_result = $conn->query("SELECT id, name FROM province");
$provinces = $provinces_result->fetch_all(MYSQLI_ASSOC);
$products_result = $conn->query("SELECT id, name FROM product");
$products = $products_result->fetch_all(MYSQLI_ASSOC);
$conn->close();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $province_id = (int)$_POST['province_id'];
    $product_id = (int)$_POST['product_id'];
    $quantity = (int)$_POST['quantity'];
    $stock_type = $_POST['stock_type'] ?? 'wholesale';

    if ($province_id && $product_id && $quantity > 0) {
        $conn = get_db_connection();
        $stmt = $conn->prepare("INSERT INTO stock (province_id, product_id, stock_type, quantity) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("iiis", $province_id, $product_id, $stock_type, $quantity);
        $stmt->execute();
        $stmt->close();
        $conn->close();
        log_action($_SESSION['user_id'], 'distribute_stock', "Distributed $quantity units of product ID $product_id to province ID $province_id");
        header("Location: /masunzu_bar_hotel/modules/operation/distribution.php");
        exit;
    } else {
        $error = "All fields are required and quantity must be greater than 0.";
    }
}
include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/header.php';
?>
<div class="dashboard-container" style="padding: 20px; background-color: #F4F0E4; min-height: 70vh;">
    <div class="dashboard-header" style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
        <h1 style="color: #4B2F1F; font-size: 28px; font-weight: bold; margin: 0;">Stock Distribution</h1>
        <a href="/masunzu_bar_hotel/modules/operation/history.php" style="background-color: #F4A261; color: #000000; padding: 10px 20px; border-radius: 8px; text-decoration: none; font-weight: bold;">View History</a>
    </div>
    <div class="dashboard-content" style="background-color: #FFFFFF; padding: 20px; border-radius: 10px; box-shadow: 0 4px 8px rgba(0,0,0,0.1);">
        <h2 style="color: #4B2F1F; margin-bottom: 20px;">Distribute Stock to Province</h2>
        <?php if (isset($error)): ?>
            <p style="color: red; font-size: 0.9em; margin-bottom: 10px;"><?php echo htmlspecialchars($error); ?></p>
        <?php endif; ?>
        <form method="POST">
            <select name="province_id" required style="width: 100%; padding: 12px; margin: 10px 0; border: 2px solid #4B2F1F; border-radius: 8px; font-size: 16px;">
                <option value="">Select Province</option>
                <?php foreach ($provinces as $province): ?>
                    <option value="<?php echo $province['id']; ?>"><?php echo htmlspecialchars($province['name']); ?></option>
                <?php endforeach; ?>
            </select>
            <select name="product_id" required style="width: 100%; padding: 12px; margin: 10px 0; border: 2px solid #4B2F1F; border-radius: 8px; font-size: 16px;">
                <option value="">Select Product</option>
                <?php foreach ($products as $product): ?>
                    <option value="<?php echo $product['id']; ?>"><?php echo htmlspecialchars($product['name']); ?></option>
                <?php endforeach; ?>
            </select>
            <input type="number" name="quantity" placeholder="Quantity" min="1" required style="width: 100%; padding: 12px; margin: 10px 0; border: 2px solid #4B2F1F; border-radius: 8px; font-size: 16px;">
            <select name="stock_type" required style="width: 100%; padding: 12px; margin: 10px 0; border: 2px solid #4B2F1F; border-radius: 8px; font-size: 16px;">
                <option value="wholesale">Wholesale</option>
                <option value="retail">Retail</option>
            </select>
            <button type="submit" style="background-color: #F4A261; color: #000000; padding: 12px; border: none; border-radius: 8px; cursor: pointer; width: 100%; font-size: 16px; font-weight: bold;">Distribute Stock</button>
        </form>
    </div>
</div>
<?php include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/footer.php'; ?>