<?php
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../includes/functions.php';

require_login();
$allowed_roles = ['DG', 'DGA', 'Admin'];
if (!in_array($_SESSION['role_name'] ?? '', $allowed_roles, true)) {
    error_log("Unauthorized access to approve_order.php by user {$_SESSION['full_name']} ({$_SESSION['role_name']})");
    redirect("/masunzu_bar_hotel/dashboards/" . strtolower(str_replace(' ', '_', $_SESSION['role_name'] ?? '')) . "_dashboard.php");
}

$conn = get_db_connection();
if (!$conn) {
    error_log("Database connection failed in approve_order.php");
    echo "<p style='color: #FF0000; text-align: center; padding: 20px;'>Database connection failed. Contact administrator.</p>";
    include __DIR__ . '/../../includes/footer.php';
    exit;
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $order_id = (int)($_POST['order_id'] ?? 0);
    $action = isset($_POST['approve']) ? 'approve' : (isset($_POST['reject']) ? 'reject' : '');

    if ($order_id <= 0 || !in_array($action, ['approve', 'reject'])) {
        $error = 'Invalid order or action.';
    } else {
        // Fetch order details with crate_quantity
        $stmt = $conn->prepare("SELECT o.product_id, o.quantity, o.province_id, o.order_type, p.crate_quantity, p.name AS product_name 
                                FROM `order` o 
                                JOIN product p ON o.product_id = p.id 
                                WHERE o.id = ?");
        $stmt->bind_param("i", $order_id);
        $stmt->execute();
        $order = $stmt->get_result()->fetch_assoc();
        $stmt->close();

        if (!$order) {
            $error = 'Order not found.';
        } else {
            if ($order['order_type'] !== 'wholesale') {
                $error = 'Only wholesale orders are supported.';
            } else {
                $requested_crates = (int)$order['quantity'];
                if ($requested_crates <= 0) {
                    $error = 'Invalid quantity for the order.';
                } elseif ($action === 'approve') {
                    $stmt = $conn->prepare("SELECT quantity FROM wholesale_stock WHERE product_id = ? AND province_id = ?");
                    $stmt->bind_param("ii", $order['product_id'], $order['province_id']);
                    $stmt->execute();
                    $stock = $stmt->get_result()->fetch_assoc();
                    $stmt->close();

                    $available_crates = (int)($stock['quantity'] ?? 0);
                    if ($requested_crates > $available_crates) {
                        $error = 'Insufficient stock in wholesale inventory: ' . format_quantity($available_crates) . ' available.';
                    } else {
                        $stmt = $conn->prepare("UPDATE wholesale_stock SET quantity = ?, unit_type = 'crates', last_updated = NOW() WHERE product_id = ? AND province_id = ?");
                        $new_quantity = $available_crates - $requested_crates;
                        $stmt->bind_param("iii", $new_quantity, $order['product_id'], $order['province_id']);
                        $stmt->execute();
                        $stmt->close();

                        $stmt = $conn->prepare("UPDATE `order` SET status = 'approved', approved_by_operation_manager = ? WHERE id = ?");
                        $stmt->bind_param("ii", $_SESSION['user_id'], $order_id);
                        $stmt->execute();
                        $stmt->close();

                        log_action($_SESSION['user_id'], 'approve_order', "Approved order ID $order_id for {$order['product_name']}", $order['product_id'], $requested_crates);
                        $success = 'Order approved successfully!';
                    }
                } else {
                    $stmt = $conn->prepare("UPDATE `order` SET status = 'rejected', approved_by_operation_manager = ? WHERE id = ?");
                    $stmt->bind_param("ii", $_SESSION['user_id'], $order_id);
                    $stmt->execute();
                    $stmt->close();

                    log_action($_SESSION['user_id'], 'reject_order', "Rejected order ID $order_id for {$order['product_name']}", $order['product_id'], $requested_crates);
                    $success = 'Order rejected successfully!';
                }
            }
        }
    }
}

$conn->close();
redirect("/masunzu_bar_hotel/dashboards/operation_dashboard.php");
?>
