<?php
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/auth.php';
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/functions.php';

if (is_logged_in()) {
    redirect_to_dashboard();
}

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    
    if ($username && $password) {
        $login_result = login($username, $password);
        if ($login_result['success']) {
            redirect_to_dashboard();
        } else {
            $error = $login_result['error'] ?? 'Nom d\'utilisateur ou mot de passe incorrect.';
        }
    } else {
        $error = 'Veuillez remplir tous les champs.';
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Connexion - Société Masunzu Bar Hotel</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: linear-gradient(135deg, #4B2F1F 0%, #F4A261 100%);
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            color: #000000;
        }
        .login-container {
            background-color: #F4F0E4; /* Off-White */
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.2);
            width: 100%;
            max-width: 400px;
            text-align: center;
        }
        .login-container img {
            max-width: 150px;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        .login-container h1 {
            color: #4B2F1F; /* Dark Brown */
            margin-bottom: 20px;
            font-size: 24px;
        }
        .login-container input {
            width: 100%;
            padding: 12px;
            margin: 10px 0;
            border: 2px solid #4B2F1F;
            border-radius: 8px;
            font-size: 16px;
        }
        .login-container button {
            width: 100%;
            padding: 12px;
            background-color: #F4A261; /* Bright Orange */
            color: #000000;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            cursor: pointer;
            font-weight: bold;
        }
        .login-container button:hover {
            background-color: #e5894a;
        }
        .error {
            color: red;
            font-size: 0.9em;
            margin-bottom: 10px;
            background-color: #FFFFFF;
            padding: 10px;
            border-radius: 5px;
            border: 1px solid red;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <img src="/masunzu_bar_hotel/assets/images/logo.png" alt="Masunzu Bar Hotel Logo">
        <h1>Société Masunzu Bar Hotel</h1>
        <?php if ($error): ?>
            <div class="error"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>
        <form method="POST">
            <input type="text" name="username" placeholder="Nom d'utilisateur" required>
            <input type="password" name="password" placeholder="Mot de passe" required>
            <button type="submit">Connexion</button>
        </form>
    </div>
</body>
</html>