<?php
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/functions.php';

require_login();

// Restrict to DG, DGA, Admin, Board
$allowedRoles = ['DG', 'DGA', 'Admin', 'Board'];
$roleName = $_SESSION['role_name'] ?? '';
if (!in_array($roleName, $allowedRoles, true)) {
    header("Location: /masunzu_bar_hotel/dashboards/admin_dashboard.php");
    exit;
}

// Initialize database connection
$conn = get_db_connection();
if (!$conn) {
    error_log("Database connection failed in manage_accountant.php: " . mysqli_connect_error());
    include __DIR__ . '/../../includes/header.php';
    echo "<div style='padding: 40px; text-align: center;'><p style='color: #C62828;'>Échec de la connexion à la base de données. Contactez l'administrateur.</p></div>";
    include __DIR__ . '/../../includes/footer.php';
    exit;
}

// Fetch accountants (role_id = 4 for Accountant)
$accountants = [];
$stmt = $conn->prepare("
    SELECT u.id, u.full_name, u.email, u.is_active, u.created_at,
           COALESCE(p.name, 'Non assigné') AS province_name,
           r.name AS role_name
    FROM user u 
    LEFT JOIN province p ON u.province_id = p.id 
    LEFT JOIN role r ON u.role_id = r.id
    WHERE r.name = 'Accountant'
    ORDER BY u.full_name
");
$stmt->execute();
$accountants = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();
$conn->close();

include __DIR__ . '/../../includes/header.php';
?>
<div style="padding: 20px; background-color: #F4F0E4; min-height: 70vh;">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
        <div>
            <h1 style="color: #4B2F1F; font-size: 28px; font-weight: 700; margin: 0 0 8px 0;">Gérer les Comptables</h1>
            <p style="color: #6B4F2F; margin: 0; font-size: 14px;">
                Voir et gérer les comptables. Cliquez sur "Voir Transactions" pour consulter leurs opérations.
            </p>
        </div>
        <div style="background: linear-gradient(135deg, #4B2F1F 0%, #6B4F2F 100%); color: #F4F0E4; padding: 15px 25px; border-radius: 10px; text-align: center;">
            <p style="margin: 0; font-size: 12px; text-transform: uppercase; letter-spacing: 0.05em; opacity: 0.8;">Total Comptables</p>
            <p style="margin: 5px 0 0; font-size: 28px; font-weight: 700;"><?php echo count($accountants); ?></p>
        </div>
    </div>

    <div style="background: #fff; border-radius: 12px; box-shadow: 0 2px 8px rgba(0,0,0,0.06); overflow: hidden;">
        <?php if (empty($accountants)): ?>
            <div style="padding: 60px 20px; text-align: center;">
                <div style="font-size: 64px; margin-bottom: 15px;">👤</div>
                <p style="color: #4B2F1F; font-size: 18px; font-weight: 600; margin: 0 0 8px;">Aucun comptable trouvé</p>
                <p style="color: #6B4F2F; font-size: 14px; margin: 0;">
                    Ajoutez un utilisateur avec le rôle "Accountant" pour le voir apparaître ici.
                </p>
            </div>
        <?php else: ?>
            <div style="overflow-x: auto;">
                <table style="width: 100%; border-collapse: collapse; min-width: 700px;">
                    <thead>
                        <tr style="background-color: #4B2F1F; color: #F4F0E4;">
                            <th style="padding: 14px 16px; text-align: left; font-weight: 600; font-size: 13px; text-transform: uppercase; letter-spacing: 0.03em;">Nom Complet</th>
                            <th style="padding: 14px 16px; text-align: left; font-weight: 600; font-size: 13px; text-transform: uppercase; letter-spacing: 0.03em;">Email</th>
                            <th style="padding: 14px 16px; text-align: left; font-weight: 600; font-size: 13px; text-transform: uppercase; letter-spacing: 0.03em;">Province</th>
                            <th style="padding: 14px 16px; text-align: center; font-weight: 600; font-size: 13px; text-transform: uppercase; letter-spacing: 0.03em;">Statut</th>
                            <th style="padding: 14px 16px; text-align: left; font-weight: 600; font-size: 13px; text-transform: uppercase; letter-spacing: 0.03em;">Date création</th>
                            <th style="padding: 14px 16px; text-align: center; font-weight: 600; font-size: 13px; text-transform: uppercase; letter-spacing: 0.03em;">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($accountants as $accountant): ?>
                            <tr style="border-bottom: 1px solid #F4F0E4; transition: background-color 0.2s;" 
                                onmouseover="this.style.backgroundColor='#FDFBF7'" 
                                onmouseout="this.style.backgroundColor='transparent'">
                                <td style="padding: 14px 16px;">
                                    <div style="font-weight: 600; color: #2C1810;"><?php echo htmlspecialchars($accountant['full_name'] ?? 'N/A', ENT_QUOTES, 'UTF-8'); ?></div>
                                </td>
                                <td style="padding: 14px 16px; color: #4B2F1F;">
                                    <?php echo htmlspecialchars($accountant['email'] ?? 'N/A', ENT_QUOTES, 'UTF-8'); ?>
                                </td>
                                <td style="padding: 14px 16px; color: #4B2F1F;">
                                    <?php echo htmlspecialchars($accountant['province_name'], ENT_QUOTES, 'UTF-8'); ?>
                                </td>
                                <td style="padding: 14px 16px; text-align: center;">
                                    <?php if ($accountant['is_active']): ?>
                                        <span style="display: inline-block; padding: 4px 12px; border-radius: 20px; font-size: 12px; font-weight: 600; background-color: #e6ffe6; color: #2E7D32;">Actif</span>
                                    <?php else: ?>
                                        <span style="display: inline-block; padding: 4px 12px; border-radius: 20px; font-size: 12px; font-weight: 600; background-color: #ffe6e6; color: #C62828;">Inactif</span>
                                    <?php endif; ?>
                                </td>
                                <td style="padding: 14px 16px; color: #6B4F2F; font-size: 13px;">
                                    <?php echo htmlspecialchars(date('d/m/Y', strtotime($accountant['created_at'])), ENT_QUOTES, 'UTF-8'); ?>
                                </td>
                                <td style="padding: 14px 16px; text-align: center;">
                                    <a href="/masunzu_bar_hotel/modules/accounting/view_transactions.php?accountant_id=<?php echo (int)$accountant['id']; ?>" 
                                       style="display: inline-block; background-color: #4B2F1F; color: #F4F0E4; padding: 8px 16px; border-radius: 6px; text-decoration: none; font-size: 13px; font-weight: 500; transition: background-color 0.2s;"
                                       onmouseover="this.style.backgroundColor='#6B4F2F'" 
                                       onmouseout="this.style.backgroundColor='#4B2F1F'">
                                        Voir Transactions
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php include __DIR__ . '/../../includes/footer.php'; ?>
