<?php
// Script to list all folders, subfolders, and files in the project directory
$project_root = __DIR__; // Current directory, adjust if needed (e.g., '/opt/lampp/htdocs/masunzu_bar_hotel')
$output_file = $project_root . '/project_structure.txt'; // Output file path

try {
    // Initialize output array
    $output = ["Project Directory Structure: $project_root\n"];
    
    // Create RecursiveDirectoryIterator to traverse the directory
    $iterator = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($project_root, RecursiveDirectoryIterator::SKIP_DOTS),
        RecursiveIteratorIterator::SELF_FIRST
    );
    
    // Iterate through each file and directory
    foreach ($iterator as $file) {
        // Get path relative to project root
        $relative_path = str_replace($project_root . '/', '', $file->getPathname());
        
        // Calculate depth for indentation (number of directory levels)
        $depth = substr_count($relative_path, '/');
        $indent = str_repeat('  ', $depth);
        
        // Format output based on whether it's a directory or file
        if ($file->isDir()) {
            $output[] = $indent . '[DIR] ' . $relative_path;
        } else {
            $output[] = $indent . '[FILE] ' . $relative_path;
        }
    }
    
    // Sort output for consistency
    sort($output);
    
    // Write to file
    file_put_contents($output_file, implode("\n", $output));
    
    // Output to browser
    header('Content-Type: text/plain');
    echo implode("\n", $output);
    
} catch (Exception $e) {
    // Handle errors (e.g., permission issues)
    header('Content-Type: text/plain');
    echo "Error generating directory structure: " . $e->getMessage();
}

// Optionally, force download of the output file
header('Content-Disposition: attachment; filename="project_structure.txt"');
readfile($output_file);
?>