-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: localhost
-- Generation Time: Dec 13, 2025 at 11:38 PM
-- Server version: 10.4.32-MariaDB
-- PHP Version: 8.2.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `masunzu_bar_hotel`
--

-- --------------------------------------------------------

--
-- Table structure for table `accountant_balance`
--

CREATE TABLE `accountant_balance` (
  `id` int(11) NOT NULL,
  `accountant_id` int(11) NOT NULL,
  `balance` bigint(20) NOT NULL DEFAULT 0,
  `currency` enum('BIF') NOT NULL DEFAULT 'BIF',
  `last_updated` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `accountant_balance`
--

INSERT INTO `accountant_balance` (`id`, `accountant_id`, `balance`, `currency`, `last_updated`) VALUES
(0, 26, 153790000, 'BIF', '2025-12-13 17:47:23');

-- --------------------------------------------------------

--
-- Table structure for table `audit_log`
--

CREATE TABLE `audit_log` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `action` varchar(50) NOT NULL,
  `table_name` varchar(50) NOT NULL,
  `record_id` int(11) DEFAULT NULL,
  `timestamp` datetime DEFAULT current_timestamp(),
  `details` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `audit_log`
--

INSERT INTO `audit_log` (`id`, `user_id`, `action`, `table_name`, `record_id`, `timestamp`, `details`) VALUES
(1, 18, 'INSERT', 'company_info', 1, '2025-12-07 00:24:52', '{\"company_name\":\"Masunzu Bar Hotel\",\"address\":\"\",\"phone1\":\"71256632\",\"phone2\":\"71557481\",\"nif\":\"400000052\",\"rc\":\"RC525665\",\"website\":\"htpps:\\/\\/www.masunzubarhotel.com\",\"email\":\"info@masunzubarhotel.com\",\"logo_path\":\"assets\\/uploads\\/logos\\/6934ad349b959_logo.png\"}');

-- --------------------------------------------------------

--
-- Table structure for table `bank_account`
--

CREATE TABLE `bank_account` (
  `id` int(11) NOT NULL,
  `account_number` varchar(50) NOT NULL,
  `currency` enum('USD','BIF') NOT NULL,
  `is_main` tinyint(1) NOT NULL DEFAULT 0,
  `balance` bigint(20) DEFAULT 0,
  `province_id` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `bank_account`
--

INSERT INTO `bank_account` (`id`, `account_number`, `currency`, `is_main`, `balance`, `province_id`, `created_at`) VALUES
(1, '312500362562', 'BIF', 1, 335428000, NULL, '2025-11-25 15:37:23');

-- --------------------------------------------------------

--
-- Table structure for table `bank_account_transaction`
--

CREATE TABLE `bank_account_transaction` (
  `id` int(11) NOT NULL,
  `bank_account_id` int(11) NOT NULL,
  `province_id` int(11) DEFAULT NULL,
  `transaction_type` enum('CASH_TRANSFER_RECEIVED','BANK_DEPOSIT','REVERSAL','ADJUSTMENT') NOT NULL,
  `direction` enum('CREDIT','DEBIT') NOT NULL,
  `amount` bigint(20) NOT NULL,
  `reference_type` enum('CASH_TRANSFER','CASH_DEPOSIT','MANUAL','OTHER') NOT NULL DEFAULT 'OTHER',
  `reference_id` int(11) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `bank_account_transaction`
--

INSERT INTO `bank_account_transaction` (`id`, `bank_account_id`, `province_id`, `transaction_type`, `direction`, `amount`, `reference_type`, `reference_id`, `description`, `created_by`, `created_at`) VALUES
(1, 1, 1, 'BANK_DEPOSIT', 'CREDIT', 500000, 'CASH_DEPOSIT', 3, 'Bank deposit #3 (65258556)', 26, '2025-12-01 13:24:00'),
(2, 1, 1, 'BANK_DEPOSIT', 'CREDIT', 30000000, 'OTHER', 58, 'Paiement facture INV-20251211-9562 via bordereau 12356854', 27, '2025-12-11 18:36:54'),
(3, 1, 1, 'BANK_DEPOSIT', 'CREDIT', 400000, 'CASH_DEPOSIT', 6, '0', 27, '2025-12-13 16:08:23');

-- --------------------------------------------------------

--
-- Table structure for table `bank_deposit`
--

CREATE TABLE `bank_deposit` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `amount` bigint(20) NOT NULL,
  `slip_number` varchar(255) DEFAULT NULL,
  `slip_file_path` varchar(255) DEFAULT NULL,
  `deposit_date` datetime NOT NULL DEFAULT current_timestamp(),
  `province_id` int(11) NOT NULL,
  `bank_account_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `bank_deposit`
--

INSERT INTO `bank_deposit` (`id`, `user_id`, `amount`, `slip_number`, `slip_file_path`, `deposit_date`, `province_id`, `bank_account_id`) VALUES
(3, 26, 500000, '65258556', '/masunzu_bar_hotel/uploads/bank_slips/deposit_26_d22309e2.jpg', '2025-12-01 13:24:00', 1, 1),
(5, 27, 30000000, '12356854', '/masunzu_bar_hotel/uploads/bank_slips/bankslip_27_1765471014_2842cb_bordereau_crdb.jpeg', '2025-12-11 18:36:54', 1, 1),
(6, 27, 400000, '12563', '/masunzu_bar_hotel/uploads/bank_slips/loan_deposit_27_693d73576d28c.png', '2025-12-13 16:08:23', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `bank_deposit_backup`
--

CREATE TABLE `bank_deposit_backup` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `amount` bigint(20) NOT NULL,
  `slip_number` varchar(255) DEFAULT NULL,
  `slip_file_path` varchar(255) DEFAULT NULL,
  `deposit_date` datetime NOT NULL DEFAULT current_timestamp(),
  `province_id` int(11) NOT NULL,
  `bank_account_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `bank_deposit_backup_2025`
--

CREATE TABLE `bank_deposit_backup_2025` (
  `id` int(11) NOT NULL DEFAULT 0,
  `user_id` int(11) NOT NULL,
  `amount` bigint(20) NOT NULL,
  `slip_number` varchar(255) DEFAULT NULL,
  `slip_file_path` varchar(255) DEFAULT NULL,
  `deposit_date` datetime NOT NULL DEFAULT current_timestamp(),
  `province_id` int(11) NOT NULL,
  `bank_account_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `bank_deposit_new`
--

CREATE TABLE `bank_deposit_new` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `amount` bigint(20) NOT NULL,
  `slip_number` varchar(255) DEFAULT NULL,
  `slip_file_path` varchar(255) DEFAULT NULL,
  `deposit_date` datetime NOT NULL DEFAULT current_timestamp(),
  `province_id` int(11) NOT NULL,
  `bank_account_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `bank_deposit_new`
--

INSERT INTO `bank_deposit_new` (`id`, `user_id`, `amount`, `slip_number`, `slip_file_path`, `deposit_date`, `province_id`, `bank_account_id`) VALUES
(12, 27, 7080000, '652585', '/masunzu_bar_hotel/uploads/bank_slips/slip_15_a78dfe5b.jpg', '2025-11-28 16:50:03', 1, 1),
(13, 27, 83600000, '65856526', '/masunzu_bar_hotel/uploads/bank_slips/slip_17_e887b0fe.jpg', '2025-12-01 14:00:31', 1, 1),
(14, 27, 3540000, '6525856585', '/masunzu_bar_hotel/uploads/bank_slips/slip_18_703a7dd9.jpg', '2025-12-01 14:03:50', 1, 1),
(15, 27, 18000000, '65258552658', '/masunzu_bar_hotel/uploads/bank_slips/slip_20_5af1338e.jpg', '2025-12-01 15:16:33', 1, 1),
(16, 27, 1000000, '5255', '/masunzu_bar_hotel/uploads/bank_slips/slip_19_3e7ba612.jpg', '2025-12-01 15:21:33', 1, 1),
(17, 27, 191708000, '12563562', '/masunzu_bar_hotel/uploads/bank_slips/slip_23_63835af0.jpg', '2025-12-13 16:37:45', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `bank_deposit_v2`
--

CREATE TABLE `bank_deposit_v2` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `amount` bigint(20) NOT NULL,
  `slip_number` varchar(255) DEFAULT NULL,
  `slip_file_path` varchar(255) DEFAULT NULL,
  `deposit_date` datetime NOT NULL DEFAULT current_timestamp(),
  `province_id` int(11) NOT NULL,
  `bank_account_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `cashier_account`
--

CREATE TABLE `cashier_account` (
  `id` int(11) NOT NULL,
  `cashier_id` int(11) NOT NULL,
  `shift_id` int(11) DEFAULT NULL,
  `transaction_type` enum('SHIFT_START','SHIFT_END','INVOICE_PAYMENT','LOAN_REPAYMENT','REQUISITION_PAYMENT','EXPENSE','BANK_DEPOSIT','CASH_TRANSFER','ADJUSTMENT') NOT NULL,
  `direction` enum('CREDIT','DEBIT') NOT NULL,
  `amount` bigint(20) NOT NULL,
  `reference_type` enum('SHIFT','INVOICE','LOAN_PAYMENT','REQUISITION','EXPENSE','BANK_DEPOSIT','CASH_TRANSFER','MANUAL') NOT NULL,
  `reference_id` int(11) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `created_by` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `cashier_account`
--

INSERT INTO `cashier_account` (`id`, `cashier_id`, `shift_id`, `transaction_type`, `direction`, `amount`, `reference_type`, `reference_id`, `description`, `created_at`, `created_by`) VALUES
(13, 27, 15, 'INVOICE_PAYMENT', 'CREDIT', 7080000, 'INVOICE', 68, 'Paiement facture: INV-20251128-0540', '2025-11-28 16:19:15', 27),
(14, 27, 16, 'INVOICE_PAYMENT', 'CREDIT', 10000000, 'INVOICE', 69, 'Paiement facture: INV-20251128-5614', '2025-11-28 16:59:43', 27),
(15, 27, 16, 'CASH_TRANSFER', 'DEBIT', 10000000, 'CASH_TRANSFER', 3, 'Transfert vers comptable: Session 16 (terminée 2025-11-28 17:00)', '2025-11-28 17:19:43', 27),
(16, 27, 17, 'INVOICE_PAYMENT', 'CREDIT', 23600000, 'INVOICE', 74, 'Paiement facture: INV-20251201-5570', '2025-12-01 14:51:18', 27),
(17, 27, 17, 'INVOICE_PAYMENT', 'CREDIT', 0, 'INVOICE', 70, 'Vente à crédit (facture: INV-20251128-0520) - Aucun argent reçu', '2025-12-01 14:51:40', 27),
(18, 27, 17, 'INVOICE_PAYMENT', 'CREDIT', 60000000, 'INVOICE', 75, 'Paiement facture: INV-20251201-2430', '2025-12-01 14:52:34', 27),
(19, 27, 18, 'INVOICE_PAYMENT', 'CREDIT', 3540000, 'INVOICE', 76, 'Paiement facture: INV-20251201-6535', '2025-12-01 14:59:16', 27),
(20, 27, 19, 'LOAN_REPAYMENT', 'CREDIT', 1000000, 'LOAN_PAYMENT', 15, 'Remboursement crédit: MAHORO BAR', '2025-12-01 15:08:51', 27),
(21, 27, 20, 'INVOICE_PAYMENT', 'CREDIT', 12000000, 'INVOICE', 78, 'Paiement facture: INV-20251201-9778', '2025-12-01 16:15:39', 27),
(22, 27, 20, 'INVOICE_PAYMENT', 'CREDIT', 6000000, 'INVOICE', 77, 'Paiement facture: INV-20251201-0185', '2025-12-01 16:15:51', 27),
(23, 27, 22, 'INVOICE_PAYMENT', 'CREDIT', 141600000, 'INVOICE', 79, 'Paiement facture: INV-20251204-9006', '2025-12-04 11:51:02', 27),
(24, 27, 22, 'REQUISITION_PAYMENT', 'DEBIT', 1340000, 'REQUISITION', 12, 'Paiement réquisition #12', '2025-12-04 11:51:31', 27),
(25, 27, 22, 'INVOICE_PAYMENT', 'CREDIT', 3540000, 'INVOICE', 80, 'Paiement facture: INV-20251206-5301', '2025-12-07 00:47:58', 27),
(26, 27, 22, 'REQUISITION_PAYMENT', 'DEBIT', 10000, 'REQUISITION', 13, 'Paiement réquisition #13', '2025-12-10 10:05:30', 27),
(27, 27, 23, 'INVOICE_PAYMENT', 'CREDIT', 30000000, 'INVOICE', 81, 'Paiement bordereau bancaire: INV-20251211-9562', '2025-12-11 18:36:54', 27),
(28, 27, 23, 'INVOICE_PAYMENT', 'CREDIT', 190000000, 'INVOICE', 82, 'Paiement facture: INV-20251213-2198', '2025-12-13 13:08:53', 27),
(29, 27, 23, 'INVOICE_PAYMENT', 'CREDIT', 0, 'INVOICE', 83, 'Vente à crédit (facture: INV-20251213-8517) - Aucun argent reçu', '2025-12-13 13:33:19', 27),
(30, 27, 23, 'INVOICE_PAYMENT', 'CREDIT', 0, 'INVOICE', 85, 'Vente à crédit (facture: INV-20251213-8742) - Aucun argent reçu', '2025-12-13 14:39:05', 27),
(31, 27, 23, 'INVOICE_PAYMENT', 'CREDIT', 708000, 'INVOICE', 84, 'Paiement facture: INV-20251213-1765', '2025-12-13 14:39:38', 27),
(32, 27, 23, 'LOAN_REPAYMENT', 'CREDIT', 1000000, 'LOAN_PAYMENT', 17, 'Remboursement crédit: MAHORO BAR', '2025-12-13 16:10:07', 27),
(33, 27, 22, 'CASH_TRANSFER', 'DEBIT', 143790000, 'CASH_TRANSFER', 4, 'Transfert vers comptable: Session 22 (terminée 2025-12-11 16:46)', '2025-12-13 17:39:08', 27);

-- --------------------------------------------------------

--
-- Table structure for table `cashier_balance`
--

CREATE TABLE `cashier_balance` (
  `id` int(11) NOT NULL,
  `cashier_id` int(11) NOT NULL,
  `shift_start` datetime NOT NULL,
  `shift_end` datetime DEFAULT NULL,
  `beginning_balance` bigint(20) NOT NULL,
  `end_balance` bigint(20) DEFAULT NULL,
  `deposits` bigint(20) DEFAULT 0,
  `withdrawals` bigint(20) DEFAULT 0,
  `notes` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `cashier_balance`
--

INSERT INTO `cashier_balance` (`id`, `cashier_id`, `shift_start`, `shift_end`, `beginning_balance`, `end_balance`, `deposits`, `withdrawals`, `notes`, `created_at`) VALUES
(15, 27, '2025-11-28 16:18:56', '2025-11-28 16:20:15', 0, 0, 0, 0, 'ok', '2025-11-28 16:18:56'),
(16, 27, '2025-11-28 16:54:39', '2025-11-28 17:00:54', 0, 0, 0, 0, '', '2025-11-28 16:54:39'),
(17, 27, '2025-11-28 18:35:27', '2025-12-01 14:57:37', 0, 0, 0, 0, '', '2025-11-28 18:35:27'),
(18, 27, '2025-12-01 14:58:06', '2025-12-01 15:00:02', 0, 0, 0, 0, 'ok', '2025-12-01 14:58:06'),
(19, 27, '2025-12-01 15:08:37', '2025-12-01 15:21:35', 0, 1000000, 1000000, 0, '', '2025-12-01 15:08:37'),
(20, 27, '2025-12-01 15:37:20', '2025-12-01 16:16:14', 0, 0, 0, 0, '', '2025-12-01 15:37:20'),
(21, 27, '2025-12-01 17:50:08', '2025-12-01 17:50:32', 0, 0, 0, 0, '', '2025-12-01 17:50:08'),
(22, 27, '2025-12-04 11:49:20', '2025-12-11 16:46:43', 0, -1350000, 0, 1350000, '', '2025-12-04 11:49:20'),
(23, 27, '2025-12-11 16:47:00', '2025-12-13 17:37:00', 0, 223508000, 223508000, 0, '', '2025-12-11 16:47:00');

-- --------------------------------------------------------

--
-- Table structure for table `cashier_shift_closure`
--

CREATE TABLE `cashier_shift_closure` (
  `id` int(11) NOT NULL,
  `shift_id` int(11) NOT NULL,
  `cashier_id` int(11) NOT NULL,
  `province_id` int(11) DEFAULT NULL,
  `expected_amount` bigint(20) NOT NULL,
  `counted_amount` bigint(20) NOT NULL,
  `difference_amount` int(11) NOT NULL,
  `deposited_to_bank` enum('yes','no') NOT NULL DEFAULT 'no',
  `transferred_to_accountant` enum('yes','no') NOT NULL DEFAULT 'no',
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `cashier_shift_closure`
--

INSERT INTO `cashier_shift_closure` (`id`, `shift_id`, `cashier_id`, `province_id`, `expected_amount`, `counted_amount`, `difference_amount`, `deposited_to_bank`, `transferred_to_accountant`, `created_at`) VALUES
(14, 15, 27, 1, 0, 7080000, 7080000, 'yes', 'no', '2025-11-28 16:20:15'),
(15, 16, 27, 1, 0, 10000000, 10000000, 'no', 'yes', '2025-11-28 17:00:54'),
(16, 17, 27, 1, 0, 83600000, 83600000, 'yes', 'no', '2025-12-01 14:57:37'),
(17, 18, 27, 1, 0, 3540000, 3540000, 'yes', 'no', '2025-12-01 15:00:02'),
(18, 19, 27, 1, 1000000, 1000000, 0, 'yes', 'no', '2025-12-01 15:21:35'),
(19, 20, 27, 1, 0, 18000000, 18000000, 'yes', 'no', '2025-12-01 16:16:14'),
(20, 21, 27, 1, 0, 0, 0, 'no', 'no', '2025-12-01 17:50:32'),
(21, 22, 27, 1, 0, 143790000, 143790000, 'no', 'yes', '2025-12-11 16:46:43'),
(22, 23, 27, 1, 223508000, 191708000, -31800000, 'yes', 'no', '2025-12-13 17:37:00');

-- --------------------------------------------------------

--
-- Table structure for table `cashier_shift_deposit`
--

CREATE TABLE `cashier_shift_deposit` (
  `id` int(11) NOT NULL,
  `shift_id` int(11) NOT NULL,
  `deposit_id` int(11) DEFAULT NULL,
  `bank_account_id` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL,
  `slip_number` varchar(255) DEFAULT NULL,
  `slip_file_path` varchar(255) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `cashier_shift_deposit`
--

INSERT INTO `cashier_shift_deposit` (`id`, `shift_id`, `deposit_id`, `bank_account_id`, `amount`, `slip_number`, `slip_file_path`, `created_by`, `created_at`) VALUES
(42, 15, 12, 1, 7080000.00, '652585', '/masunzu_bar_hotel/uploads/bank_slips/slip_15_a78dfe5b.jpg', 27, '2025-11-28 17:50:03'),
(43, 17, 13, 1, 83600000.00, '65856526', '/masunzu_bar_hotel/uploads/bank_slips/slip_17_e887b0fe.jpg', 27, '2025-12-01 15:00:31'),
(44, 18, 14, 1, 3540000.00, '6525856585', '/masunzu_bar_hotel/uploads/bank_slips/slip_18_703a7dd9.jpg', 27, '2025-12-01 15:03:50'),
(45, 20, 15, 1, 18000000.00, '65258552658', '/masunzu_bar_hotel/uploads/bank_slips/slip_20_5af1338e.jpg', 27, '2025-12-01 16:16:33'),
(46, 19, 16, 1, 1000000.00, '5255', '/masunzu_bar_hotel/uploads/bank_slips/slip_19_3e7ba612.jpg', 27, '2025-12-01 16:21:33'),
(47, 23, 17, 1, 191708000.00, '12563562', '/masunzu_bar_hotel/uploads/bank_slips/slip_23_63835af0.jpg', 27, '2025-12-13 17:37:45');

-- --------------------------------------------------------

--
-- Table structure for table `cashier_shift_transfer`
--

CREATE TABLE `cashier_shift_transfer` (
  `id` int(11) NOT NULL,
  `shift_id` int(11) NOT NULL,
  `transfer_id` int(11) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `cashier_shift_transfer`
--

INSERT INTO `cashier_shift_transfer` (`id`, `shift_id`, `transfer_id`, `amount`, `created_by`, `created_at`) VALUES
(4, 16, 3, 10000000.00, 27, '2025-11-28 17:19:43'),
(5, 22, 4, 143790000.00, 27, '2025-12-13 17:39:08');

-- --------------------------------------------------------

--
-- Table structure for table `cash_transfer`
--

CREATE TABLE `cash_transfer` (
  `id` int(11) NOT NULL,
  `cashier_id` int(11) NOT NULL,
  `accountant_id` int(11) NOT NULL,
  `amount` bigint(20) NOT NULL,
  `status` enum('pending','received','rejected') NOT NULL DEFAULT 'pending',
  `transfer_date` datetime DEFAULT current_timestamp(),
  `received_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `cash_transfer`
--

INSERT INTO `cash_transfer` (`id`, `cashier_id`, `accountant_id`, `amount`, `status`, `transfer_date`, `received_at`) VALUES
(3, 27, 26, 10000000, 'received', '2025-11-28 17:19:43', '2025-12-01 14:08:38'),
(4, 27, 26, 143790000, 'received', '2025-12-13 17:39:08', '2025-12-13 17:47:23');

-- --------------------------------------------------------

--
-- Table structure for table `cash_transfer_denomination`
--

CREATE TABLE `cash_transfer_denomination` (
  `id` int(11) NOT NULL,
  `transfer_id` int(11) NOT NULL,
  `denomination` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `amount` bigint(20) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `company_info`
--

CREATE TABLE `company_info` (
  `id` int(11) NOT NULL,
  `company_name` varchar(100) NOT NULL,
  `address` text DEFAULT NULL,
  `nif` varchar(50) DEFAULT NULL,
  `rc` varchar(255) DEFAULT NULL,
  `phone1` varchar(20) DEFAULT NULL,
  `phone2` varchar(20) DEFAULT NULL,
  `website` varchar(100) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `logo_path` varchar(255) DEFAULT NULL,
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_by` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `company_info`
--

INSERT INTO `company_info` (`id`, `company_name`, `address`, `nif`, `rc`, `phone1`, `phone2`, `website`, `email`, `logo_path`, `updated_at`, `updated_by`) VALUES
(1, 'Masunzu Bar Hotel', '', '400000052', 'RC525665', '71256632', '71557481', 'htpps://www.masunzubarhotel.com', 'info@masunzubarhotel.com', 'assets/uploads/logos/6934ad349b959_logo.png', '2025-12-07 00:24:52', 18);

-- --------------------------------------------------------

--
-- Table structure for table `customer`
--

CREATE TABLE `customer` (
  `id` int(11) NOT NULL,
  `full_name` varchar(100) NOT NULL,
  `nif` varchar(50) DEFAULT NULL,
  `tel` varchar(20) DEFAULT NULL,
  `driver_name` varchar(100) DEFAULT NULL,
  `driver_contacts` varchar(20) DEFAULT NULL,
  `plate_numbers` varchar(50) DEFAULT NULL,
  `additional_contacts` text DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `user_type` enum('moral','physical') NOT NULL DEFAULT 'physical',
  `balance` bigint(20) DEFAULT 0,
  `created_at` datetime DEFAULT current_timestamp(),
  `created_by` int(11) DEFAULT NULL,
  `can_pay_by_loan` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Indicates if the customer can pay via loan (0 = No, 1 = Yes)',
  `loan_limit_bif` bigint(20) NOT NULL DEFAULT 0,
  `loan_balance_bif` bigint(20) NOT NULL DEFAULT 0,
  `loan_terms_days` int(11) DEFAULT NULL,
  `loan_status` enum('inactive','active','suspended') NOT NULL DEFAULT 'inactive',
  `loan_last_review_at` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `customer`
--

INSERT INTO `customer` (`id`, `full_name`, `nif`, `tel`, `driver_name`, `driver_contacts`, `plate_numbers`, `additional_contacts`, `address`, `user_type`, `balance`, `created_at`, `created_by`, `can_pay_by_loan`, `loan_limit_bif`, `loan_balance_bif`, `loan_terms_days`, `loan_status`, `loan_last_review_at`, `is_active`) VALUES
(15, 'MAHORO BAR', '4000002365', '65265365', 'KWIZERA', '61523', 'F3258Q', '', '', 'moral', 0, '2025-11-28 16:01:02', NULL, 1, 1000000, 0, 0, 'active', '2025-12-13 16:10:07', 1),
(16, 'BURIKUKIYE GASPARD', '40000000052', '62582365', 'ERIC MANIRAKIZA', '67589265', 'F585A', '65859652', 'KINAMA', 'physical', 0, '2025-12-01 12:05:13', 19, 0, 0, 0, NULL, 'inactive', NULL, 1),
(17, 'test_client', '4505665265', '71557480', 'P', '71565263', 'F252A', '7658652', 'Kirundo', 'physical', 0, '2025-12-05 18:31:51', 18, 0, 0, 0, NULL, 'inactive', NULL, 1),
(18, 'KARIKURUBU PAUL', '4000056236', '76215365', 'KWIZERA PAULETTE', '76200300', 'F5962A', '76002003', '', 'physical', 0, '2025-12-13 14:23:40', NULL, 1, 500000, 200000, 30, 'active', '2025-12-13 16:36:12', 1),
(19, 'KARIKURUBU PAULETTE', '4000056236', '76215365', 'KWIZERA PAULETTE', '76200300', 'F5962A', '76002003', NULL, 'physical', 0, '2025-12-13 14:25:06', NULL, 0, 0, 0, NULL, 'inactive', NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `customer_balance`
--

CREATE TABLE `customer_balance` (
  `id` int(11) NOT NULL,
  `customer_name` varchar(255) NOT NULL,
  `amount` bigint(20) NOT NULL,
  `action` enum('add','subtract') NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `customer_loan_ledger`
--

CREATE TABLE `customer_loan_ledger` (
  `id` int(11) NOT NULL,
  `customer_id` int(11) NOT NULL,
  `entry_type` enum('loan_sale','loan_repayment','adjustment') NOT NULL,
  `entry_origin` varchar(32) NOT NULL DEFAULT 'system',
  `direction` enum('debit','credit') NOT NULL,
  `amount_bif` bigint(20) NOT NULL,
  `reference_table` varchar(50) DEFAULT NULL,
  `reference_id` int(11) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `customer_loan_ledger`
--

INSERT INTO `customer_loan_ledger` (`id`, `customer_id`, `entry_type`, `entry_origin`, `direction`, `amount_bif`, `reference_table`, `reference_id`, `notes`, `created_by`, `created_at`) VALUES
(43, 15, 'loan_sale', 'loan_creation', 'debit', 1000000, 'unpaid_invoices', 70, 'ol', 27, '2025-11-28 18:37:28'),
(44, 15, 'loan_repayment', 'loan_repayment', 'credit', 1000000, 'manual', NULL, 'ok', 27, '2025-12-01 15:08:51'),
(45, 15, 'loan_sale', 'loan_creation', 'debit', 1000000, 'unpaid_invoices', 83, 'ok', 27, '2025-12-13 13:30:11'),
(46, 18, 'loan_sale', 'loan_creation', 'debit', 400000, 'unpaid_invoices', 85, 'ok', 27, '2025-12-13 14:38:12'),
(47, 18, 'loan_repayment', 'loan_repayment', 'credit', 400000, 'unpaid_invoices', 85, 'ok', 27, '2025-12-13 16:08:23'),
(48, 15, 'loan_repayment', 'loan_repayment', 'credit', 1000000, 'manual', NULL, 'ok', 27, '2025-12-13 16:10:07'),
(49, 18, 'loan_sale', 'loan_creation', 'debit', 200000, 'unpaid_invoices', 86, 'ok', 27, '2025-12-13 16:36:12');

-- --------------------------------------------------------

--
-- Table structure for table `department`
--

CREATE TABLE `department` (
  `id` int(11) NOT NULL,
  `code` varchar(50) NOT NULL,
  `label` varchar(100) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `expense`
--

CREATE TABLE `expense` (
  `id` int(11) NOT NULL,
  `requisition_id` int(11) NOT NULL,
  `cashier_id` int(11) NOT NULL,
  `receiver_user_id` int(11) DEFAULT NULL,
  `receiver_external_name` varchar(255) DEFAULT NULL,
  `receiver_external_phone` varchar(20) DEFAULT NULL,
  `amount` bigint(20) NOT NULL,
  `receipt_number` varchar(50) NOT NULL,
  `recipient_signature` text DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `accountant_id` int(11) NOT NULL,
  `approved_by` int(11) DEFAULT NULL,
  `approval_status` enum('pending','approved','rejected') NOT NULL DEFAULT 'pending',
  `payment_status` enum('pending','processed','completed') NOT NULL DEFAULT 'pending',
  `payment_method` enum('cash','bank_transfer','mobile') DEFAULT 'cash'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `expense`
--

INSERT INTO `expense` (`id`, `requisition_id`, `cashier_id`, `receiver_user_id`, `receiver_external_name`, `receiver_external_phone`, `amount`, `receipt_number`, `recipient_signature`, `created_at`, `accountant_id`, `approved_by`, `approval_status`, `payment_status`, `payment_method`) VALUES
(11, 12, 27, NULL, 'K', '65236635', 1340000, 'REQ-20251204-6322', 'ok', '2025-12-04 11:51:31', 27, NULL, 'approved', 'processed', 'cash'),
(12, 13, 27, 23, NULL, NULL, 10000, 'REQ-20251210-8477', 'ok', '2025-12-10 10:05:30', 27, NULL, 'approved', 'processed', 'cash');

-- --------------------------------------------------------

--
-- Table structure for table `field_observation`
--

CREATE TABLE `field_observation` (
  `id` int(11) NOT NULL,
  `author_id` int(11) NOT NULL,
  `region_id` int(11) DEFAULT NULL,
  `province_id` int(11) DEFAULT NULL,
  `subject` varchar(150) DEFAULT NULL,
  `details` text NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `field_observation`
--

INSERT INTO `field_observation` (`id`, `author_id`, `region_id`, `province_id`, `subject`, `details`, `created_at`) VALUES
(3, 19, 2, 3, 'oBSERVATIONS', 'HARI ABA CLIENTS BENSHI', '2025-12-01 12:05:58'),
(4, 27, 5, 3, 'okkk', 'ooooo', '2025-12-01 16:14:17'),
(5, 19, 5, 2, 'Ibinyobwa ni bike', 'majahdghdhddh', '2025-12-01 18:07:00');

-- --------------------------------------------------------

--
-- Table structure for table `invoice`
--

CREATE TABLE `invoice` (
  `id` int(11) NOT NULL,
  `requisition_id` int(11) DEFAULT NULL,
  `stock_manager_id` int(11) NOT NULL,
  `status` enum('pending','paid','unpaid') NOT NULL DEFAULT 'pending',
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `customer_name` varchar(255) NOT NULL,
  `phone_number` varchar(20) NOT NULL,
  `created_by` int(11) NOT NULL,
  `province_id` int(11) NOT NULL,
  `nif` varchar(50) DEFAULT NULL,
  `rc` varchar(50) DEFAULT NULL,
  `invoice_number` varchar(20) NOT NULL,
  `serve_status` enum('Pending','Served') NOT NULL DEFAULT 'Pending',
  `paid_amount` bigint(20) NOT NULL,
  `province_stock_id` int(11) DEFAULT NULL,
  `approved_by` int(11) DEFAULT NULL,
  `assigned_cashier_id` int(11) DEFAULT NULL,
  `approval_status` enum('pending','approved','rejected') NOT NULL DEFAULT 'pending',
  `approved_at` datetime DEFAULT NULL,
  `approval_comments` text DEFAULT NULL,
  `reject_comments` text DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `expiration_status` enum('pending','expired','finalized') DEFAULT 'pending'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `invoice_items`
--

CREATE TABLE `invoice_items` (
  `id` int(11) NOT NULL,
  `invoice_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `unit_price` bigint(20) NOT NULL,
  `price_source` varchar(20) DEFAULT 'system',
  `system_unit_price` bigint(20) DEFAULT NULL,
  `custom_unit_price` bigint(20) DEFAULT NULL,
  `custom_price_basis` varchar(50) DEFAULT NULL,
  `custom_price_input` bigint(20) DEFAULT NULL,
  `custom_price_note` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `invoice_items`
--

INSERT INTO `invoice_items` (`id`, `invoice_id`, `product_id`, `quantity`, `unit_price`, `price_source`, `system_unit_price`, `custom_unit_price`, `custom_price_basis`, `custom_price_input`, `custom_price_note`) VALUES
(88, 83, 9, 5, 200000, 'system', NULL, NULL, NULL, NULL, NULL),
(90, 85, 9, 2, 200000, 'system', NULL, NULL, NULL, NULL, NULL),
(91, 86, 9, 1, 200000, 'system', NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `invoice_log`
--

CREATE TABLE `invoice_log` (
  `id` int(11) NOT NULL,
  `action` varchar(50) NOT NULL,
  `description` text NOT NULL,
  `created_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `invoice_price_adjustment_history`
--

CREATE TABLE `invoice_price_adjustment_history` (
  `id` int(11) NOT NULL,
  `unpaid_invoice_id` int(11) NOT NULL,
  `invoice_number` varchar(20) NOT NULL,
  `product_id` int(11) NOT NULL,
  `price_source` varchar(20) DEFAULT 'custom',
  `original_unit_price` bigint(20) NOT NULL DEFAULT 0,
  `new_unit_price` bigint(20) NOT NULL DEFAULT 0,
  `custom_price_basis` varchar(50) DEFAULT NULL,
  `custom_price_input` bigint(20) DEFAULT NULL,
  `quantity_units` int(11) DEFAULT NULL,
  `changed_by` int(11) NOT NULL,
  `change_note` text DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `loan_payment`
--

CREATE TABLE `loan_payment` (
  `id` int(11) NOT NULL,
  `customer_id` int(11) NOT NULL,
  `order_id` int(11) DEFAULT NULL,
  `province_id` int(11) DEFAULT NULL,
  `invoice_id` int(11) DEFAULT NULL,
  `ledger_entry_id` int(11) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `payment_amount` bigint(20) NOT NULL,
  `payment_method` enum('cash','bank_transfer','mobile','bank_deposit') DEFAULT NULL,
  `payment_date` datetime DEFAULT current_timestamp(),
  `created_by` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `loan_payment`
--

INSERT INTO `loan_payment` (`id`, `customer_id`, `order_id`, `province_id`, `invoice_id`, `ledger_entry_id`, `notes`, `payment_amount`, `payment_method`, `payment_date`, `created_by`) VALUES
(15, 15, NULL, 1, NULL, 44, 'ok', 1000000, NULL, '2025-12-01 15:08:51', 27),
(16, 18, NULL, 1, NULL, 47, 'ok', 400000, 'bank_deposit', '2025-12-13 16:08:23', 27),
(17, 15, NULL, 1, NULL, 48, 'ok', 1000000, 'cash', '2025-12-13 16:10:07', 27);

-- --------------------------------------------------------

--
-- Table structure for table `log`
--

CREATE TABLE `log` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `action` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `log`
--

INSERT INTO `log` (`id`, `user_id`, `action`, `description`, `created_at`) VALUES
(782, 18, 'login', 'User jacques logged in', '2025-11-28 15:55:33'),
(783, 18, 'add_stock', 'Ajouté 10.000 crates de Soma 75 cl au stock principal', '2025-11-28 15:56:55'),
(784, 18, 'initiate_transfer', 'Transfert de stock initié avec l\'ID d\'expédition 773187 pour 3000 caisses vers gestionnaire de stock Bosco NSHIMIRIMANA (Mirango) : Soma 75 cl (3.000 crates)', '2025-11-28 15:57:25'),
(785, 18, 'logout', 'User Jean Jacques logged out', '2025-11-28 15:57:55'),
(786, 20, 'login', 'User bosco logged in', '2025-11-28 15:58:00'),
(787, 20, 'confirm_transfer', 'Confirmed stock transfer reception for transfert ID 773187', '2025-11-28 15:58:05'),
(788, 20, 'logout', 'User Bosco NSHIMIRIMANA logged out', '2025-11-28 15:58:16'),
(789, 18, 'login', 'User jacques logged in', '2025-11-28 15:58:32'),
(790, 18, 'add_user', 'Added user \'christa\' (ID: 27, Role: Caissier_Comptable, Depot: Mirango, Region: N/A, Address: Kinama)', '2025-11-28 15:59:46'),
(791, 27, 'login', 'User christa logged in', '2025-11-28 16:00:15'),
(792, 27, 'create_invoice', 'Created unpaid invoice with number INV-20251128-0540 for customer MAHORO BAR, total amount 6,000,000.00 BIF', '2025-11-28 16:01:19'),
(793, 18, 'logout', 'User Jean Jacques logged out', '2025-11-28 16:01:53'),
(794, 20, 'login', 'User bosco logged in', '2025-11-28 16:01:58'),
(795, 20, 'approve_invoices', 'approve invoice 68 with comment: ok', '2025-11-28 16:02:10'),
(796, 27, 'start_shift', 'Caissier a démarré la session avec solde 0 BIF', '2025-11-28 16:18:56'),
(797, 27, 'process_payment', 'Processed payment for invoice INV-20251128-0540 (TVAC) with subtotal 6.000.000 BIF, TVA 1.080.000 BIF, total 7.080.000 BIF', '2025-11-28 16:19:15'),
(798, 27, 'reprint_receipt', 'Reprinted receipt/invoice INV-20251128-0540 (ID: 8ec54ad1-aa26-4779-bf47-c60bb1bc39b0)', '2025-11-28 16:19:16'),
(799, 27, 'end_shift', 'Caissier a fermé la session. Attendu 0 BIF, compté 7080000 BIF, différence 7080000 BIF, journal: christa_nemeyimana_20251128_journal.pdf', '2025-11-28 16:20:15'),
(800, 27, 'logout', 'User Christa Nemeyimana logged out', '2025-11-28 16:43:45'),
(801, 27, 'login', 'User christa logged in', '2025-11-28 16:44:01'),
(802, 27, 'create_invoice', 'Created unpaid invoice with number INV-20251128-5614 for customer MAHORO BAR, total amount 10,000,000.00 BIF', '2025-11-28 16:54:16'),
(803, 20, 'approve_invoices', 'approve invoice 69 with comment: ok', '2025-11-28 16:54:32'),
(804, 27, 'start_shift', 'Caissier a démarré la session avec solde 0 BIF', '2025-11-28 16:54:39'),
(805, 27, 'process_payment', 'Processed payment for invoice INV-20251128-5614 (HTVA) with subtotal 10.000.000 BIF, TVA 0 BIF, total 10.000.000 BIF', '2025-11-28 16:59:43'),
(806, 27, 'reprint_receipt', 'Reprinted receipt/invoice INV-20251128-5614 (ID: 7c1dad32-3066-4b32-acbe-546d25eaed02)', '2025-11-28 16:59:44'),
(807, 27, 'end_shift', 'Caissier a fermé la session. Attendu 0 BIF, compté 10000000 BIF, différence 10000000 BIF, journal: christa_nemeyimana_20251128_journal.pdf', '2025-11-28 17:00:54'),
(808, 27, 'cash_transfer', 'Cash transfer of 10000000 BIF recorded for shift 16 (ended 2025-11-28 17:00) to accountant ID 26', '2025-11-28 17:19:43'),
(809, 20, 'logout', 'User Bosco NSHIMIRIMANA logged out', '2025-11-28 18:30:55'),
(810, 18, 'login', 'User jacques logged in', '2025-11-28 18:31:51'),
(811, 27, 'logout', 'User Christa Nemeyimana logged out', '2025-11-28 18:35:14'),
(812, 27, 'login', 'User christa logged in', '2025-11-28 18:35:17'),
(813, 27, 'start_shift', 'Caissier a démarré la session avec solde 0 BIF', '2025-11-28 18:35:27'),
(814, 18, 'edit_customer', 'Edited customer \'MAHORO BAR\' (ID: 15) by user Jean Jacques (ID: 18)', '2025-11-28 18:36:14'),
(815, 27, 'create_invoice', 'Created unpaid invoice with number INV-20251128-0520 for customer MAHORO BAR, total amount 1,000,000.00 BIF [Loan sale]', '2025-11-28 18:37:28'),
(816, 18, 'approve_invoices', 'approve invoice 70 with comment: ok', '2025-11-28 18:37:43'),
(817, 27, 'create_invoice', 'Created unpaid invoice with number INV-20251128-7514 for customer MAHORO BAR, total amount 20,000,000.00 BIF', '2025-11-28 18:38:05'),
(818, 18, 'logout', 'User Jean Jacques logged out', '2025-11-28 18:38:30'),
(819, 19, 'login', 'User jmarie logged in', '2025-11-28 18:38:36'),
(820, 19, 'create_requisition', 'Created requisition ID 11 for 100000 BIF, recipient_id=NULL', '2025-11-28 18:43:53'),
(821, 19, 'create_invoice', 'Created unpaid invoice with number INV-20251128-0030 for customer MAHORO BAR, total amount 200,000,000.00 BIF', '2025-11-28 18:46:19'),
(822, 19, 'create_requisition', 'Created requisition ID 12 for 1440000 BIF, external recipient \'K\'', '2025-11-28 18:48:54'),
(823, 19, 'logout', 'User Jean Marie logged out', '2025-11-28 18:49:07'),
(824, 27, 'logout', 'User Christa Nemeyimana logged out', '2025-11-29 12:23:50'),
(825, 18, 'login', 'User jacques logged in', '2025-11-29 18:09:13'),
(826, 18, 'process_requisition', 'Requisition ID 12 approved by user_id 18, comments: ok', '2025-11-29 18:16:23'),
(827, 18, 'process_requisition', 'Requisition ID 11 rejected by user_id 18, comments: ok', '2025-11-29 18:16:28'),
(828, 18, 'logout', 'User Jean Jacques logged out', '2025-11-29 18:16:34'),
(829, 27, 'login', 'User christa logged in', '2025-11-29 18:16:41'),
(830, 27, 'logout', 'User Christa Nemeyimana logged out', '2025-11-29 18:24:03'),
(831, 18, 'login', 'User jacques logged in', '2025-11-29 18:24:06'),
(832, 18, 'add_stock', 'Ajouté 1.000 crates de Vin au stock principal', '2025-11-29 18:26:46'),
(833, 18, 'initiate_transfer', 'Transfert de stock initié avec l\'ID d\'expédition 970695 pour 500 caisses vers gestionnaire de stock Pascal Ndagijimana (Magarama) : Vin (500 crates)', '2025-11-29 18:28:51'),
(834, 18, 'logout', 'User Jean Jacques logged out', '2025-11-29 18:29:22'),
(835, 18, 'login', 'User jacques logged in', '2025-11-29 18:31:11'),
(836, 18, 'logout', 'User Jean Jacques logged out', '2025-11-29 18:32:09'),
(837, 24, 'login', 'User pascal logged in', '2025-11-29 18:32:13'),
(838, 24, 'confirm_transfer', 'Confirmed stock transfer reception for transfert ID 970695', '2025-11-29 18:32:52'),
(839, 24, 'logout', 'User Pascal Ndagijimana logged out', '2025-11-29 18:33:09'),
(840, 27, 'login', 'User christa logged in', '2025-11-29 18:33:13'),
(841, 27, 'logout', 'User Christa Nemeyimana logged out', '2025-11-29 18:34:12'),
(842, 18, 'login', 'User jacques logged in', '2025-11-29 18:34:15'),
(843, 18, 'logout', 'User Jean Jacques logged out', '2025-11-29 18:34:27'),
(844, 27, 'login', 'User christa logged in', '2025-11-29 18:34:31'),
(845, 27, 'logout', 'User Christa Nemeyimana logged out', '2025-12-01 11:28:11'),
(846, 19, 'login', 'User jmarie logged in', '2025-12-01 11:28:15'),
(847, 18, 'login', 'User jacques logged in', '2025-12-01 11:29:54'),
(848, 19, 'create_invoice', 'Created unpaid invoice with number INV-20251201-9724 for customer MAHORO BAR, total amount 100,000,000.00 BIF', '2025-12-01 11:30:55'),
(849, 19, 'create_customer', 'Created customer \'BURIKUKIYE GASPARD\' by user Jean Marie (ID: 19)', '2025-12-01 12:05:13'),
(850, 19, 'logout', 'User Jean Marie logged out', '2025-12-01 12:17:06'),
(851, 25, 'login', 'User stessy logged in', '2025-12-01 12:24:12'),
(852, 25, 'logout', 'User Stessy Kamariza logged out', '2025-12-01 14:08:05'),
(853, 26, 'login', 'User divine logged in', '2025-12-01 14:08:11'),
(854, 26, 'receive_cash', 'Confirmed transfer #3 for 10000000 BIF', '2025-12-01 14:08:38'),
(855, 26, 'bank_deposit', 'Bank deposit of 500000 BIF recorded with slip 65258556', '2025-12-01 14:25:04'),
(856, 18, 'logout', 'User Jean Jacques logged out', '2025-12-01 14:45:18'),
(857, 27, 'login', 'User christa logged in', '2025-12-01 14:47:50'),
(858, 27, 'create_invoice', 'Created unpaid invoice with number INV-20251201-5570 for customer BURIKUKIYE GASPARD, total amount 20,000,000.00 BIF', '2025-12-01 14:48:22'),
(859, 27, 'logout', 'User Christa Nemeyimana logged out', '2025-12-01 14:48:26'),
(860, 18, 'login', 'User jacques logged in', '2025-12-01 14:48:42'),
(861, 18, 'approve_invoices', 'approve invoice 74 with comment: ok', '2025-12-01 14:50:46'),
(862, 26, 'logout', 'User Divine Nshimirimana logged out', '2025-12-01 14:50:55'),
(863, 27, 'login', 'User christa logged in', '2025-12-01 14:50:59'),
(864, 27, 'process_payment', 'Processed payment for invoice INV-20251201-5570 (TVAC) with subtotal 20.000.000 BIF, TVA 3.600.000 BIF, total 23.600.000 BIF', '2025-12-01 14:51:18'),
(865, 27, 'reprint_receipt', 'Reprinted receipt/invoice INV-20251201-5570 (ID: 5abb46a4-2611-48df-baa0-644f328b0b0e)', '2025-12-01 14:51:19'),
(866, 27, 'process_payment', 'Processed loan payment for invoice INV-20251128-0520 - debt recorded: 1.000.000 BIF', '2025-12-01 14:51:40'),
(867, 27, 'reprint_receipt', 'Reprinted receipt/invoice INV-20251128-0520 (ID: 66a2a5a2-946d-4fb0-9077-ea8cce222eb3)', '2025-12-01 14:51:41'),
(868, 27, 'create_invoice', 'Created unpaid invoice with number INV-20251201-2430 for customer BURIKUKIYE GASPARD, total amount 60,000,000.00 BIF', '2025-12-01 14:52:14'),
(869, 18, 'approve_invoices', 'approve invoice 75 with comment: ok', '2025-12-01 14:52:22'),
(870, 27, 'process_payment', 'Processed payment for invoice INV-20251201-2430 (HTVA) with subtotal 60.000.000 BIF, TVA 0 BIF, total 60.000.000 BIF', '2025-12-01 14:52:34'),
(871, 27, 'reprint_receipt', 'Reprinted receipt/invoice INV-20251201-2430 (ID: 81f79b61-77ed-4ae4-8f69-b178ae199d38)', '2025-12-01 14:52:35'),
(872, 27, 'end_shift', 'Caissier a fermé la session. Attendu 0 BIF, compté 83600000 BIF, différence 83600000 BIF, journal: christa_nemeyimana_20251201_journal.pdf', '2025-12-01 14:57:37'),
(873, 27, 'start_shift', 'Caissier a démarré la session avec solde 0 BIF', '2025-12-01 14:58:06'),
(874, 27, 'create_invoice', 'Created unpaid invoice with number INV-20251201-6535 for customer BURIKUKIYE GASPARD, total amount 3,000,000.00 BIF', '2025-12-01 14:58:24'),
(875, 18, 'approve_invoices', 'approve invoice 76 with comment: ok', '2025-12-01 14:59:01'),
(876, 27, 'process_payment', 'Processed payment for invoice INV-20251201-6535 (TVAC) with subtotal 3.000.000 BIF, TVA 540.000 BIF, total 3.540.000 BIF', '2025-12-01 14:59:16'),
(877, 27, 'reprint_receipt', 'Reprinted receipt/invoice INV-20251201-6535 (ID: 235cd255-e1e2-4389-9e7e-2ece240b9fc2)', '2025-12-01 14:59:17'),
(878, 27, 'end_shift', 'Caissier a fermé la session. Attendu 0 BIF, compté 3540000 BIF, différence 3540000 BIF, journal: christa_nemeyimana_20251201_journal.pdf', '2025-12-01 15:00:02'),
(879, 27, 'start_shift', 'Caissier a démarré la session avec solde 0 BIF', '2025-12-01 15:08:37'),
(880, 27, 'loan_repayment', 'Recorded loan repayment of 1.000.000 BIF for customer ID 15', '2025-12-01 15:08:51'),
(881, 27, 'end_shift', 'Caissier a fermé la session. Attendu 1000000 BIF, compté 1000000 BIF, différence 0 BIF, journal: christa_nemeyimana_20251201_journal.pdf', '2025-12-01 15:21:35'),
(882, 27, 'logout', 'User Christa Nemeyimana logged out', '2025-12-01 15:33:25'),
(883, 27, 'login', 'User christa logged in', '2025-12-01 15:33:29'),
(884, 27, 'logout', 'User Christa Nemeyimana logged out', '2025-12-01 15:33:39'),
(885, 19, 'login', 'User jmarie logged in', '2025-12-01 15:33:44'),
(886, 19, 'logout', 'User Jean Marie logged out', '2025-12-01 15:33:57'),
(887, 27, 'login', 'User christa logged in', '2025-12-01 15:34:39'),
(888, 27, 'logout', 'User Christa Nemeyimana logged out', '2025-12-01 15:36:25'),
(889, 27, 'login', 'User christa logged in', '2025-12-01 15:36:45'),
(890, 27, 'start_shift', 'Caissier a démarré la session avec solde 0 BIF', '2025-12-01 15:37:20'),
(891, 27, 'create_invoice', 'Created unpaid invoice with number INV-20251201-0185 for customer MAHORO BAR, total amount 6,000,000.00 BIF', '2025-12-01 16:14:32'),
(892, 27, 'create_invoice', 'Created unpaid invoice with number INV-20251201-9778 for customer BURIKUKIYE GASPARD, total amount 12,000,000.00 BIF', '2025-12-01 16:14:52'),
(893, 18, 'approve_invoices', 'approve invoice 78 with comment: ok', '2025-12-01 16:15:11'),
(894, 18, 'approve_invoices', 'approve invoice 77 with comment: ok', '2025-12-01 16:15:17'),
(895, 27, 'process_payment', 'Processed payment for invoice INV-20251201-9778 (HTVA) with subtotal 12.000.000 BIF, TVA 0 BIF, total 12.000.000 BIF', '2025-12-01 16:15:39'),
(896, 27, 'reprint_receipt', 'Reprinted receipt/invoice INV-20251201-9778 (ID: 26371cd6-0b4c-4642-9ebf-f09128b718d2)', '2025-12-01 16:15:40'),
(897, 27, 'process_payment', 'Processed payment for invoice INV-20251201-0185 (HTVA) with subtotal 6.000.000 BIF, TVA 0 BIF, total 6.000.000 BIF', '2025-12-01 16:15:51'),
(898, 27, 'reprint_receipt', 'Reprinted receipt/invoice INV-20251201-0185 (ID: a19c11f9-bc6c-4226-b5cd-4a1c8d3a4212)', '2025-12-01 16:15:52'),
(899, 27, 'end_shift', 'Caissier a fermé la session. Attendu 0 BIF, compté 18000000 BIF, différence 18000000 BIF, journal: christa_nemeyimana_20251201_journal.pdf', '2025-12-01 16:16:14'),
(900, 27, 'logout', 'User Christa Nemeyimana logged out', '2025-12-01 16:24:57'),
(901, 18, 'add_user', 'Added user \'innocent\' (ID: 28, Role: Conseil d\'Administration, Depot: N/A, Region: N/A, Address: kb)', '2025-12-01 16:28:22'),
(902, 28, 'login', 'User innocent logged in', '2025-12-01 16:28:36'),
(903, 18, 'logout', 'User Jean Jacques logged out', '2025-12-01 16:31:32'),
(904, 28, 'login', 'User innocent logged in', '2025-12-01 17:24:56'),
(905, 28, 'logout', 'User Innocent Hakizimana logged out', '2025-12-01 17:31:07'),
(906, 18, 'login', 'User jacques logged in', '2025-12-01 17:31:13'),
(907, 26, 'login', 'User divine logged in', '2025-12-01 17:33:05'),
(908, 18, 'logout', 'User Jean Jacques logged out', '2025-12-01 17:42:02'),
(909, 27, 'login', 'User christa logged in', '2025-12-01 17:49:55'),
(910, 27, 'start_shift', 'Caissier a démarré la session avec solde 0 BIF', '2025-12-01 17:50:08'),
(911, 27, 'end_shift', 'Caissier a fermé la session. Attendu 0 BIF, compté 0 BIF, différence 0 BIF, journal: christa_nemeyimana_20251201_journal.pdf', '2025-12-01 17:50:32'),
(912, 27, 'logout', 'User Christa Nemeyimana logged out', '2025-12-01 17:57:43'),
(913, 28, 'login', 'User innocent logged in', '2025-12-01 18:01:37'),
(914, 28, 'logout', 'User Innocent Hakizimana logged out', '2025-12-01 18:03:45'),
(915, 18, 'login', 'User jacques logged in', '2025-12-01 18:04:06'),
(916, 18, 'logout', 'User Jean Jacques logged out', '2025-12-01 18:04:56'),
(917, 19, 'login', 'User jmarie logged in', '2025-12-01 18:06:21'),
(918, 19, 'logout', 'User Jean Marie logged out', '2025-12-01 18:07:08'),
(919, 18, 'login', 'User jacques logged in', '2025-12-01 18:07:16'),
(920, 26, 'logout', 'User Divine Nshimirimana logged out', '2025-12-01 18:08:39'),
(921, 27, 'login', 'User christa logged in', '2025-12-01 18:08:44'),
(922, 18, 'logout', 'User Jean Jacques logged out', '2025-12-01 19:02:27'),
(923, 27, 'login', 'User christa logged in', '2025-12-03 17:39:55'),
(924, 18, 'login', 'User jacques logged in', '2025-12-04 10:45:48'),
(925, 27, 'logout', 'User Christa Nemeyimana logged out', '2025-12-04 11:28:52'),
(926, 18, 'login', 'User jacques logged in', '2025-12-04 11:28:56'),
(927, 18, 'logout', 'User Jean Jacques logged out', '2025-12-04 11:33:11'),
(928, 26, 'login', 'User divine logged in', '2025-12-04 11:33:21'),
(929, 26, 'logout', 'User Divine Nshimirimana logged out', '2025-12-04 11:40:08'),
(930, 18, 'login', 'User jacques logged in', '2025-12-04 11:40:12'),
(931, 18, 'logout', 'User Jean Jacques logged out', '2025-12-04 11:49:11'),
(932, 27, 'login', 'User christa logged in', '2025-12-04 11:49:16'),
(933, 27, 'start_shift', 'Caissier a démarré la session avec solde 0 BIF', '2025-12-04 11:49:20'),
(934, 27, 'create_invoice', 'Created unpaid invoice with number INV-20251204-9006 for customer MAHORO BAR, total amount 120,000,000.00 BIF', '2025-12-04 11:50:09'),
(935, 27, 'logout', 'User Christa Nemeyimana logged out', '2025-12-04 11:50:13'),
(936, 18, 'login', 'User jacques logged in', '2025-12-04 11:50:20'),
(937, 18, 'approve_invoices', 'approve invoice 79 with comment: ok', '2025-12-04 11:50:34'),
(938, 18, 'logout', 'User Jean Jacques logged out', '2025-12-04 11:50:40'),
(939, 27, 'login', 'User christa logged in', '2025-12-04 11:50:43'),
(940, 27, 'process_payment', 'Processed payment for invoice INV-20251204-9006 (TVAC) with subtotal 120.000.000 BIF, TVA 21.600.000 BIF, total 141.600.000 BIF', '2025-12-04 11:51:02'),
(941, 27, 'reprint_receipt', 'Reprinted receipt/invoice INV-20251204-9006 (ID: 69f2b78c-f6ff-4b3c-9609-3a0931a804b7)', '2025-12-04 11:51:03'),
(942, 27, 'pay_requisition', 'Paid requisition ID 12 for 1340000 BIF with receipt REQ-20251204-6322 to external recipient K (65236635)', '2025-12-04 11:51:31'),
(943, 27, 'logout', 'User Christa Nemeyimana logged out', '2025-12-04 11:52:01'),
(944, 18, 'login', 'User jacques logged in', '2025-12-04 11:52:04'),
(945, 18, 'logout', 'User Jean Jacques logged out', '2025-12-04 11:55:29'),
(946, 26, 'login', 'User divine logged in', '2025-12-04 11:55:39'),
(947, 26, 'logout', 'User Divine Nshimirimana logged out', '2025-12-04 11:56:02'),
(948, 18, 'login', 'User jacques logged in', '2025-12-04 11:56:06'),
(949, 18, 'logout', 'User Jean Jacques logged out', '2025-12-04 13:54:04'),
(950, 26, 'login', 'User divine logged in', '2025-12-04 13:54:07'),
(951, 26, 'logout', 'User Divine Nshimirimana logged out', '2025-12-04 14:07:20'),
(952, 26, 'login', 'User divine logged in', '2025-12-04 14:09:41'),
(953, 26, 'logout', 'User Divine Nshimirimana logged out', '2025-12-04 14:10:14'),
(954, 18, 'login', 'User jacques logged in', '2025-12-04 14:10:19'),
(955, 18, 'login', 'User jacques logged in', '2025-12-04 14:21:24'),
(956, 18, 'logout', 'User Jean Jacques logged out', '2025-12-04 14:36:55'),
(957, 18, 'login', 'User jacques logged in', '2025-12-04 14:37:20'),
(958, 18, 'logout', 'User Jean Jacques logged out', '2025-12-04 14:38:22'),
(959, 18, 'logout', 'User Jean Jacques logged out', '2025-12-04 15:19:23'),
(960, 18, 'login', 'User jacques logged in', '2025-12-05 12:18:14'),
(961, 18, 'logout', 'User Jean Jacques logged out', '2025-12-05 12:18:30'),
(962, 18, 'login', 'User jacques logged in', '2025-12-05 17:15:26'),
(963, 18, 'logout', 'User Jean Jacques logged out', '2025-12-05 17:16:08'),
(964, 18, 'login', 'User jacques logged in', '2025-12-05 17:16:51'),
(965, 18, 'logout', 'User Jean Jacques logged out', '2025-12-05 17:17:13'),
(966, 18, 'login', 'User jacques logged in', '2025-12-05 17:19:21'),
(967, 18, 'add_user', 'Added user \'test\' (ID: 29, Role: Agent Marketing, Depot: N/A, Region: N/A, Mobile1: 71557480, Mobile2: 72558365, Address: Kibenga, Av du Large no 45)', '2025-12-05 17:43:03'),
(968, 18, 'create_customer', 'Created customer \'test_client\' by user Jean Jacques (ID: 18)', '2025-12-05 18:31:51'),
(969, 18, 'create_province', 'Created depot \'Buyenzi\' (ID: 4, Address: 18 Avenue no 1)', '2025-12-05 18:44:30'),
(970, 18, 'logout', 'User Jean Jacques logged out', '2025-12-05 19:09:04'),
(971, 18, 'login', 'User jacques logged in', '2025-12-06 15:07:11'),
(972, 18, 'logout', 'User Jean Jacques logged out', '2025-12-07 00:44:42'),
(973, 27, 'login', 'User christa logged in', '2025-12-07 00:46:01'),
(974, 27, 'create_invoice', 'Created unpaid invoice with number INV-20251206-5301 for customer BURIKUKIYE GASPARD, total amount 3,000,000.00 BIF', '2025-12-07 00:46:35'),
(975, 18, 'login', 'User jacques logged in', '2025-12-07 00:46:50'),
(976, 18, 'approve_invoices', 'approve invoice 80 with comment: ok', '2025-12-07 00:47:15'),
(977, 27, 'process_payment', 'Processed payment for invoice INV-20251206-5301 (TVAC) with subtotal 3.000.000 BIF, TVA 540.000 BIF, total 3.540.000 BIF', '2025-12-07 00:47:58'),
(978, 27, 'reprint_receipt', 'Reprinted receipt/invoice INV-20251206-5301 (ID: bf226941-750c-4c20-83fd-a83f0a7d60a4)', '2025-12-07 00:47:59'),
(979, 18, 'logout', 'User Jean Jacques logged out', '2025-12-07 01:14:56'),
(980, 18, 'login', 'User jacques logged in', '2025-12-10 10:03:04'),
(981, 18, 'create_requisition', 'Created requisition ID 13 for 10000 BIF, recipient_id=NULL (auto-approved by DGA)', '2025-12-10 10:03:54'),
(982, 18, 'logout', 'User Jean Jacques logged out', '2025-12-10 10:05:14'),
(983, 27, 'login', 'User christa logged in', '2025-12-10 10:05:18'),
(984, 27, 'pay_requisition', 'Paid requisition ID 13 for 10000 BIF with receipt REQ-20251210-8477 to internal recipient Fabrice Ndikumana', '2025-12-10 10:05:30'),
(985, 27, 'logout', 'User Christa Nemeyimana logged out', '2025-12-10 14:11:35'),
(986, 27, 'login', 'User christa logged in', '2025-12-11 16:46:15'),
(987, 27, 'end_shift', 'Caissier a fermé la session. Attendu 0 BIF, compté 143790000 BIF, différence 143790000 BIF, journal: christa_nemeyimana_20251211_journal.pdf', '2025-12-11 16:46:43'),
(988, 27, 'start_shift', 'Caissier a démarré la session avec solde 0 BIF', '2025-12-11 16:47:00'),
(989, 27, 'create_invoice', 'Created unpaid invoice with number INV-20251211-9562 for customer MAHORO BAR, total amount 30,000,000.00 BIF', '2025-12-11 16:47:27'),
(990, 27, 'logout', 'User Christa Nemeyimana logged out', '2025-12-11 16:47:31'),
(991, 18, 'login', 'User jacques logged in', '2025-12-11 16:47:35'),
(992, 18, 'approve_invoices', 'approve invoice 81 with comment: ok', '2025-12-11 16:48:02'),
(993, 18, 'logout', 'User Jean Jacques logged out', '2025-12-11 16:48:05'),
(994, 27, 'login', 'User christa logged in', '2025-12-11 16:48:07'),
(995, 27, 'process_payment', 'Processed bank slip payment for invoice INV-20251211-9562 (HTVA) total 30.000.000 BIF on account 312500362562', '2025-12-11 18:36:54'),
(996, 27, 'reprint_receipt', 'Reprinted receipt/invoice INV-20251211-9562 (ID: 1fafce21-d966-4b04-9cbb-b14c95fcc42f)', '2025-12-11 18:36:55'),
(997, 27, 'logout', 'User Christa Nemeyimana logged out', '2025-12-11 18:38:53'),
(998, 18, 'login', 'User jacques logged in', '2025-12-11 18:41:23'),
(999, 18, 'logout', 'User Jean Jacques logged out', '2025-12-11 18:43:41'),
(1000, 26, 'login', 'User divine logged in', '2025-12-11 18:43:47'),
(1001, 26, 'logout', 'User Divine Nshimirimana logged out', '2025-12-11 19:27:33'),
(1002, 18, 'login', 'User jacques logged in', '2025-12-11 19:27:36'),
(1003, 18, 'logout', 'User Jean Jacques logged out', '2025-12-11 19:50:07'),
(1004, 26, 'login', 'User divine logged in', '2025-12-11 19:50:10'),
(1005, 26, 'logout', 'User Divine Nshimirimana logged out', '2025-12-11 19:53:57'),
(1006, 26, 'login', 'User divine logged in', '2025-12-11 19:54:01'),
(1007, 26, 'logout', 'User Divine Nshimirimana logged out', '2025-12-11 19:55:29'),
(1008, 26, 'login', 'User divine logged in', '2025-12-11 19:55:31'),
(1009, 26, 'logout', 'User Divine Nshimirimana logged out', '2025-12-11 19:55:57'),
(1010, 18, 'login', 'User jacques logged in', '2025-12-11 19:56:02'),
(1011, 18, 'logout', 'User Jean Jacques logged out', '2025-12-11 20:00:16'),
(1012, 26, 'login', 'User divine logged in', '2025-12-11 20:00:21'),
(1013, 18, 'login', 'User jacques logged in', '2025-12-13 12:44:52'),
(1014, 18, 'login', 'User jacques logged in', '2025-12-13 12:50:15'),
(1015, 18, 'logout', 'User Jean Jacques logged out', '2025-12-13 12:50:35'),
(1016, 18, 'login', 'User jacques logged in', '2025-12-13 12:50:40'),
(1017, 18, 'logout', 'User Jean Jacques logged out', '2025-12-13 12:58:04'),
(1018, 27, 'login', 'User christa logged in', '2025-12-13 12:58:09'),
(1019, 20, 'login', 'User bosco logged in', '2025-12-13 12:59:03'),
(1020, 18, 'add_stock', 'Ajouté 1.000 crates de Senator50cl au stock principal', '2025-12-13 12:59:31'),
(1021, 18, 'initiate_transfer', 'Transfert de stock initié avec l\'ID d\'expédition 110798 pour 700 caisses vers gestionnaire de stock Bosco NSHIMIRIMANA (Mirango) : Senator50cl (500 crates), Soma 75 cl (100 crates), Vin (100 crates)', '2025-12-13 13:00:45'),
(1022, 20, 'reject_transfer', 'Rejected stock transfer for transfert ID 110798', '2025-12-13 13:01:12'),
(1023, 18, 'initiate_transfer', 'Transfert de stock initié avec l\'ID d\'expédition 330794 pour 600 caisses vers gestionnaire de stock Bosco NSHIMIRIMANA (Mirango) : Senator50cl (500 crates), Soma 75 cl (100 crates)', '2025-12-13 13:02:18'),
(1024, 20, 'confirm_transfer', 'Confirmed stock transfer reception for transfert ID 330794', '2025-12-13 13:02:27'),
(1025, 27, 'create_invoice', 'Created unpaid invoice with number INV-20251213-2198 for customer BURIKUKIYE GASPARD, total amount 190,000,000.00 BIF', '2025-12-13 13:03:41'),
(1026, 20, 'approve_invoices', 'approve invoice 82 with comment: OK', '2025-12-13 13:07:58'),
(1027, 27, 'process_payment', 'Processed payment for invoice INV-20251213-2198 (HTVA) with subtotal 190.000.000 BIF, TVA 0 BIF, total 190.000.000 BIF', '2025-12-13 13:08:53'),
(1028, 27, 'reprint_receipt', 'Reprinted receipt/invoice INV-20251213-2198 (ID: 7804a9ae-9e76-4f86-9581-e590be2c49e5)', '2025-12-13 13:08:54'),
(1029, 26, 'login', 'User divine logged in', '2025-12-13 13:11:48'),
(1030, 27, 'create_invoice', 'Created unpaid invoice with number INV-20251213-8517 for customer MAHORO BAR, total amount 1,000,000.00 BIF [Loan sale]', '2025-12-13 13:30:11'),
(1031, 18, 'approve_invoices', 'approve invoice 83 with comment: ok', '2025-12-13 13:31:37'),
(1032, 27, 'process_payment', 'Processed loan payment for invoice INV-20251213-8517 - debt recorded: 1.000.000 BIF', '2025-12-13 13:33:19'),
(1033, 27, 'reprint_receipt', 'Reprinted receipt/invoice INV-20251213-8517 (ID: befde788-7801-4501-8afc-2bd0b46e1327)', '2025-12-13 13:33:20'),
(1034, 18, 'edit_customer', 'Edited customer \'KARIKURUBU PAUL\' (ID: 18) by user Jean Jacques (ID: 18)', '2025-12-13 14:25:01'),
(1035, 27, 'create_invoice', 'Created unpaid invoice with number INV-20251213-1765 for customer KARIKURUBU PAUL, total amount 600,000.00 BIF', '2025-12-13 14:30:30'),
(1036, 27, 'create_invoice', 'Created unpaid invoice with number INV-20251213-8742 for customer KARIKURUBU PAUL, total amount 400,000.00 BIF [Loan sale]', '2025-12-13 14:38:12'),
(1037, 18, 'approve_invoices', 'approve invoice 85 with comment: ok', '2025-12-13 14:38:37'),
(1038, 18, 'approve_invoices', 'approve invoice 84 with comment: ok', '2025-12-13 14:38:51'),
(1039, 27, 'process_payment', 'Processed loan payment for invoice INV-20251213-8742 - debt recorded: 400.000 BIF', '2025-12-13 14:39:05'),
(1040, 27, 'reprint_receipt', 'Reprinted receipt/invoice INV-20251213-8742 (ID: a8ceac0e-81b2-4471-8a09-224ed48f2d17)', '2025-12-13 14:39:06'),
(1041, 27, 'process_payment', 'Processed payment for invoice INV-20251213-1765 (TVAC) with subtotal 600.000 BIF, TVA 108.000 BIF, total 708.000 BIF', '2025-12-13 14:39:38'),
(1042, 27, 'reprint_receipt', 'Reprinted receipt/invoice INV-20251213-1765 (ID: 2d4af3e8-d320-40d8-931a-ff9b50262c56)', '2025-12-13 14:39:38'),
(1043, 20, 'login', 'User bosco logged in', '2025-12-13 14:40:33'),
(1044, 18, 'logout', 'User Jean Jacques logged out', '2025-12-13 14:47:19'),
(1045, 18, 'login', 'User jacques logged in', '2025-12-13 14:47:20'),
(1046, 27, 'loan_repayment', 'Recorded loan repayment of 400.000 BIF for customer ID 18 against invoice INV-20251213-8742', '2025-12-13 16:08:23'),
(1047, 27, 'loan_repayment', 'Recorded loan repayment of 1.000.000 BIF for customer ID 15', '2025-12-13 16:10:07'),
(1048, 18, 'logout', 'User Jean Jacques logged out', '2025-12-13 16:27:05'),
(1049, 18, 'login', 'User jacques logged in', '2025-12-13 16:27:06'),
(1050, 27, 'create_invoice', 'Created unpaid invoice with number INV-20251213-0078 for customer KARIKURUBU PAUL, total amount 200,000.00 BIF [Loan sale]', '2025-12-13 16:36:12'),
(1051, 18, 'approve_invoices', 'approve invoice 86 with comment: ok', '2025-12-13 16:36:46'),
(1052, 20, 'create_requisition', 'Created requisition ID 14 for 100000 BIF, external recipient \'Guillaume\'', '2025-12-13 17:09:53'),
(1053, 18, 'create_requisition', 'Created requisition ID 15 for 400000 BIF, recipient_id=NULL (auto-approved by DGA)', '2025-12-13 17:10:40'),
(1054, 27, 'end_shift', 'Caissier a fermé la session. Attendu 223508000 BIF, compté 191708000 BIF, différence -31800000 BIF, journal: christa_nemeyimana_20251213_journal.pdf', '2025-12-13 17:37:00'),
(1055, 27, 'cash_transfer', 'Cash transfer of 143790000 BIF recorded for shift 22 (ended 2025-12-11 16:46) to accountant ID 26', '2025-12-13 17:39:08'),
(1056, 26, 'receive_cash', 'Confirmed transfer #4 for 143790000 BIF', '2025-12-13 17:47:23'),
(1057, 18, 'logout', 'User Jean Jacques logged out', '2025-12-13 17:51:46'),
(1058, 18, 'login', 'User jacques logged in', '2025-12-13 17:51:47'),
(1059, 20, 'logout', 'User Bosco NSHIMIRIMANA logged out', '2025-12-13 18:33:01'),
(1060, 17, 'login', 'User hakizimanap logged in', '2025-12-13 18:33:13'),
(1061, 17, 'logout', 'User HAKIZIMANA PIERRE logged out', '2025-12-13 18:34:06'),
(1062, 22, 'login', 'User ella logged in', '2025-12-13 18:34:10'),
(1063, 27, 'logout', 'User Christa Nemeyimana logged out', '2025-12-13 19:14:59'),
(1064, 27, 'login', 'User christa logged in', '2025-12-13 19:15:31'),
(1065, 27, 'logout', 'User Christa Nemeyimana logged out', '2025-12-13 19:15:34');

-- --------------------------------------------------------

--
-- Table structure for table `main_stock`
--

CREATE TABLE `main_stock` (
  `id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT 0,
  `reserved_quantity` int(11) NOT NULL DEFAULT 0,
  `unit_type` enum('crates') NOT NULL DEFAULT 'crates',
  `last_updated` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `main_stock`
--

INSERT INTO `main_stock` (`id`, `product_id`, `quantity`, `reserved_quantity`, `unit_type`, `last_updated`) VALUES
(16, 7, 6900, 0, 'crates', '2025-11-28 15:56:55'),
(17, 8, 500, 0, 'crates', '2025-11-29 18:26:46'),
(18, 9, 500, 0, 'crates', '2025-12-13 12:59:31');

-- --------------------------------------------------------

--
-- Table structure for table `operation_manager_stock`
--

CREATE TABLE `operation_manager_stock` (
  `id` int(11) NOT NULL,
  `operation_manager_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT 0,
  `reserved_quantity` int(11) NOT NULL DEFAULT 0,
  `unit_type` enum('crates') NOT NULL DEFAULT 'crates',
  `last_updated` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `order`
--

CREATE TABLE `order` (
  `id` int(11) NOT NULL,
  `agent_id` int(11) NOT NULL,
  `province_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `unit_type` enum('crates') NOT NULL DEFAULT 'crates',
  `order_type` enum('wholesale','retail') NOT NULL,
  `status` enum('pending','approved','rejected') NOT NULL DEFAULT 'pending',
  `approved_by_stock_manager` int(11) DEFAULT NULL,
  `approved_by_operation_manager` int(11) DEFAULT NULL,
  `is_credit` tinyint(1) NOT NULL DEFAULT 0,
  `credit_approved_by` int(11) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `customer_name` varchar(100) DEFAULT NULL,
  `table_number` varchar(50) DEFAULT NULL,
  `receipt_number` varchar(50) DEFAULT NULL,
  `payment_method` enum('cash','bank_transfer','mobile') DEFAULT NULL,
  `payment_details` text DEFAULT NULL,
  `paid_amount` bigint(20) DEFAULT NULL,
  `subtotal_amount` bigint(20) DEFAULT NULL,
  `tax_amount` bigint(20) NOT NULL DEFAULT 0,
  `tax_rate` decimal(5,2) NOT NULL DEFAULT 18.00,
  `tax_mode` enum('HTVA','TVAC') NOT NULL DEFAULT 'HTVA',
  `total_with_tax` bigint(20) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `nif` varchar(50) DEFAULT NULL,
  `rc` varchar(50) DEFAULT NULL,
  `phone_number` varchar(20) DEFAULT NULL,
  `sale_type` enum('retail','wholesale') NOT NULL,
  `invoice_number` varchar(20) NOT NULL,
  `paid_status` enum('Paid','Unpaid') NOT NULL DEFAULT 'Unpaid',
  `serve_status` enum('Pending','Served') NOT NULL DEFAULT 'Pending',
  `province_stock_id` int(11) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `paid_invoices`
--

CREATE TABLE `paid_invoices` (
  `id` int(11) NOT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `is_loan_sale` tinyint(1) NOT NULL DEFAULT 0,
  `loan_amount_bif` bigint(20) NOT NULL DEFAULT 0,
  `stock_manager_id` int(11) NOT NULL,
  `status` enum('pending','paid','unpaid') NOT NULL DEFAULT 'paid',
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `customer_name` varchar(255) NOT NULL,
  `phone_number` varchar(20) NOT NULL,
  `province_id` int(11) NOT NULL,
  `nif` varchar(50) DEFAULT NULL,
  `rc` varchar(50) DEFAULT NULL,
  `invoice_number` varchar(20) NOT NULL,
  `serve_status` enum('Pending','Served') NOT NULL DEFAULT 'Served',
  `paid_amount` bigint(20) NOT NULL,
  `subtotal_amount` bigint(20) NOT NULL DEFAULT 0,
  `tax_amount` bigint(20) NOT NULL DEFAULT 0,
  `tax_rate` decimal(5,2) NOT NULL DEFAULT 18.00,
  `tax_mode` enum('HTVA','TVAC') NOT NULL DEFAULT 'HTVA',
  `approved_by` int(11) DEFAULT NULL,
  `approval_status` enum('pending','approved','rejected') NOT NULL DEFAULT 'approved',
  `approved_at` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `paid_at` datetime NOT NULL DEFAULT current_timestamp(),
  `payment_method` enum('cash','bank_transfer','mobile') DEFAULT NULL,
  `payment_details` text DEFAULT NULL,
  `served_by` int(11) DEFAULT NULL,
  `sale_type` enum('retail','wholesale') NOT NULL DEFAULT 'retail',
  `served_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `expiration_status` enum('pending','expired','finalized') DEFAULT 'pending'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `paid_invoices`
--

INSERT INTO `paid_invoices` (`id`, `customer_id`, `is_loan_sale`, `loan_amount_bif`, `stock_manager_id`, `status`, `created_at`, `customer_name`, `phone_number`, `province_id`, `nif`, `rc`, `invoice_number`, `serve_status`, `paid_amount`, `subtotal_amount`, `tax_amount`, `tax_rate`, `tax_mode`, `approved_by`, `approval_status`, `approved_at`, `created_by`, `paid_at`, `payment_method`, `payment_details`, `served_by`, `sale_type`, `served_at`, `expires_at`, `expiration_status`) VALUES
(47, NULL, 0, 0, 20, 'paid', '2025-11-28 16:01:19', 'MAHORO BAR', '65265365', 1, '4000002365', '', 'INV-20251128-0540', 'Pending', 7080000, 6000000, 1080000, 18.00, 'TVAC', 20, 'approved', '2025-11-28 16:02:10', 27, '2025-11-28 16:19:15', NULL, 'ok', NULL, 'wholesale', NULL, NULL, 'pending'),
(48, NULL, 0, 0, 20, 'paid', '2025-11-28 16:54:16', 'MAHORO BAR', '65265365', 1, '4000002365', '', 'INV-20251128-5614', 'Pending', 10000000, 10000000, 0, 18.00, 'HTVA', 20, 'approved', '2025-11-28 16:54:32', 27, '2025-11-28 16:59:43', NULL, 'ok', NULL, 'wholesale', NULL, NULL, 'pending'),
(49, NULL, 0, 0, 20, 'paid', '2025-12-01 14:48:22', 'BURIKUKIYE GASPARD', '62582365', 1, '40000000052', '', 'INV-20251201-5570', 'Pending', 23600000, 20000000, 3600000, 18.00, 'TVAC', 18, 'approved', '2025-12-01 14:50:46', 27, '2025-12-01 14:51:18', NULL, 'ok', NULL, 'wholesale', NULL, NULL, 'pending'),
(50, NULL, 1, 1000000, 20, 'paid', '2025-11-28 18:37:28', 'MAHORO BAR', '65265365', 1, '4000002365', '', 'INV-20251128-0520', 'Pending', 1000000, 1000000, 0, 18.00, 'HTVA', 18, 'approved', '2025-11-28 18:37:43', 27, '2025-12-01 14:51:40', NULL, 'ok | Type Paiement: Crédit', NULL, 'wholesale', NULL, NULL, 'pending'),
(51, NULL, 0, 0, 20, 'paid', '2025-12-01 14:52:14', 'BURIKUKIYE GASPARD', '62582365', 1, '40000000052', '', 'INV-20251201-2430', 'Pending', 60000000, 60000000, 0, 18.00, 'HTVA', 18, 'approved', '2025-12-01 14:52:22', 27, '2025-12-01 14:52:34', NULL, NULL, NULL, 'wholesale', NULL, NULL, 'pending'),
(52, NULL, 0, 0, 20, 'paid', '2025-12-01 14:58:24', 'BURIKUKIYE GASPARD', '62582365', 1, '40000000052', '', 'INV-20251201-6535', 'Pending', 3540000, 3000000, 540000, 18.00, 'TVAC', 18, 'approved', '2025-12-01 14:59:01', 27, '2025-12-01 14:59:16', NULL, 'ok', NULL, 'wholesale', NULL, NULL, 'pending'),
(53, NULL, 0, 0, 20, 'paid', '2025-12-01 16:14:52', 'BURIKUKIYE GASPARD', '62582365', 1, '40000000052', '', 'INV-20251201-9778', 'Pending', 12000000, 12000000, 0, 18.00, 'HTVA', 18, 'approved', '2025-12-01 16:15:11', 27, '2025-12-01 16:15:39', NULL, 'ok', NULL, 'wholesale', NULL, NULL, 'pending'),
(54, NULL, 0, 0, 20, 'paid', '2025-12-01 16:14:32', 'MAHORO BAR', '65265365', 1, '4000002365', '', 'INV-20251201-0185', 'Pending', 6000000, 6000000, 0, 18.00, 'HTVA', 18, 'approved', '2025-12-01 16:15:17', 27, '2025-12-01 16:15:51', NULL, 'ok', NULL, 'wholesale', NULL, NULL, 'pending'),
(55, NULL, 0, 0, 20, 'paid', '2025-12-04 11:50:09', 'MAHORO BAR', '65265365', 1, '4000002365', '', 'INV-20251204-9006', 'Pending', 141600000, 120000000, 21600000, 18.00, 'TVAC', 18, 'approved', '2025-12-04 11:50:34', 27, '2025-12-04 11:51:02', NULL, 'ok', NULL, 'wholesale', NULL, NULL, 'pending'),
(56, NULL, 0, 0, 20, 'paid', '2025-12-07 00:46:35', 'BURIKUKIYE GASPARD', '62582365', 1, '40000000052', '', 'INV-20251206-5301', 'Pending', 3540000, 3000000, 540000, 18.00, 'TVAC', 18, 'approved', '2025-12-07 00:47:15', 27, '2025-12-07 00:47:58', NULL, 'ok', NULL, 'wholesale', NULL, NULL, 'pending'),
(58, NULL, 0, 0, 20, 'paid', '2025-12-11 16:47:27', 'MAHORO BAR', '65265365', 1, '4000002365', '', 'INV-20251211-9562', 'Pending', 30000000, 30000000, 0, 18.00, 'HTVA', 18, 'approved', '2025-12-11 16:48:02', 27, '2025-12-11 18:36:54', 'bank_transfer', 'ok | Type Paiement: Bordereau Bancaire | Bordereau: 12356854 | Compte: 312500362562 BIF | Fichier: /masunzu_bar_hotel/uploads/bank_slips/bankslip_27_1765471014_2842cb_bordereau_crdb.jpeg', NULL, 'wholesale', NULL, NULL, 'pending'),
(59, NULL, 0, 0, 20, 'paid', '2025-12-13 13:03:41', 'BURIKUKIYE GASPARD', '62582365', 1, '40000000052', '', 'INV-20251213-2198', 'Pending', 190000000, 190000000, 0, 18.00, 'HTVA', 20, 'approved', '2025-12-13 13:07:58', 27, '2025-12-13 13:08:53', 'cash', 'OK', NULL, 'wholesale', NULL, NULL, 'pending'),
(60, NULL, 1, 1000000, 20, 'paid', '2025-12-13 13:30:11', 'MAHORO BAR', '65265365', 1, '4000002365', '', 'INV-20251213-8517', 'Pending', 1000000, 1000000, 0, 18.00, 'HTVA', 18, 'approved', '2025-12-13 13:31:37', 27, '2025-12-13 13:33:19', 'cash', 'OK | Type Paiement: Crédit', NULL, 'wholesale', NULL, NULL, 'pending'),
(61, NULL, 1, 400000, 20, 'paid', '2025-12-13 14:38:12', 'KARIKURUBU PAUL', '76215365', 1, '4000056236', '', 'INV-20251213-8742', 'Pending', 400000, 400000, 0, 18.00, 'HTVA', 18, 'approved', '2025-12-13 14:38:37', 27, '2025-12-13 14:39:05', 'cash', 'OK | Type Paiement: Crédit', NULL, 'wholesale', NULL, NULL, 'pending'),
(62, NULL, 0, 0, 20, 'paid', '2025-12-13 14:30:30', 'KARIKURUBU PAUL', '76215365', 1, '4000056236', '', 'INV-20251213-1765', 'Pending', 708000, 600000, 108000, 18.00, 'TVAC', 18, 'approved', '2025-12-13 14:38:51', 27, '2025-12-13 14:39:38', 'cash', 'OK', NULL, 'wholesale', NULL, NULL, 'pending');

-- --------------------------------------------------------

--
-- Table structure for table `paid_invoices_backup_20251010`
--

CREATE TABLE `paid_invoices_backup_20251010` (
  `id` int(11) NOT NULL DEFAULT 0,
  `stock_manager_id` int(11) NOT NULL,
  `status` enum('pending','paid','unpaid') NOT NULL DEFAULT 'paid',
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `customer_name` varchar(255) NOT NULL,
  `phone_number` varchar(20) NOT NULL,
  `province_id` int(11) NOT NULL,
  `nif` varchar(50) DEFAULT NULL,
  `rc` varchar(50) DEFAULT NULL,
  `invoice_number` varchar(20) NOT NULL,
  `serve_status` enum('Pending','Served') NOT NULL DEFAULT 'Served',
  `paid_amount` bigint(20) NOT NULL,
  `approved_by` int(11) DEFAULT NULL,
  `approval_status` enum('pending','approved','rejected') NOT NULL DEFAULT 'approved',
  `approved_at` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `paid_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `paid_invoice_items`
--

CREATE TABLE `paid_invoice_items` (
  `id` int(11) NOT NULL,
  `invoice_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `unit_price` bigint(20) NOT NULL,
  `price_source` varchar(20) DEFAULT 'system',
  `system_unit_price` bigint(20) DEFAULT NULL,
  `custom_unit_price` bigint(20) DEFAULT NULL,
  `custom_price_basis` varchar(50) DEFAULT NULL,
  `custom_price_input` bigint(20) DEFAULT NULL,
  `custom_price_note` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `paid_invoice_items`
--

INSERT INTO `paid_invoice_items` (`id`, `invoice_id`, `product_id`, `quantity`, `unit_price`, `price_source`, `system_unit_price`, `custom_unit_price`, `custom_price_basis`, `custom_price_input`, `custom_price_note`) VALUES
(48, 47, 7, 30, 200000, 'system', NULL, NULL, NULL, NULL, NULL),
(49, 48, 7, 50, 200000, 'system', NULL, NULL, NULL, NULL, NULL),
(50, 49, 7, 100, 200000, 'system', NULL, NULL, NULL, NULL, NULL),
(51, 50, 7, 5, 200000, 'system', NULL, NULL, NULL, NULL, NULL),
(52, 51, 7, 300, 200000, 'system', NULL, NULL, NULL, NULL, NULL),
(53, 52, 7, 15, 200000, 'system', NULL, NULL, NULL, NULL, NULL),
(54, 53, 7, 60, 200000, 'system', NULL, NULL, NULL, NULL, NULL),
(55, 54, 7, 30, 200000, 'system', NULL, NULL, NULL, NULL, NULL),
(56, 55, 7, 400, 300000, 'system', NULL, NULL, NULL, NULL, NULL),
(57, 56, 7, 10, 300000, 'system', NULL, NULL, NULL, NULL, NULL),
(59, 58, 7, 100, 300000, 'system', NULL, NULL, NULL, NULL, NULL),
(60, 59, 9, 200, 200000, 'system', NULL, NULL, NULL, NULL, NULL),
(61, 59, 7, 500, 300000, 'system', NULL, NULL, NULL, NULL, NULL),
(63, 60, 9, 5, 200000, 'system', NULL, NULL, NULL, NULL, NULL),
(64, 61, 9, 2, 200000, 'system', NULL, NULL, NULL, NULL, NULL),
(65, 62, 9, 3, 200000, 'system', NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `product`
--

CREATE TABLE `product` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `volume_cl` int(11) NOT NULL,
  `crate_quantity` int(11) NOT NULL,
  `low_stock_alert_crates` int(11) DEFAULT NULL,
  `low_stock_alert_units` int(11) DEFAULT NULL,
  `expiration_date` date DEFAULT NULL,
  `price_per_crate` int(11) NOT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `product`
--

INSERT INTO `product` (`id`, `name`, `volume_cl`, `crate_quantity`, `low_stock_alert_crates`, `low_stock_alert_units`, `expiration_date`, `price_per_crate`, `created_by`, `created_at`) VALUES
(7, 'Soma 75 cl', 75, 20, 100, NULL, NULL, 300000, 18, '2025-11-28 15:56:44'),
(8, 'Vin', 80, 20, 50, NULL, NULL, 300000, 18, '2025-11-29 18:26:29'),
(9, 'Senator50cl', 50, 20, 50, NULL, NULL, 200000, 18, '2025-12-13 12:57:52');

-- --------------------------------------------------------

--
-- Table structure for table `product_price_history`
--

CREATE TABLE `product_price_history` (
  `id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `old_price` int(11) NOT NULL,
  `new_price` int(11) NOT NULL,
  `changed_by` int(11) NOT NULL,
  `changed_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `product_price_history`
--

INSERT INTO `product_price_history` (`id`, `product_id`, `old_price`, `new_price`, `changed_by`, `changed_at`) VALUES
(7, 7, 0, 200000, 18, '2025-11-28 15:56:44'),
(8, 8, 0, 300000, 18, '2025-11-29 18:26:29'),
(9, 7, 200000, 300000, 18, '2025-12-01 18:08:28'),
(10, 9, 0, 200000, 18, '2025-12-13 12:57:52');

-- --------------------------------------------------------

--
-- Table structure for table `province`
--

CREATE TABLE `province` (
  `id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `address` varchar(255) DEFAULT NULL,
  `region_id` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `province`
--

INSERT INTO `province` (`id`, `name`, `address`, `region_id`, `created_at`) VALUES
(1, 'Mirango', NULL, 1, '2025-11-20 19:50:28'),
(2, 'Magarama', NULL, 4, '2025-11-20 19:50:46'),
(3, 'Cotebu', NULL, 1, '2025-11-22 02:20:40'),
(4, 'Buyenzi', '18 Avenue no 1', 1, '2025-12-05 18:44:30');

-- --------------------------------------------------------

--
-- Table structure for table `province_cash_account`
--

CREATE TABLE `province_cash_account` (
  `province_id` int(11) NOT NULL,
  `balance` decimal(15,2) NOT NULL DEFAULT 0.00,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `province_cash_account`
--

INSERT INTO `province_cash_account` (`province_id`, `balance`, `created_at`, `updated_at`) VALUES
(1, 151940000.00, '2025-12-01 14:08:38', '2025-12-13 17:47:23'),
(4, 0.00, '2025-12-05 18:44:30', '2025-12-05 18:44:30');

-- --------------------------------------------------------

--
-- Table structure for table `province_cash_transaction`
--

CREATE TABLE `province_cash_transaction` (
  `id` int(11) NOT NULL,
  `province_id` int(11) NOT NULL,
  `txn_type` enum('CASH_RECEIVED','REQUISITION_PAYMENT','BANK_DEPOSIT','ADJUSTMENT') NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `direction` enum('CREDIT','DEBIT') NOT NULL,
  `reference_type` enum('INVOICE','REQUISITION','BANK_DEPOSIT','OTHER') DEFAULT 'OTHER',
  `reference_id` int(11) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `running_balance` decimal(15,2) NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `province_cash_transaction`
--

INSERT INTO `province_cash_transaction` (`id`, `province_id`, `txn_type`, `amount`, `direction`, `reference_type`, `reference_id`, `description`, `running_balance`, `created_by`, `created_at`) VALUES
(51, 1, 'CASH_RECEIVED', 10000000.00, 'CREDIT', 'OTHER', 3, '0', 10000000.00, 26, '2025-12-01 13:08:38'),
(52, 1, 'BANK_DEPOSIT', 500000.00, 'DEBIT', 'BANK_DEPOSIT', 3, '0', 9500000.00, 26, '2025-12-01 13:24:00'),
(53, 1, 'REQUISITION_PAYMENT', 1340000.00, 'DEBIT', 'REQUISITION', 12, '0', 8160000.00, 27, '2025-12-04 10:51:31'),
(54, 1, 'REQUISITION_PAYMENT', 10000.00, 'DEBIT', 'REQUISITION', 13, '0', 8150000.00, 27, '2025-12-10 09:05:30'),
(55, 1, 'CASH_RECEIVED', 143790000.00, 'CREDIT', 'OTHER', 4, '0', 151940000.00, 26, '2025-12-13 16:47:23');

-- --------------------------------------------------------

--
-- Table structure for table `province_stock`
--

CREATE TABLE `province_stock` (
  `id` int(11) NOT NULL,
  `province_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT 0,
  `reserved_quantity` int(11) NOT NULL DEFAULT 0,
  `unit_type` enum('crates') NOT NULL DEFAULT 'crates',
  `last_updated` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `province_stock`
--

INSERT INTO `province_stock` (`id`, `province_id`, `product_id`, `quantity`, `reserved_quantity`, `unit_type`, `last_updated`) VALUES
(11, 1, 7, 1500, 0, 'crates', '2025-12-13 13:03:41'),
(12, 2, 8, 500, 0, 'crates', '2025-11-29 18:32:52'),
(13, 1, 9, 39, 0, 'crates', '2025-12-13 16:36:12');

-- --------------------------------------------------------

--
-- Table structure for table `receipts`
--

CREATE TABLE `receipts` (
  `receipt_id` varchar(36) NOT NULL,
  `transaction_type` enum('direct_sale','invoice') NOT NULL,
  `transaction_id` int(11) NOT NULL,
  `receipt_number` varchar(50) NOT NULL,
  `customer_name` varchar(255) NOT NULL,
  `phone_number` varchar(20) NOT NULL,
  `total_amount` bigint(20) NOT NULL,
  `subtotal_amount` bigint(20) NOT NULL DEFAULT 0,
  `tax_amount` bigint(20) NOT NULL DEFAULT 0,
  `tax_rate` decimal(5,2) NOT NULL DEFAULT 18.00,
  `tax_mode` enum('HTVA','TVAC') NOT NULL DEFAULT 'HTVA',
  `created_at` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `pdf_content` longblob DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `receipts`
--

INSERT INTO `receipts` (`receipt_id`, `transaction_type`, `transaction_id`, `receipt_number`, `customer_name`, `phone_number`, `total_amount`, `subtotal_amount`, `tax_amount`, `tax_rate`, `tax_mode`, `created_at`, `created_by`, `pdf_content`) VALUES
('09d942fb-cc6b-11f0-a8b1-dc4ba1519f83', 'direct_sale', 0, 'christa_nemeyimana_20251128_journal.pdf', 'Christa Nemeyimana', '', 0, 0, 0, 18.00, 'HTVA', '2025-11-28 17:00:54', 27, NULL),
('1fafce21-d966-4b04-9cbb-b14c95fcc42f', 'invoice', 58, 'INV-20251211-9562', 'MAHORO BAR', '65265365', 30000000, 30000000, 0, 18.00, 'HTVA', '2025-12-11 18:36:54', 27, NULL),
('235cd255-e1e2-4389-9e7e-2ece240b9fc2', 'invoice', 52, 'INV-20251201-6535', 'BURIKUKIYE GASPARD', '62582365', 3540000, 3000000, 540000, 18.00, 'TVAC', '2025-12-01 14:59:16', 27, NULL),
('26371cd6-0b4c-4642-9ebf-f09128b718d2', 'invoice', 53, 'INV-20251201-9778', 'BURIKUKIYE GASPARD', '62582365', 12000000, 12000000, 0, 18.00, 'HTVA', '2025-12-01 16:15:39', 27, NULL),
('2a70d9b3-ca94-408b-880e-cbce20cd8828', '', 16, 'LRP-20251213150823-0016', 'KARIKURUBU PAUL', '76215365', 400000, 400000, 0, 0.00, 'HTVA', '2025-12-13 16:08:23', 27, 0x7b22637573746f6d65725f6964223a31382c22696e766f6963655f6e756d626572223a22494e562d32303235313231332d38373432222c22616d6f756e745f6475655f6265666f7265223a3430303030302c22616d6f756e745f70616964223a3430303030302c2272656d61696e696e675f62616c616e6365223a302c227061796d656e745f6d6574686f64223a2262616e6b5f6465706f736974222c226170706c6965645f696e766f6963655f6964223a38352c22696e766f6963655f616d6f756e745f72656d61696e696e67223a302c2266756c6c5f736574746c656d656e74223a747275657d),
('2d4af3e8-d320-40d8-931a-ff9b50262c56', 'invoice', 62, 'INV-20251213-1765', 'KARIKURUBU PAUL', '76215365', 708000, 600000, 108000, 18.00, 'TVAC', '2025-12-13 14:39:38', 27, NULL),
('35d33512-d6a0-11f0-9e5f-00e04c36073d', 'direct_sale', 0, 'christa_nemeyimana_20251211_journal.pdf', 'Christa Nemeyimana', '', -1350000, 0, 0, 18.00, 'HTVA', '2025-12-11 16:46:43', 27, NULL),
('4b943b6f-cec0-11f0-8194-dc4ba1519f83', 'direct_sale', 0, 'christa_nemeyimana_20251201_journal.pdf', 'Christa Nemeyimana', '', 0, 0, 0, 18.00, 'HTVA', '2025-12-01 16:16:14', 27, NULL),
('4fd4aa92-ceb5-11f0-8194-dc4ba1519f83', 'direct_sale', 0, 'christa_nemeyimana_20251201_journal.pdf', 'Christa Nemeyimana', '', 0, 0, 0, 18.00, 'HTVA', '2025-12-01 14:57:37', 27, NULL),
('5abb46a4-2611-48df-baa0-644f328b0b0e', 'invoice', 49, 'INV-20251201-5570', 'BURIKUKIYE GASPARD', '62582365', 23600000, 20000000, 3600000, 18.00, 'TVAC', '2025-12-01 14:51:18', 27, NULL),
('5c3be76c-cc65-11f0-a8b1-dc4ba1519f83', 'direct_sale', 0, 'christa_nemeyimana_20251128_journal.pdf', 'Christa Nemeyimana', '', 0, 0, 0, 18.00, 'HTVA', '2025-11-28 16:20:15', 27, NULL),
('66a2a5a2-946d-4fb0-9077-ea8cce222eb3', 'invoice', 50, 'INV-20251128-0520', 'MAHORO BAR', '65265365', 1000000, 1000000, 0, 18.00, 'HTVA', '2025-12-01 14:51:40', 27, NULL),
('69f2b78c-f6ff-4b3c-9609-3a0931a804b7', 'invoice', 55, 'INV-20251204-9006', 'MAHORO BAR', '65265365', 141600000, 120000000, 21600000, 18.00, 'TVAC', '2025-12-04 11:51:02', 27, NULL),
('7252529f-8f55-46f3-909d-7ccac2f84ffd', '', 15, 'LRP-20251201140851-0015', 'MAHORO BAR', '65265365', 1000000, 1000000, 0, 0.00, 'HTVA', '2025-12-01 15:08:51', 27, 0x7b22637573746f6d65725f6964223a31352c22696e766f6963655f6e756d626572223a6e756c6c2c22616d6f756e745f6475655f6265666f7265223a313030303030302c22616d6f756e745f70616964223a313030303030302c2272656d61696e696e675f62616c616e6365223a302c227061796d656e745f6d6574686f64223a2263617368222c226170706c6965645f696e766f6963655f6964223a6e756c6c2c22696e766f6963655f616d6f756e745f72656d61696e696e67223a6e756c6c2c2266756c6c5f736574746c656d656e74223a747275657d),
('77f7d8ac-cecd-11f0-94c2-dc4ba1519f83', 'direct_sale', 0, 'christa_nemeyimana_20251201_journal.pdf', 'Christa Nemeyimana', '', 0, 0, 0, 18.00, 'HTVA', '2025-12-01 17:50:32', 27, NULL),
('7804a9ae-9e76-4f86-9581-e590be2c49e5', 'invoice', 59, 'INV-20251213-2198', 'BURIKUKIYE GASPARD', '62582365', 190000000, 190000000, 0, 18.00, 'HTVA', '2025-12-13 13:08:53', 27, NULL),
('7c1dad32-3066-4b32-acbe-546d25eaed02', 'invoice', 48, 'INV-20251128-5614', 'MAHORO BAR', '65265365', 10000000, 10000000, 0, 18.00, 'HTVA', '2025-11-28 16:59:43', 27, NULL),
('81f79b61-77ed-4ae4-8f69-b178ae199d38', 'invoice', 51, 'INV-20251201-2430', 'BURIKUKIYE GASPARD', '62582365', 60000000, 60000000, 0, 18.00, 'HTVA', '2025-12-01 14:52:34', 27, NULL),
('8ec54ad1-aa26-4779-bf47-c60bb1bc39b0', 'invoice', 47, 'INV-20251128-0540', 'MAHORO BAR', '65265365', 7080000, 6000000, 1080000, 18.00, 'TVAC', '2025-11-28 16:19:15', 27, NULL),
('90dbed06-d839-11f0-bf4e-dc4ba1519f83', 'direct_sale', 0, 'christa_nemeyimana_20251213_journal.pdf', 'Christa Nemeyimana', '', 223508000, 0, 0, 18.00, 'HTVA', '2025-12-13 17:37:00', 27, NULL),
('a19c11f9-bc6c-4226-b5cd-4a1c8d3a4212', 'invoice', 54, 'INV-20251201-0185', 'MAHORO BAR', '65265365', 6000000, 6000000, 0, 18.00, 'HTVA', '2025-12-01 16:15:51', 27, NULL),
('a66f4cbb-ceb5-11f0-8194-dc4ba1519f83', 'direct_sale', 0, 'christa_nemeyimana_20251201_journal.pdf', 'Christa Nemeyimana', '', 0, 0, 0, 18.00, 'HTVA', '2025-12-01 15:00:02', 27, NULL),
('a8ceac0e-81b2-4471-8a09-224ed48f2d17', 'invoice', 61, 'INV-20251213-8742', 'KARIKURUBU PAUL', '76215365', 400000, 400000, 0, 18.00, 'HTVA', '2025-12-13 14:39:05', 27, NULL),
('a963740e-ceb8-11f0-8194-dc4ba1519f83', 'direct_sale', 0, 'christa_nemeyimana_20251201_journal.pdf', 'Christa Nemeyimana', '', 1000000, 0, 0, 18.00, 'HTVA', '2025-12-01 15:21:35', 27, NULL),
('befde788-7801-4501-8afc-2bd0b46e1327', 'invoice', 60, 'INV-20251213-8517', 'MAHORO BAR', '65265365', 1000000, 1000000, 0, 18.00, 'HTVA', '2025-12-13 13:33:19', 27, NULL),
('bf226941-750c-4c20-83fd-a83f0a7d60a4', 'invoice', 56, 'INV-20251206-5301', 'BURIKUKIYE GASPARD', '62582365', 3540000, 3000000, 540000, 18.00, 'TVAC', '2025-12-07 00:47:58', 27, NULL),
('c5f8574f-5e2e-4809-b6b3-f93c12f49462', '', 17, 'LRP-20251213151007-0017', 'MAHORO BAR', '65265365', 1000000, 1000000, 0, 0.00, 'HTVA', '2025-12-13 16:10:07', 27, 0x7b22637573746f6d65725f6964223a31352c22696e766f6963655f6e756d626572223a6e756c6c2c22616d6f756e745f6475655f6265666f7265223a313030303030302c22616d6f756e745f70616964223a313030303030302c2272656d61696e696e675f62616c616e6365223a302c227061796d656e745f6d6574686f64223a2263617368222c226170706c6965645f696e766f6963655f6964223a6e756c6c2c22696e766f6963655f616d6f756e745f72656d61696e696e67223a6e756c6c2c2266756c6c5f736574746c656d656e74223a747275657d);

-- --------------------------------------------------------

--
-- Table structure for table `region`
--

CREATE TABLE `region` (
  `id` int(11) NOT NULL,
  `code` varchar(10) NOT NULL,
  `name` varchar(100) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `region`
--

INSERT INTO `region` (`id`, `code`, `name`, `created_at`) VALUES
(1, 'BJM', 'Bujumbura', '2025-11-20 00:00:00'),
(2, 'BRG', 'Burunga', '2025-11-20 00:00:00'),
(3, 'BTN', 'Butanyerera', '2025-11-20 00:00:00'),
(4, 'GTG', 'Gitega', '2025-11-20 00:00:00'),
(5, 'BHM', 'Buhumuza', '2025-11-20 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `region_stock`
--

CREATE TABLE `region_stock` (
  `id` int(11) NOT NULL,
  `region_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT 0,
  `reserved_quantity` int(11) NOT NULL DEFAULT 0,
  `unit_type` enum('crates') NOT NULL DEFAULT 'crates',
  `last_updated` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `requisition`
--

CREATE TABLE `requisition` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `total_amount` int(10) NOT NULL,
  `original_total_amount` int(10) DEFAULT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  `approved_by` int(11) DEFAULT NULL,
  `assigned_cashier_id` int(11) DEFAULT NULL,
  `recipient_id` int(11) DEFAULT NULL,
  `recipient_type` enum('internal','external') NOT NULL DEFAULT 'internal',
  `recipient_external_name` varchar(255) DEFAULT NULL,
  `recipient_external_phone` varchar(20) DEFAULT NULL,
  `comments` text DEFAULT NULL,
  `last_amount_modified_at` datetime DEFAULT NULL,
  `last_amount_modified_by` int(11) DEFAULT NULL,
  `province_id` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `requisition`
--

INSERT INTO `requisition` (`id`, `user_id`, `total_amount`, `original_total_amount`, `status`, `approved_by`, `assigned_cashier_id`, `recipient_id`, `recipient_type`, `recipient_external_name`, `recipient_external_phone`, `comments`, `last_amount_modified_at`, `last_amount_modified_by`, `province_id`, `created_at`) VALUES
(11, 19, 100000, 100000, 'rejected', 18, 22, 26, 'internal', '', '', 'ok', NULL, NULL, 1, '2025-11-28 18:43:53'),
(12, 19, 1340000, 1440000, 'paid', 18, 27, NULL, 'external', 'K', '65236635', 'ok', '2025-11-29 18:16:23', 18, 1, '2025-11-28 18:48:54'),
(13, 18, 10000, 10000, 'paid', 18, 27, 23, 'internal', '', '', NULL, NULL, NULL, 1, '2025-12-10 10:03:54'),
(14, 20, 100000, 100000, 'pending', NULL, 20, NULL, 'external', 'Guillaume', '76365012', NULL, NULL, NULL, 1, '2025-12-13 17:09:53'),
(15, 18, 400000, 400000, 'approved', 18, 27, 28, 'internal', '', '', NULL, NULL, NULL, 1, '2025-12-13 17:10:40');

-- --------------------------------------------------------

--
-- Table structure for table `requisition_amount_history`
--

CREATE TABLE `requisition_amount_history` (
  `id` int(11) NOT NULL,
  `requisition_id` int(11) NOT NULL,
  `old_amount` int(11) NOT NULL,
  `new_amount` int(11) NOT NULL,
  `changed_by` int(11) NOT NULL,
  `changed_at` datetime NOT NULL DEFAULT current_timestamp(),
  `reason` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `requisition_amount_history`
--

INSERT INTO `requisition_amount_history` (`id`, `requisition_id`, `old_amount`, `new_amount`, `changed_by`, `changed_at`, `reason`) VALUES
(5, 12, 1440000, 1340000, 18, '2025-11-29 18:16:23', 'ok');

-- --------------------------------------------------------

--
-- Table structure for table `requisition_item`
--

CREATE TABLE `requisition_item` (
  `id` int(11) NOT NULL,
  `requisition_id` int(11) NOT NULL,
  `category` enum('communication','transport','frais_de_mission','office_utilities','maintenance','autre','loyer','ration') NOT NULL,
  `description` text NOT NULL,
  `quantity` int(11) NOT NULL,
  `unit_price` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `requisition_item`
--

INSERT INTO `requisition_item` (`id`, `requisition_id`, `category`, `description`, `quantity`, `unit_price`) VALUES
(11, 11, 'office_utilities', 'unity', 1, 100000),
(12, 12, 'transport', 'III', 12, 120000),
(13, 13, 'communication', 'unites onamob', 1, 10000),
(14, 14, 'transport', 'okk', 1, 100000),
(15, 15, 'communication', 'uuuu', 2, 200000);

-- --------------------------------------------------------

--
-- Table structure for table `retail_stock`
--

CREATE TABLE `retail_stock` (
  `id` int(11) NOT NULL,
  `province_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT 0,
  `unit_type` enum('crates') NOT NULL DEFAULT 'crates',
  `last_updated` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `role`
--

CREATE TABLE `role` (
  `id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `description` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `role`
--

INSERT INTO `role` (`id`, `name`, `description`) VALUES
(1, 'DG', 'Directeur Gérant, valide les budgets et supervise la vision'),
(2, 'DGA', 'Directeur Général Adjoint, supervise opérations et finances'),
(3, 'Admin', 'Administrateur du système'),
(4, 'Accountant', 'Comptable'),
(5, 'Stock Manager', 'Gestionnaire de dépôts (Technique)'),
(6, 'Caissier_Comptable', 'Responsable caisse et comptabilité terrain'),
(7, 'Operation Manager', 'Responsable Opérations Régionales'),
(8, 'Chef Marketing', 'Pilote l\'équipe commerciale'),
(9, 'Agent Marketing', 'Développement commercial terrain'),
(10, 'Conseil d\'Administration', 'Membres du Conseil d\'Administration (droits étendus sans approbation)');

-- --------------------------------------------------------

--
-- Table structure for table `stock_adjustment`
--

CREATE TABLE `stock_adjustment` (
  `id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `province_id` int(11) NOT NULL,
  `from_stock_type` enum('province','wholesale','retail') NOT NULL,
  `to_stock_type` enum('province','wholesale','retail') DEFAULT NULL,
  `quantity_moved` int(11) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `adjusted_at` datetime NOT NULL DEFAULT current_timestamp(),
  `stock_manager_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `stock_split`
--

CREATE TABLE `stock_split` (
  `id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `province_id` int(11) NOT NULL,
  `quantity_to_wholesale` int(11) NOT NULL,
  `quantity_to_retail` int(11) NOT NULL,
  `split_at` datetime NOT NULL,
  `stock_manager_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `stock_transfer`
--

CREATE TABLE `stock_transfer` (
  `id` int(11) NOT NULL,
  `operation_manager_id` int(11) NOT NULL,
  `operation_receiver_id` int(11) DEFAULT NULL,
  `stock_manager_id` int(11) DEFAULT NULL,
  `initiator_id` int(11) DEFAULT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `unit_type` enum('crates') NOT NULL DEFAULT 'crates',
  `province_id` int(11) DEFAULT NULL,
  `region_id` int(11) DEFAULT NULL,
  `status` enum('pending','confirmed','rejected') NOT NULL DEFAULT 'pending',
  `sent_at` datetime NOT NULL DEFAULT current_timestamp(),
  `received_at` datetime DEFAULT NULL,
  `estimated_arrival` datetime NOT NULL DEFAULT '2025-09-21 00:00:00',
  `driver_name` varchar(100) NOT NULL DEFAULT '',
  `driver_mobile` varchar(20) NOT NULL DEFAULT '',
  `plate_number` varchar(20) NOT NULL DEFAULT '',
  `shipment_id` int(11) NOT NULL DEFAULT 0,
  `total_amount` int(11) NOT NULL DEFAULT 0,
  `total_products` int(11) NOT NULL DEFAULT 0,
  `main_stock_id` int(11) DEFAULT NULL,
  `province_stock_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `stock_transfer`
--

INSERT INTO `stock_transfer` (`id`, `operation_manager_id`, `operation_receiver_id`, `stock_manager_id`, `initiator_id`, `product_id`, `quantity`, `unit_type`, `province_id`, `region_id`, `status`, `sent_at`, `received_at`, `estimated_arrival`, `driver_name`, `driver_mobile`, `plate_number`, `shipment_id`, `total_amount`, `total_products`, `main_stock_id`, `province_stock_id`) VALUES
(41, 18, NULL, 20, 18, 7, 3000, 'crates', 1, 1, 'confirmed', '2025-11-28 15:57:25', '2025-11-28 15:58:05', '2025-11-28 19:57:00', 'KWIZERA', '65203369', 'F3585A', 773187, 600000000, 3000, NULL, 11),
(42, 18, NULL, 24, 18, 8, 500, 'crates', 2, 4, 'confirmed', '2025-11-29 18:28:51', '2025-11-29 18:32:52', '2025-11-29 23:27:00', 'CLAUDE', '62856365', 'f525q', 970695, 150000000, 500, NULL, 12),
(43, 18, NULL, 20, 18, 9, 500, 'crates', 1, 1, 'rejected', '2025-12-13 13:00:45', '2025-12-13 13:01:12', '2025-12-13 15:00:00', 'HARERIMANA PIERRE', '76589652', 'F3652A', 110798, 160000000, 700, NULL, NULL),
(44, 18, NULL, 20, 18, 7, 100, 'crates', 1, 1, 'rejected', '2025-12-13 13:00:45', '2025-12-13 13:01:12', '2025-12-13 15:00:00', 'HARERIMANA PIERRE', '76589652', 'F3652A', 110798, 160000000, 700, NULL, NULL),
(45, 18, NULL, 20, 18, 8, 100, 'crates', 1, 1, 'rejected', '2025-12-13 13:00:45', '2025-12-13 13:01:12', '2025-12-13 15:00:00', 'HARERIMANA PIERRE', '76589652', 'F3652A', 110798, 160000000, 700, NULL, NULL),
(46, 18, NULL, 20, 18, 9, 500, 'crates', 1, 1, 'confirmed', '2025-12-13 13:02:18', '2025-12-13 13:02:27', '2025-12-13 16:02:00', 'HARERIMANA PIERRE', '76589652', 'F3652A', 330794, 130000000, 600, NULL, 13),
(47, 18, NULL, 20, 18, 7, 100, 'crates', 1, 1, 'confirmed', '2025-12-13 13:02:18', '2025-12-13 13:02:27', '2025-12-13 16:02:00', 'HARERIMANA PIERRE', '76589652', 'F3652A', 330794, 130000000, 600, NULL, 11);

-- --------------------------------------------------------

--
-- Table structure for table `supplier`
--

CREATE TABLE `supplier` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `contact` varchar(100) DEFAULT NULL,
  `address` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `supplier_product`
--

CREATE TABLE `supplier_product` (
  `supplier_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `unpaid_invoices`
--

CREATE TABLE `unpaid_invoices` (
  `id` int(11) NOT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `is_loan_sale` tinyint(1) NOT NULL DEFAULT 0,
  `has_custom_prices` tinyint(1) NOT NULL DEFAULT 0,
  `custom_price_summary` text DEFAULT NULL,
  `loan_due_date` date DEFAULT NULL,
  `loan_outstanding_bif` bigint(20) NOT NULL DEFAULT 0,
  `loan_status` enum('pending','overdue','settled') DEFAULT NULL,
  `stock_manager_id` int(11) NOT NULL,
  `status` enum('pending','paid','unpaid') NOT NULL DEFAULT 'pending',
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `customer_name` varchar(255) NOT NULL,
  `phone_number` varchar(20) NOT NULL,
  `province_id` int(11) NOT NULL,
  `nif` varchar(50) DEFAULT NULL,
  `rc` varchar(50) DEFAULT NULL,
  `invoice_number` varchar(20) NOT NULL,
  `paid_amount` bigint(20) NOT NULL DEFAULT 0,
  `subtotal_amount` bigint(20) NOT NULL DEFAULT 0,
  `tax_amount` bigint(20) NOT NULL DEFAULT 0,
  `tax_rate` decimal(5,2) NOT NULL DEFAULT 18.00,
  `tax_mode` enum('HTVA','TVAC') NOT NULL DEFAULT 'HTVA',
  `approved_by` int(11) DEFAULT NULL,
  `approval_status` enum('pending','approved','rejected') NOT NULL DEFAULT 'pending',
  `approved_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `unpaid_invoices`
--

INSERT INTO `unpaid_invoices` (`id`, `customer_id`, `is_loan_sale`, `has_custom_prices`, `custom_price_summary`, `loan_due_date`, `loan_outstanding_bif`, `loan_status`, `stock_manager_id`, `status`, `created_at`, `customer_name`, `phone_number`, `province_id`, `nif`, `rc`, `invoice_number`, `paid_amount`, `subtotal_amount`, `tax_amount`, `tax_rate`, `tax_mode`, `approved_by`, `approval_status`, `approved_at`, `expires_at`, `created_by`) VALUES
(83, 15, 1, 0, NULL, '2025-12-27', 1000000, 'pending', 20, '', '2025-12-13 13:30:11', 'MAHORO BAR', '65265365', 1, '4000002365', '', 'INV-20251213-8517', 1000000, 0, 0, 18.00, 'HTVA', 18, 'approved', '2025-12-13 13:31:37', '2025-12-13 15:30:11', 27),
(85, 18, 1, 0, NULL, '2026-01-21', 0, 'settled', 20, 'paid', '2025-12-13 14:38:12', 'KARIKURUBU PAUL', '76215365', 1, '4000056236', '', 'INV-20251213-8742', 400000, 0, 0, 18.00, 'HTVA', 18, 'approved', '2025-12-13 14:38:37', '2025-12-13 16:38:12', 27),
(86, 18, 1, 0, NULL, '2026-01-21', 200000, 'pending', 20, 'unpaid', '2025-12-13 16:36:12', 'KARIKURUBU PAUL', '76215365', 1, '4000056236', '', 'INV-20251213-0078', 200000, 0, 0, 18.00, 'HTVA', 18, 'approved', '2025-12-13 16:36:46', '2025-12-13 18:36:12', 27);

-- --------------------------------------------------------

--
-- Table structure for table `user`
--

CREATE TABLE `user` (
  `id` int(11) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `role_id` int(11) NOT NULL,
  `province_id` int(11) DEFAULT NULL,
  `region_id` int(11) DEFAULT NULL,
  `full_name` varchar(100) NOT NULL,
  `position` varchar(100) NOT NULL,
  `address` varchar(255) DEFAULT NULL,
  `email` varchar(100) NOT NULL,
  `mobile1` varchar(20) DEFAULT NULL,
  `mobile2` varchar(20) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `is_active` tinyint(1) DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `user`
--

INSERT INTO `user` (`id`, `username`, `password`, `role_id`, `province_id`, `region_id`, `full_name`, `position`, `address`, `email`, `mobile1`, `mobile2`, `created_at`, `updated_at`, `is_active`) VALUES
(1, 'admin', '$2y$10$QCGAUgx/pV3F4gKAGRMXoevEEO6Sb1j6P7iFoejzaje7K08aYcVMC', 3, NULL, NULL, 'Administrateur Principal', 'Administrateur Système', NULL, 'admin@masunzu.com', NULL, NULL, '2025-11-13 18:59:07', '2025-11-28 15:55:23', 1),
(17, 'hakizimanap', '$2y$10$QCGAUgx/pV3F4gKAGRMXoevEEO6Sb1j6P7iFoejzaje7K08aYcVMC', 6, 1, NULL, 'HAKIZIMANA PIERRE', 'Caissier_Comptable', 'Mirango', 'hk@gmail.com', NULL, NULL, '2025-11-20 20:01:08', '2025-11-28 15:55:23', 1),
(18, 'jacques', '$2y$10$QCGAUgx/pV3F4gKAGRMXoevEEO6Sb1j6P7iFoejzaje7K08aYcVMC', 2, NULL, NULL, 'Jean Jacques', 'DGA', '', 'hkd@gmail.com', NULL, NULL, '2025-11-20 20:03:55', '2025-11-28 15:55:23', 1),
(19, 'jmarie', '$2y$10$QCGAUgx/pV3F4gKAGRMXoevEEO6Sb1j6P7iFoejzaje7K08aYcVMC', 8, NULL, NULL, 'Jean Marie', 'Chef Martketing', '', 'jm@gmail.com', NULL, NULL, '2025-11-20 20:08:51', '2025-11-28 15:55:23', 1),
(20, 'bosco', '$2y$10$QCGAUgx/pV3F4gKAGRMXoevEEO6Sb1j6P7iFoejzaje7K08aYcVMC', 5, 1, NULL, 'Bosco NSHIMIRIMANA', 'Chargé', '', 'b@gmail.com', NULL, NULL, '2025-11-21 11:53:04', '2025-11-28 15:55:23', 1),
(21, 'eric', '$2y$10$QCGAUgx/pV3F4gKAGRMXoevEEO6Sb1j6P7iFoejzaje7K08aYcVMC', 7, NULL, 1, 'Muhirwa Eric', 'Chargé des opérations', 'Kinama', 'bm@gmail.com', NULL, NULL, '2025-11-21 14:00:22', '2025-11-28 15:55:23', 1),
(22, 'ella', '$2y$10$QCGAUgx/pV3F4gKAGRMXoevEEO6Sb1j6P7iFoejzaje7K08aYcVMC', 6, 2, NULL, 'Ella Ntakarutimana', 'caissiere-comptable', 'Magarama', 'en@gmail.com', NULL, NULL, '2025-11-21 22:23:08', '2025-11-28 15:55:23', 1),
(23, 'fabrice', '$2y$10$QCGAUgx/pV3F4gKAGRMXoevEEO6Sb1j6P7iFoejzaje7K08aYcVMC', 7, NULL, 4, 'Fabrice Ndikumana', 'ChargE des operations', '', 'dn@gmai.com', NULL, NULL, '2025-11-21 22:24:06', '2025-11-28 15:55:23', 1),
(24, 'pascal', '$2y$10$QCGAUgx/pV3F4gKAGRMXoevEEO6Sb1j6P7iFoejzaje7K08aYcVMC', 5, 2, NULL, 'Pascal Ndagijimana', 'ChargE du stock', 'Magarama', 'pn@gmail.com', NULL, NULL, '2025-11-21 22:25:43', '2025-11-28 15:55:23', 1),
(25, 'stessy', '$2y$10$QCGAUgx/pV3F4gKAGRMXoevEEO6Sb1j6P7iFoejzaje7K08aYcVMC', 9, NULL, NULL, 'Stessy Kamariza', 'Agent Marketing', 'Kirimiro', 'sk@gmail.com', NULL, NULL, '2025-11-23 20:12:07', '2025-11-28 15:55:23', 1),
(26, 'divine', '$2y$10$QCGAUgx/pV3F4gKAGRMXoevEEO6Sb1j6P7iFoejzaje7K08aYcVMC', 4, NULL, NULL, 'Divine Nshimirimana', 'Comptable', 'dv@gmail.com', 'dv@gmail.com', NULL, NULL, '2025-11-25 10:25:00', '2025-11-28 15:55:23', 1),
(27, 'christa', '$2y$10$DnVyCeX52rgjLjla9WH.1OQpsViKin4xAhBJAQOQkSIf9mbv4LCN2', 6, 1, NULL, 'Christa Nemeyimana', 'Y', 'Kinama', 'cn@gmail.com', NULL, NULL, '2025-11-28 15:59:46', '2025-11-28 15:59:46', 1),
(28, 'innocent', '$2y$10$sa.CreCEAGpKYbT/m1ZV5.Nyahr4kNMEqM6C5nnbUphaGDasQwVoO', 10, NULL, NULL, 'Innocent Hakizimana', 'CA', 'kb', 'ih@gmail.com', NULL, NULL, '2025-12-01 16:28:22', '2025-12-01 16:28:22', 1),
(29, 'test', '$2y$10$I16F06RACrIA9rWIMOMbweWJ21xrtfRIY5FMWXqCigSN2HbbhHSp6', 9, NULL, NULL, 'test', 'Agent Marketing', 'Kibenga, Av du Large no 45', 't@gmail.com', '71557480', '72558365', '2025-12-05 17:43:03', '2025-12-05 17:43:03', 1);

-- --------------------------------------------------------

--
-- Table structure for table `user_change_history`
--

CREATE TABLE `user_change_history` (
  `id` int(11) NOT NULL,
  `target_user_id` int(11) NOT NULL,
  `action` enum('create','edit') NOT NULL,
  `changed_by` int(11) NOT NULL,
  `change_details` longtext NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `user_change_history`
--

INSERT INTO `user_change_history` (`id`, `target_user_id`, `action`, `changed_by`, `change_details`, `created_at`) VALUES
(9, 27, 'create', 18, '{\"username\":\"christa\",\"full_name\":\"Christa Nemeyimana\",\"email\":\"cn@gmail.com\",\"role\":\"Caissier_Comptable\",\"province\":\"Mirango\",\"region\":\"N/A\",\"position\":\"Y\",\"address\":\"Kinama\",\"departments\":\"TECHNIQUE, COMMERCIAL\",\"is_active\":\"Oui\"}', '2025-11-28 15:59:46'),
(10, 28, 'create', 18, '{\"username\":\"innocent\",\"full_name\":\"Innocent Hakizimana\",\"email\":\"ih@gmail.com\",\"role\":\"Conseil d\'Administration\",\"province\":\"N/A\",\"region\":\"N/A\",\"position\":\"CA\",\"address\":\"kb\",\"departments\":\"\",\"is_active\":\"Oui\"}', '2025-12-01 16:28:22'),
(11, 29, 'create', 18, '{\"username\":\"test\",\"full_name\":\"test\",\"email\":\"t@gmail.com\",\"mobile1\":\"71557480\",\"mobile2\":\"72558365\",\"role\":\"Agent Marketing\",\"province\":\"N/A\",\"region\":\"N/A\",\"address\":\"Kibenga, Av du Large no 45\",\"departments\":\"COMMERCIAL\",\"is_active\":\"Oui\"}', '2025-12-05 17:43:03');

-- --------------------------------------------------------

--
-- Table structure for table `user_department`
--

CREATE TABLE `user_department` (
  `user_id` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `assigned_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `user_notification`
--

CREATE TABLE `user_notification` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `message` varchar(255) NOT NULL,
  `link` varchar(255) DEFAULT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `user_notification`
--

INSERT INTO `user_notification` (`id`, `user_id`, `message`, `link`, `is_read`, `created_at`) VALUES
(221, 18, 'Nouveau produit créé: \"Soma 75 cl\" - Prix: 200.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 1, '2025-11-28 15:56:44'),
(222, 1, 'Nouveau produit créé: \"Soma 75 cl\" - Prix: 200.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 0, '2025-11-28 15:56:44'),
(223, 26, 'Nouveau produit créé: \"Soma 75 cl\" - Prix: 200.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 0, '2025-11-28 15:56:44'),
(224, 20, 'Nouveau produit créé: \"Soma 75 cl\" - Prix: 200.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 1, '2025-11-28 15:56:44'),
(225, 24, 'Nouveau produit créé: \"Soma 75 cl\" - Prix: 200.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 1, '2025-11-28 15:56:44'),
(226, 17, 'Nouveau produit créé: \"Soma 75 cl\" - Prix: 200.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 0, '2025-11-28 15:56:44'),
(227, 22, 'Nouveau produit créé: \"Soma 75 cl\" - Prix: 200.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 1, '2025-11-28 15:56:44'),
(228, 21, 'Nouveau produit créé: \"Soma 75 cl\" - Prix: 200.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 0, '2025-11-28 15:56:44'),
(229, 23, 'Nouveau produit créé: \"Soma 75 cl\" - Prix: 200.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 0, '2025-11-28 15:56:44'),
(230, 19, 'Nouveau produit créé: \"Soma 75 cl\" - Prix: 200.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 1, '2025-11-28 15:56:44'),
(231, 25, 'Nouveau produit créé: \"Soma 75 cl\" - Prix: 200.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 1, '2025-11-28 15:56:44'),
(232, 20, 'Nouveau transfert #773187 vers votre province Mirango. Merci de confirmer la réception.', '/masunzu_bar_hotel/modules/operation/receive_stock.php', 1, '2025-11-28 15:57:25'),
(233, 18, 'Le transfert #773187 a été reçu et confirmé. Les produits ont été ajoutés au stock de la province.', '/masunzu_bar_hotel/modules/operation/receive_stock.php', 1, '2025-11-28 15:58:05'),
(234, 20, 'Réception du transfert #773187 confirmée. Stock de la province mis à jour.', '/masunzu_bar_hotel/modules/operation/receive_stock.php', 1, '2025-11-28 15:58:05'),
(235, 27, 'Commande INV-20251128-0540 pour MAHORO BAR a été approuvée.', '/masunzu_bar_hotel/modules/cashiers/view_invoice.php?id=68', 1, '2025-11-28 16:02:10'),
(236, 27, 'Commande INV-20251128-5614 pour MAHORO BAR a été approuvée.', '/masunzu_bar_hotel/modules/cashiers/view_invoice.php?id=69', 1, '2025-11-28 16:54:32'),
(237, 26, 'Nouveau transfert d\'espèces #3 de Christa Nemeyimana (28/11/2025 16:19) pour 10.000.000 BIF.', '/masunzu_bar_hotel/modules/accounting/receive_cash.php', 0, '2025-11-28 17:19:43'),
(238, 27, 'Commande INV-20251128-0520 pour MAHORO BAR a été approuvée.', '/masunzu_bar_hotel/modules/cashiers/view_invoice.php?id=70', 1, '2025-11-28 18:37:43'),
(239, 18, 'Nouvelle réquisition #11 créée par Jean Marie (Mirango) pour 100.000 BIF. Veuillez examiner et approuver.', '/masunzu_bar_hotel/modules/admin/approve_expenses.php', 1, '2025-11-28 18:43:53'),
(240, 18, 'Nouvelle réquisition #12 créée par Jean Marie (Mirango) pour 1.440.000 BIF. Veuillez examiner et approuver.', '/masunzu_bar_hotel/modules/admin/approve_expenses.php', 1, '2025-11-28 18:48:54'),
(241, 19, 'Requisition #12 amount adjusted from 1,440,000 BIF to 1,340,000 BIF by Jean Jacques.', '/masunzu_bar_hotel/modules/expenses/expenses_history.php', 1, '2025-11-29 18:16:23'),
(242, 17, 'New approved requisition #12 (Amount: 1,340,000 BIF) is pending payment in your province.', '/masunzu_bar_hotel/modules/cashiers/pay_requisitions.php', 0, '2025-11-29 18:16:23'),
(243, 27, 'New approved requisition #12 (Amount: 1,340,000 BIF) is pending payment in your province.', '/masunzu_bar_hotel/modules/cashiers/pay_requisitions.php', 1, '2025-11-29 18:16:23'),
(244, 19, 'Votre réquisition #12 a été approuvée par Jean Jacques.', '/masunzu_bar_hotel/modules/expenses/create.php', 1, '2025-11-29 18:16:23'),
(245, 27, 'Réquisition #12 approuvée et en attente de paiement.', '/masunzu_bar_hotel/modules/cashiers/pay_requisitions.php', 1, '2025-11-29 18:16:23'),
(246, 18, 'Nouveau produit créé: \"Vin\" - Prix: 300.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 1, '2025-11-29 18:26:29'),
(247, 1, 'Nouveau produit créé: \"Vin\" - Prix: 300.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 0, '2025-11-29 18:26:29'),
(248, 26, 'Nouveau produit créé: \"Vin\" - Prix: 300.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 0, '2025-11-29 18:26:29'),
(249, 20, 'Nouveau produit créé: \"Vin\" - Prix: 300.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 1, '2025-11-29 18:26:29'),
(250, 24, 'Nouveau produit créé: \"Vin\" - Prix: 300.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 1, '2025-11-29 18:26:29'),
(251, 17, 'Nouveau produit créé: \"Vin\" - Prix: 300.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 1, '2025-11-29 18:26:29'),
(252, 22, 'Nouveau produit créé: \"Vin\" - Prix: 300.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 1, '2025-11-29 18:26:29'),
(253, 27, 'Nouveau produit créé: \"Vin\" - Prix: 300.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 1, '2025-11-29 18:26:29'),
(254, 21, 'Nouveau produit créé: \"Vin\" - Prix: 300.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 0, '2025-11-29 18:26:29'),
(255, 23, 'Nouveau produit créé: \"Vin\" - Prix: 300.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 0, '2025-11-29 18:26:29'),
(256, 19, 'Nouveau produit créé: \"Vin\" - Prix: 300.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 1, '2025-11-29 18:26:29'),
(257, 25, 'Nouveau produit créé: \"Vin\" - Prix: 300.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 1, '2025-11-29 18:26:29'),
(258, 24, 'Nouveau transfert #970695 vers votre province Magarama. Merci de confirmer la réception.', '/masunzu_bar_hotel/modules/operation/receive_stock.php', 1, '2025-11-29 18:28:51'),
(259, 18, 'Le transfert #970695 a été reçu et confirmé. Les produits ont été ajoutés au stock de la province.', '/masunzu_bar_hotel/modules/operation/receive_stock.php', 1, '2025-11-29 18:32:52'),
(260, 24, 'Réception du transfert #970695 confirmée. Stock de la province mis à jour.', '/masunzu_bar_hotel/modules/operation/receive_stock.php', 1, '2025-11-29 18:32:52'),
(261, 1, 'Nouvelle observation terrain : oBSERVATIONS', '/masunzu_bar_hotel/modules/customers/observations.php', 0, '2025-12-01 12:05:58'),
(262, 21, 'Nouvelle observation terrain : oBSERVATIONS', '/masunzu_bar_hotel/modules/customers/observations.php', 0, '2025-12-01 12:05:58'),
(263, 23, 'Nouvelle observation terrain : oBSERVATIONS', '/masunzu_bar_hotel/modules/customers/observations.php', 0, '2025-12-01 12:05:58'),
(264, 27, 'Transfert d\'espèces #3 reçu par le comptable. Montant: 10.000.000 BIF.', '/masunzu_bar_hotel/modules/cashiers/transfer_cash.php', 1, '2025-12-01 14:08:38'),
(265, 27, 'Commande INV-20251201-5570 pour BURIKUKIYE GASPARD a été approuvée.', '/masunzu_bar_hotel/modules/cashiers/view_invoice.php?id=74', 1, '2025-12-01 14:50:46'),
(266, 27, 'Commande INV-20251201-2430 pour BURIKUKIYE GASPARD a été approuvée.', '/masunzu_bar_hotel/modules/cashiers/view_invoice.php?id=75', 1, '2025-12-01 14:52:22'),
(267, 27, 'Commande INV-20251201-6535 pour BURIKUKIYE GASPARD a été approuvée.', '/masunzu_bar_hotel/modules/cashiers/view_invoice.php?id=76', 1, '2025-12-01 14:59:01'),
(268, 18, 'Loan repayment received: 1.000.000 BIF from MAHORO BAR (Remboursement général)', '/masunzu_bar_hotel/modules/accounting/loan_management.php?customer_id=15', 1, '2025-12-01 15:08:51'),
(269, 1, 'Loan repayment received: 1.000.000 BIF from MAHORO BAR (Remboursement général)', '/masunzu_bar_hotel/modules/accounting/loan_management.php?customer_id=15', 0, '2025-12-01 15:08:51'),
(270, 1, 'Nouvelle observation terrain : okkk', '/masunzu_bar_hotel/modules/customers/observations.php', 0, '2025-12-01 16:14:17'),
(271, 21, 'Nouvelle observation terrain : okkk', '/masunzu_bar_hotel/modules/customers/observations.php', 0, '2025-12-01 16:14:17'),
(272, 23, 'Nouvelle observation terrain : okkk', '/masunzu_bar_hotel/modules/customers/observations.php', 0, '2025-12-01 16:14:17'),
(273, 27, 'Commande INV-20251201-9778 pour BURIKUKIYE GASPARD a été approuvée.', '/masunzu_bar_hotel/modules/cashiers/view_invoice.php?id=78', 1, '2025-12-01 16:15:11'),
(274, 27, 'Commande INV-20251201-0185 pour MAHORO BAR a été approuvée.', '/masunzu_bar_hotel/modules/cashiers/view_invoice.php?id=77', 1, '2025-12-01 16:15:17'),
(275, 1, 'Nouvelle observation terrain : Ibinyobwa ni bike', '/masunzu_bar_hotel/modules/customers/observations.php', 0, '2025-12-01 18:07:00'),
(276, 21, 'Nouvelle observation terrain : Ibinyobwa ni bike', '/masunzu_bar_hotel/modules/customers/observations.php', 0, '2025-12-01 18:07:00'),
(277, 23, 'Nouvelle observation terrain : Ibinyobwa ni bike', '/masunzu_bar_hotel/modules/customers/observations.php', 0, '2025-12-01 18:07:00'),
(278, 18, 'Le prix du produit \"Soma 75 cl\" a changé: 200.000 BIF → 300.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 1, '2025-12-01 18:08:28'),
(279, 1, 'Le prix du produit \"Soma 75 cl\" a changé: 200.000 BIF → 300.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 0, '2025-12-01 18:08:28'),
(280, 26, 'Le prix du produit \"Soma 75 cl\" a changé: 200.000 BIF → 300.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 0, '2025-12-01 18:08:28'),
(281, 20, 'Le prix du produit \"Soma 75 cl\" a changé: 200.000 BIF → 300.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 1, '2025-12-01 18:08:28'),
(282, 24, 'Le prix du produit \"Soma 75 cl\" a changé: 200.000 BIF → 300.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 0, '2025-12-01 18:08:28'),
(283, 17, 'Le prix du produit \"Soma 75 cl\" a changé: 200.000 BIF → 300.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 1, '2025-12-01 18:08:28'),
(284, 22, 'Le prix du produit \"Soma 75 cl\" a changé: 200.000 BIF → 300.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 1, '2025-12-01 18:08:28'),
(285, 27, 'Le prix du produit \"Soma 75 cl\" a changé: 200.000 BIF → 300.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 1, '2025-12-01 18:08:28'),
(286, 21, 'Le prix du produit \"Soma 75 cl\" a changé: 200.000 BIF → 300.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 0, '2025-12-01 18:08:28'),
(287, 23, 'Le prix du produit \"Soma 75 cl\" a changé: 200.000 BIF → 300.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 0, '2025-12-01 18:08:28'),
(288, 19, 'Le prix du produit \"Soma 75 cl\" a changé: 200.000 BIF → 300.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 0, '2025-12-01 18:08:28'),
(289, 25, 'Le prix du produit \"Soma 75 cl\" a changé: 200.000 BIF → 300.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 0, '2025-12-01 18:08:28'),
(290, 28, 'Le prix du produit \"Soma 75 cl\" a changé: 200.000 BIF → 300.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 0, '2025-12-01 18:08:28'),
(291, 27, 'Commande INV-20251204-9006 pour MAHORO BAR a été approuvée.', '/masunzu_bar_hotel/modules/cashiers/view_invoice.php?id=79', 1, '2025-12-04 11:50:34'),
(292, 27, 'Commande INV-20251206-5301 pour BURIKUKIYE GASPARD a été approuvée.', '/masunzu_bar_hotel/modules/cashiers/view_invoice.php?id=80', 1, '2025-12-07 00:47:15'),
(293, 17, 'Réquisition #13 approuvée par Jean Jacques (Mirango) et en attente de paiement. Montant: 10,000 BIF.', '/masunzu_bar_hotel/modules/cashiers/pay_requisitions.php', 1, '2025-12-10 10:03:54'),
(294, 27, 'Réquisition #13 approuvée par Jean Jacques (Mirango) et en attente de paiement. Montant: 10,000 BIF.', '/masunzu_bar_hotel/modules/cashiers/pay_requisitions.php', 1, '2025-12-10 10:03:54'),
(295, 27, 'Commande INV-20251211-9562 pour MAHORO BAR a été approuvée.', '/masunzu_bar_hotel/modules/cashiers/view_invoice.php?id=81', 1, '2025-12-11 16:48:02'),
(296, 18, 'Nouveau produit créé: \"Senator50cl\" - Prix: 200.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 1, '2025-12-13 12:57:52'),
(297, 1, 'Nouveau produit créé: \"Senator50cl\" - Prix: 200.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 0, '2025-12-13 12:57:52'),
(298, 26, 'Nouveau produit créé: \"Senator50cl\" - Prix: 200.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 0, '2025-12-13 12:57:52'),
(299, 20, 'Nouveau produit créé: \"Senator50cl\" - Prix: 200.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 1, '2025-12-13 12:57:52'),
(300, 24, 'Nouveau produit créé: \"Senator50cl\" - Prix: 200.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 0, '2025-12-13 12:57:52'),
(301, 17, 'Nouveau produit créé: \"Senator50cl\" - Prix: 200.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 1, '2025-12-13 12:57:52'),
(302, 22, 'Nouveau produit créé: \"Senator50cl\" - Prix: 200.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 1, '2025-12-13 12:57:52'),
(303, 27, 'Nouveau produit créé: \"Senator50cl\" - Prix: 200.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 1, '2025-12-13 12:57:52'),
(304, 21, 'Nouveau produit créé: \"Senator50cl\" - Prix: 200.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 0, '2025-12-13 12:57:52'),
(305, 23, 'Nouveau produit créé: \"Senator50cl\" - Prix: 200.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 0, '2025-12-13 12:57:52'),
(306, 19, 'Nouveau produit créé: \"Senator50cl\" - Prix: 200.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 0, '2025-12-13 12:57:52'),
(307, 25, 'Nouveau produit créé: \"Senator50cl\" - Prix: 200.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 0, '2025-12-13 12:57:52'),
(308, 29, 'Nouveau produit créé: \"Senator50cl\" - Prix: 200.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 0, '2025-12-13 12:57:52'),
(309, 28, 'Nouveau produit créé: \"Senator50cl\" - Prix: 200.000 BIF par caisse', '/masunzu_bar_hotel/modules/inventory/product_catalog.php', 0, '2025-12-13 12:57:52'),
(310, 20, 'Nouveau transfert #110798 vers votre province Mirango. Merci de confirmer la réception.', '/masunzu_bar_hotel/modules/operation/receive_stock.php', 1, '2025-12-13 13:00:45'),
(311, 18, 'Le transfert #110798 a été rejeté. Les produits ont été restaurés au stock principal.', '/masunzu_bar_hotel/modules/operation/receive_stock.php', 1, '2025-12-13 13:01:12'),
(312, 20, 'La réception du transfert #110798 a été rejetée.', '/masunzu_bar_hotel/modules/operation/receive_stock.php', 1, '2025-12-13 13:01:12'),
(313, 20, 'Nouveau transfert #330794 vers votre province Mirango. Merci de confirmer la réception.', '/masunzu_bar_hotel/modules/operation/receive_stock.php', 1, '2025-12-13 13:02:18'),
(314, 18, 'Le transfert #330794 a été reçu et confirmé. Les produits ont été ajoutés au stock de la province.', '/masunzu_bar_hotel/modules/operation/receive_stock.php', 1, '2025-12-13 13:02:27'),
(315, 20, 'Réception du transfert #330794 confirmée. Stock de la province mis à jour.', '/masunzu_bar_hotel/modules/operation/receive_stock.php', 1, '2025-12-13 13:02:27'),
(316, 27, 'Commande INV-20251213-2198 pour BURIKUKIYE GASPARD a été approuvée.', '/masunzu_bar_hotel/modules/cashiers/view_invoice.php?id=82', 1, '2025-12-13 13:07:58'),
(317, 27, 'Commande INV-20251213-8517 pour MAHORO BAR a été approuvée.', '/masunzu_bar_hotel/modules/cashiers/view_invoice.php?id=83', 1, '2025-12-13 13:31:37'),
(318, 27, 'Commande INV-20251213-8742 pour KARIKURUBU PAUL a été approuvée.', '/masunzu_bar_hotel/modules/cashiers/view_invoice.php?id=85', 1, '2025-12-13 14:38:37'),
(319, 27, 'Commande INV-20251213-1765 pour KARIKURUBU PAUL a été approuvée.', '/masunzu_bar_hotel/modules/cashiers/view_invoice.php?id=84', 1, '2025-12-13 14:38:51'),
(320, 18, 'Loan repayment received: 400.000 BIF from KARIKURUBU PAUL (Commande: INV-20251213-8742)', '/masunzu_bar_hotel/modules/accounting/loan_management.php?customer_id=18', 1, '2025-12-13 16:08:23'),
(321, 1, 'Loan repayment received: 400.000 BIF from KARIKURUBU PAUL (Commande: INV-20251213-8742)', '/masunzu_bar_hotel/modules/accounting/loan_management.php?customer_id=18', 0, '2025-12-13 16:08:23'),
(322, 18, 'Loan repayment received: 1.000.000 BIF from MAHORO BAR (Remboursement général)', '/masunzu_bar_hotel/modules/accounting/loan_management.php?customer_id=15', 1, '2025-12-13 16:10:07'),
(323, 1, 'Loan repayment received: 1.000.000 BIF from MAHORO BAR (Remboursement général)', '/masunzu_bar_hotel/modules/accounting/loan_management.php?customer_id=15', 0, '2025-12-13 16:10:07'),
(324, 27, 'Commande INV-20251213-0078 pour KARIKURUBU PAUL a été approuvée.', '/masunzu_bar_hotel/modules/cashiers/view_invoice.php?id=86', 1, '2025-12-13 16:36:46'),
(325, 18, 'Nouvelle réquisition #14 créée par Bosco NSHIMIRIMANA (Mirango) pour 100.000 BIF. Veuillez examiner et approuver.', '/masunzu_bar_hotel/modules/admin/approve_expenses.php', 1, '2025-12-13 17:09:53'),
(326, 17, 'Réquisition #15 approuvée par Jean Jacques (Mirango) et en attente de paiement. Montant: 400,000 BIF.', '/masunzu_bar_hotel/modules/cashiers/pay_requisitions.php', 1, '2025-12-13 17:10:40'),
(327, 27, 'Réquisition #15 approuvée par Jean Jacques (Mirango) et en attente de paiement. Montant: 400,000 BIF.', '/masunzu_bar_hotel/modules/cashiers/pay_requisitions.php', 1, '2025-12-13 17:10:40'),
(328, 26, 'Nouveau transfert d\'espèces #4 de Christa Nemeyimana (13/12/2025 16:39) pour 143.790.000 BIF.', '/masunzu_bar_hotel/modules/accounting/receive_cash.php', 0, '2025-12-13 17:39:08'),
(329, 27, 'Transfert d\'espèces #4 reçu par le comptable. Montant: 143.790.000 BIF.', '/masunzu_bar_hotel/modules/cashiers/transfer_cash.php', 1, '2025-12-13 17:47:23');

-- --------------------------------------------------------

--
-- Table structure for table `user_session`
--

CREATE TABLE `user_session` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `session_id` varchar(100) NOT NULL,
  `login_time` datetime DEFAULT current_timestamp(),
  `last_activity` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `logout_time` datetime DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `user_session`
--

INSERT INTO `user_session` (`id`, `user_id`, `session_id`, `login_time`, `last_activity`, `logout_time`, `ip_address`, `user_agent`) VALUES
(223, 28, '8mt946mtpqo4bc44s4hptdt9s0', '2025-12-01 16:28:36', '2025-12-01 16:28:36', NULL, '127.0.0.1', 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36'),
(225, 19, 'fiafc2jsl0ns6bsa4dma094dlm', '2025-11-28 18:38:36', '2025-11-28 18:38:36', NULL, '127.0.0.1', 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36'),
(241, 18, 'q02u3hkb4jrsrct47f9hgnpgo7', '2025-12-01 14:48:42', '2025-12-01 14:48:42', NULL, '127.0.0.1', 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36'),
(252, 18, '7t3gfrrc0g65srolbafc0if0qe', '2025-12-01 18:07:16', '2025-12-01 18:07:16', NULL, '127.0.0.1', 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36'),
(254, 27, 'npeaukbcpc9lbto8sorjmo720q', '2025-12-01 18:08:44', '2025-12-01 18:08:44', NULL, '127.0.0.1', 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36'),
(261, 18, 'ec9488vvn3qbi1h0av3oi7vosu', '2025-12-04 14:37:20', '2025-12-04 14:37:20', NULL, '127.0.0.1', 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36'),
(262, 18, 'svh4b2e0mstaqiuo0iktkjv3m0', '2025-12-04 14:21:24', '2025-12-04 14:21:24', NULL, '127.0.0.1', 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36'),
(277, 18, 'n7fv8tebbutlmpb72a586u9k5m', '2025-12-05 12:18:14', '2025-12-05 12:18:14', NULL, '127.0.0.1', 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36'),
(278, 18, 'mem5fpvt03h1va5iq60rk5t850', '2025-12-05 17:19:21', '2025-12-05 17:19:21', NULL, '127.0.0.1', 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36'),
(281, 27, 'spj3k841t51kdho3gn08v9098u', '2025-12-07 00:46:01', '2025-12-07 00:46:01', NULL, '127.0.0.1', 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36'),
(283, 18, 'lo5lt1hl463rgfe2d44cf6m1jt', '2025-12-07 00:46:50', '2025-12-07 00:46:50', NULL, '127.0.0.1', 'Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:145.0) Gecko/20100101 Firefox/145.0'),
(284, 27, 'c2201kolsg6tp8cd2ks46gk4rm', '2025-12-10 10:05:18', '2025-12-10 10:05:18', NULL, '127.0.0.1', 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36'),
(286, 26, 'mks24ei4l6i37of9et280gpuff', '2025-12-11 20:00:21', '2025-12-11 20:00:21', NULL, '127.0.0.1', 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36'),
(297, 27, 'jpnhiua5baabui28derc7523h9', '2025-12-13 19:15:31', '2025-12-13 19:15:31', NULL, '127.0.0.1', 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36'),
(298, 18, '819valhh9vlgfpvufllrpkjvdn', '2025-12-13 17:51:47', '2025-12-13 17:51:47', NULL, '127.0.0.1', 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36'),
(301, 22, 'ptjmaetl7gdmo0ehn15o5kl5u3', '2025-12-13 18:34:10', '2025-12-13 18:34:10', NULL, '127.0.0.1', 'Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:146.0) Gecko/20100101 Firefox/146.0'),
(302, 26, '0c175dtjj7phj4f1vsmbdh52hf', '2025-12-13 13:11:48', '2025-12-13 13:11:48', NULL, '127.0.0.1', 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36');

-- --------------------------------------------------------

--
-- Table structure for table `wholesale_stock`
--

CREATE TABLE `wholesale_stock` (
  `id` int(11) NOT NULL,
  `province_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT 0,
  `unit_type` enum('crates') NOT NULL DEFAULT 'crates',
  `last_updated` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `accountant_balance`
--
ALTER TABLE `accountant_balance`
  ADD PRIMARY KEY (`id`),
  ADD KEY `accountant_id` (`accountant_id`);

--
-- Indexes for table `audit_log`
--
ALTER TABLE `audit_log`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `bank_account`
--
ALTER TABLE `bank_account`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `account_number` (`account_number`),
  ADD KEY `province_id` (`province_id`);

--
-- Indexes for table `bank_account_transaction`
--
ALTER TABLE `bank_account_transaction`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_account_created_at` (`bank_account_id`,`created_at`),
  ADD KEY `idx_reference` (`reference_type`,`reference_id`),
  ADD KEY `fk_bat_province` (`province_id`),
  ADD KEY `fk_bat_user` (`created_by`);

--
-- Indexes for table `bank_deposit`
--
ALTER TABLE `bank_deposit`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_user` (`user_id`),
  ADD KEY `idx_province` (`province_id`),
  ADD KEY `idx_bank_account` (`bank_account_id`),
  ADD KEY `idx_deposit_date` (`deposit_date`);

--
-- Indexes for table `bank_deposit_backup`
--
ALTER TABLE `bank_deposit_backup`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_user` (`user_id`),
  ADD KEY `idx_province` (`province_id`),
  ADD KEY `idx_bank_account` (`bank_account_id`),
  ADD KEY `idx_deposit_date` (`deposit_date`);

--
-- Indexes for table `bank_deposit_new`
--
ALTER TABLE `bank_deposit_new`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_user` (`user_id`),
  ADD KEY `idx_province` (`province_id`),
  ADD KEY `idx_bank_account` (`bank_account_id`),
  ADD KEY `idx_deposit_date` (`deposit_date`);

--
-- Indexes for table `bank_deposit_v2`
--
ALTER TABLE `bank_deposit_v2`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_user` (`user_id`),
  ADD KEY `idx_province` (`province_id`),
  ADD KEY `idx_bank_account` (`bank_account_id`),
  ADD KEY `idx_deposit_date` (`deposit_date`);

--
-- Indexes for table `cashier_account`
--
ALTER TABLE `cashier_account`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_cashier_created` (`cashier_id`,`created_at`),
  ADD KEY `idx_shift` (`shift_id`),
  ADD KEY `idx_reference` (`reference_type`,`reference_id`),
  ADD KEY `idx_transaction_type` (`transaction_type`),
  ADD KEY `fk_ca_creator` (`created_by`);

--
-- Indexes for table `cashier_balance`
--
ALTER TABLE `cashier_balance`
  ADD PRIMARY KEY (`id`),
  ADD KEY `cashier_id` (`cashier_id`);

--
-- Indexes for table `cashier_shift_closure`
--
ALTER TABLE `cashier_shift_closure`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_closure_shift` (`shift_id`),
  ADD KEY `fk_closure_cashier` (`cashier_id`);

--
-- Indexes for table `cashier_shift_deposit`
--
ALTER TABLE `cashier_shift_deposit`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_shift` (`shift_id`),
  ADD KEY `idx_bank_account` (`bank_account_id`),
  ADD KEY `fk_shift_deposit_deposit` (`deposit_id`),
  ADD KEY `fk_shift_deposit_user` (`created_by`);

--
-- Indexes for table `cashier_shift_transfer`
--
ALTER TABLE `cashier_shift_transfer`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_shift` (`shift_id`),
  ADD KEY `idx_transfer` (`transfer_id`),
  ADD KEY `fk_shift_transfer_user` (`created_by`);

--
-- Indexes for table `cash_transfer`
--
ALTER TABLE `cash_transfer`
  ADD PRIMARY KEY (`id`),
  ADD KEY `cashier_id` (`cashier_id`),
  ADD KEY `accountant_id` (`accountant_id`);

--
-- Indexes for table `cash_transfer_denomination`
--
ALTER TABLE `cash_transfer_denomination`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_transfer_denom` (`transfer_id`,`denomination`);

--
-- Indexes for table `company_info`
--
ALTER TABLE `company_info`
  ADD PRIMARY KEY (`id`),
  ADD KEY `updated_by` (`updated_by`);

--
-- Indexes for table `customer`
--
ALTER TABLE `customer`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`);

--
-- Indexes for table `customer_balance`
--
ALTER TABLE `customer_balance`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`);

--
-- Indexes for table `customer_loan_ledger`
--
ALTER TABLE `customer_loan_ledger`
  ADD PRIMARY KEY (`id`),
  ADD KEY `customer_id_idx` (`customer_id`),
  ADD KEY `created_by_idx` (`created_by`);

--
-- Indexes for table `department`
--
ALTER TABLE `department`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `code` (`code`);

--
-- Indexes for table `expense`
--
ALTER TABLE `expense`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `receipt_number` (`receipt_number`),
  ADD KEY `requisition_id` (`requisition_id`),
  ADD KEY `cashier_id` (`cashier_id`),
  ADD KEY `accountant_id` (`accountant_id`),
  ADD KEY `approved_by` (`approved_by`),
  ADD KEY `expense_receiver_fk` (`receiver_user_id`);

--
-- Indexes for table `field_observation`
--
ALTER TABLE `field_observation`
  ADD PRIMARY KEY (`id`),
  ADD KEY `author_id` (`author_id`),
  ADD KEY `region_id` (`region_id`),
  ADD KEY `province_id` (`province_id`);

--
-- Indexes for table `invoice`
--
ALTER TABLE `invoice`
  ADD PRIMARY KEY (`id`),
  ADD KEY `requisition_id` (`requisition_id`),
  ADD KEY `stock_manager_id` (`stock_manager_id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `province_id` (`province_id`),
  ADD KEY `province_stock_id` (`province_stock_id`),
  ADD KEY `approved_by` (`approved_by`),
  ADD KEY `idx_invoice_assigned_cashier` (`assigned_cashier_id`);

--
-- Indexes for table `invoice_items`
--
ALTER TABLE `invoice_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `product_id` (`product_id`),
  ADD KEY `invoice_items_ibfk_1` (`invoice_id`);

--
-- Indexes for table `invoice_log`
--
ALTER TABLE `invoice_log`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `invoice_price_adjustment_history`
--
ALTER TABLE `invoice_price_adjustment_history`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_unpaid_invoice` (`unpaid_invoice_id`),
  ADD KEY `idx_product` (`product_id`),
  ADD KEY `idx_changed_by` (`changed_by`),
  ADD KEY `idx_created_at` (`created_at`);

--
-- Indexes for table `loan_payment`
--
ALTER TABLE `loan_payment`
  ADD PRIMARY KEY (`id`),
  ADD KEY `loan_payment_customer_idx` (`customer_id`),
  ADD KEY `loan_payment_order_idx` (`order_id`),
  ADD KEY `loan_payment_invoice_idx` (`invoice_id`),
  ADD KEY `loan_payment_created_idx` (`created_by`),
  ADD KEY `loan_payment_province_idx` (`province_id`),
  ADD KEY `loan_payment_ledger_fk` (`ledger_entry_id`);

--
-- Indexes for table `log`
--
ALTER TABLE `log`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `idx_created_at` (`created_at`);

--
-- Indexes for table `main_stock`
--
ALTER TABLE `main_stock`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `idx_main_stock` (`product_id`);

--
-- Indexes for table `operation_manager_stock`
--
ALTER TABLE `operation_manager_stock`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_manager_product` (`operation_manager_id`,`product_id`),
  ADD KEY `idx_operation_stock_product` (`product_id`),
  ADD KEY `idx_operation_stock_manager` (`operation_manager_id`);

--
-- Indexes for table `order`
--
ALTER TABLE `order`
  ADD PRIMARY KEY (`id`),
  ADD KEY `agent_id` (`agent_id`),
  ADD KEY `province_id` (`province_id`),
  ADD KEY `product_id` (`product_id`),
  ADD KEY `approved_by_stock_manager` (`approved_by_stock_manager`),
  ADD KEY `approved_by_operation_manager` (`approved_by_operation_manager`),
  ADD KEY `credit_approved_by` (`credit_approved_by`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `province_stock_id` (`province_stock_id`),
  ADD KEY `customer_id` (`customer_id`);

--
-- Indexes for table `paid_invoices`
--
ALTER TABLE `paid_invoices`
  ADD PRIMARY KEY (`id`),
  ADD KEY `stock_manager_id` (`stock_manager_id`),
  ADD KEY `province_id` (`province_id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `paid_invoices_served_by_fk` (`served_by`),
  ADD KEY `paid_invoices_customer_idx` (`customer_id`);

--
-- Indexes for table `paid_invoice_items`
--
ALTER TABLE `paid_invoice_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `invoice_id` (`invoice_id`),
  ADD KEY `product_id` (`product_id`);

--
-- Indexes for table `product`
--
ALTER TABLE `product`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_name` (`name`);

--
-- Indexes for table `product_price_history`
--
ALTER TABLE `product_price_history`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_product` (`product_id`),
  ADD KEY `idx_changed_at` (`changed_at`),
  ADD KEY `changed_by` (`changed_by`);

--
-- Indexes for table `province`
--
ALTER TABLE `province`
  ADD PRIMARY KEY (`id`),
  ADD KEY `region_id` (`region_id`);

--
-- Indexes for table `province_cash_account`
--
ALTER TABLE `province_cash_account`
  ADD PRIMARY KEY (`province_id`);

--
-- Indexes for table `province_cash_transaction`
--
ALTER TABLE `province_cash_transaction`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_pct_prov_date` (`province_id`,`created_at`),
  ADD KEY `idx_pct_ref` (`reference_type`,`reference_id`),
  ADD KEY `fk_pct_user` (`created_by`);

--
-- Indexes for table `province_stock`
--
ALTER TABLE `province_stock`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `idx_province_stock` (`province_id`,`product_id`),
  ADD KEY `province_stock_ibfk_2` (`product_id`);

--
-- Indexes for table `receipts`
--
ALTER TABLE `receipts`
  ADD PRIMARY KEY (`receipt_id`),
  ADD KEY `created_by` (`created_by`);

--
-- Indexes for table `region`
--
ALTER TABLE `region`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `code` (`code`);

--
-- Indexes for table `region_stock`
--
ALTER TABLE `region_stock`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_region_product` (`region_id`,`product_id`),
  ADD KEY `idx_region_stock_product` (`product_id`);

--
-- Indexes for table `requisition`
--
ALTER TABLE `requisition`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `province_id` (`province_id`),
  ADD KEY `recipient_id` (`recipient_id`),
  ADD KEY `idx_requisition_assigned_cashier` (`assigned_cashier_id`);

--
-- Indexes for table `requisition_amount_history`
--
ALTER TABLE `requisition_amount_history`
  ADD PRIMARY KEY (`id`),
  ADD KEY `req_amount_history_requisition_idx` (`requisition_id`),
  ADD KEY `req_amount_history_user_idx` (`changed_by`);

--
-- Indexes for table `requisition_item`
--
ALTER TABLE `requisition_item`
  ADD PRIMARY KEY (`id`),
  ADD KEY `requisition_id` (`requisition_id`);

--
-- Indexes for table `retail_stock`
--
ALTER TABLE `retail_stock`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `idx_retail_stock` (`province_id`,`product_id`),
  ADD KEY `retail_stock_ibfk_2` (`product_id`);

--
-- Indexes for table `role`
--
ALTER TABLE `role`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `stock_adjustment`
--
ALTER TABLE `stock_adjustment`
  ADD PRIMARY KEY (`id`),
  ADD KEY `product_id` (`product_id`),
  ADD KEY `province_id` (`province_id`),
  ADD KEY `stock_manager_id` (`stock_manager_id`);

--
-- Indexes for table `stock_split`
--
ALTER TABLE `stock_split`
  ADD PRIMARY KEY (`id`),
  ADD KEY `product_id` (`product_id`),
  ADD KEY `province_id` (`province_id`),
  ADD KEY `stock_manager_id` (`stock_manager_id`);

--
-- Indexes for table `stock_transfer`
--
ALTER TABLE `stock_transfer`
  ADD PRIMARY KEY (`id`),
  ADD KEY `operation_manager_id` (`operation_manager_id`),
  ADD KEY `stock_manager_id` (`stock_manager_id`),
  ADD KEY `product_id` (`product_id`),
  ADD KEY `province_id` (`province_id`),
  ADD KEY `region_id` (`region_id`),
  ADD KEY `main_stock_id` (`main_stock_id`),
  ADD KEY `province_stock_id` (`province_stock_id`),
  ADD KEY `operation_receiver_id` (`operation_receiver_id`),
  ADD KEY `initiator_id` (`initiator_id`);

--
-- Indexes for table `supplier`
--
ALTER TABLE `supplier`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `supplier_product`
--
ALTER TABLE `supplier_product`
  ADD PRIMARY KEY (`supplier_id`,`product_id`),
  ADD KEY `product_id` (`product_id`);

--
-- Indexes for table `unpaid_invoices`
--
ALTER TABLE `unpaid_invoices`
  ADD PRIMARY KEY (`id`),
  ADD KEY `stock_manager_id` (`stock_manager_id`),
  ADD KEY `province_id` (`province_id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `unpaid_invoices_customer_idx` (`customer_id`);

--
-- Indexes for table `user`
--
ALTER TABLE `user`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `username` (`username`),
  ADD UNIQUE KEY `email` (`email`),
  ADD KEY `role_id` (`role_id`),
  ADD KEY `province_id` (`province_id`),
  ADD KEY `region_id` (`region_id`);

--
-- Indexes for table `user_change_history`
--
ALTER TABLE `user_change_history`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_target_user` (`target_user_id`),
  ADD KEY `idx_action` (`action`),
  ADD KEY `idx_changed_by` (`changed_by`),
  ADD KEY `idx_created_at` (`created_at`);

--
-- Indexes for table `user_department`
--
ALTER TABLE `user_department`
  ADD PRIMARY KEY (`user_id`,`department_id`),
  ADD KEY `department_id` (`department_id`);

--
-- Indexes for table `user_notification`
--
ALTER TABLE `user_notification`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_user_read` (`user_id`,`is_read`);

--
-- Indexes for table `user_session`
--
ALTER TABLE `user_session`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_session_id` (`session_id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `login_time` (`login_time`);

--
-- Indexes for table `wholesale_stock`
--
ALTER TABLE `wholesale_stock`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `idx_wholesale_stock` (`province_id`,`product_id`),
  ADD KEY `wholesale_stock_ibfk_2` (`product_id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `bank_account`
--
ALTER TABLE `bank_account`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `bank_account_transaction`
--
ALTER TABLE `bank_account_transaction`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `bank_deposit`
--
ALTER TABLE `bank_deposit`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `bank_deposit_backup`
--
ALTER TABLE `bank_deposit_backup`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `bank_deposit_new`
--
ALTER TABLE `bank_deposit_new`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=18;

--
-- AUTO_INCREMENT for table `bank_deposit_v2`
--
ALTER TABLE `bank_deposit_v2`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `cashier_account`
--
ALTER TABLE `cashier_account`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=34;

--
-- AUTO_INCREMENT for table `cashier_balance`
--
ALTER TABLE `cashier_balance`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=24;

--
-- AUTO_INCREMENT for table `cashier_shift_closure`
--
ALTER TABLE `cashier_shift_closure`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=23;

--
-- AUTO_INCREMENT for table `cashier_shift_deposit`
--
ALTER TABLE `cashier_shift_deposit`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=48;

--
-- AUTO_INCREMENT for table `cashier_shift_transfer`
--
ALTER TABLE `cashier_shift_transfer`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `cash_transfer`
--
ALTER TABLE `cash_transfer`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `company_info`
--
ALTER TABLE `company_info`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `customer`
--
ALTER TABLE `customer`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=20;

--
-- AUTO_INCREMENT for table `customer_loan_ledger`
--
ALTER TABLE `customer_loan_ledger`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=50;

--
-- AUTO_INCREMENT for table `department`
--
ALTER TABLE `department`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `expense`
--
ALTER TABLE `expense`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=13;

--
-- AUTO_INCREMENT for table `field_observation`
--
ALTER TABLE `field_observation`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `invoice_items`
--
ALTER TABLE `invoice_items`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=92;

--
-- AUTO_INCREMENT for table `loan_payment`
--
ALTER TABLE `loan_payment`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=18;

--
-- AUTO_INCREMENT for table `log`
--
ALTER TABLE `log`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1066;

--
-- AUTO_INCREMENT for table `main_stock`
--
ALTER TABLE `main_stock`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=22;

--
-- AUTO_INCREMENT for table `operation_manager_stock`
--
ALTER TABLE `operation_manager_stock`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `paid_invoices`
--
ALTER TABLE `paid_invoices`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=63;

--
-- AUTO_INCREMENT for table `paid_invoice_items`
--
ALTER TABLE `paid_invoice_items`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=66;

--
-- AUTO_INCREMENT for table `product`
--
ALTER TABLE `product`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;

--
-- AUTO_INCREMENT for table `product_price_history`
--
ALTER TABLE `product_price_history`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT for table `province`
--
ALTER TABLE `province`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `province_cash_transaction`
--
ALTER TABLE `province_cash_transaction`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=56;

--
-- AUTO_INCREMENT for table `province_stock`
--
ALTER TABLE `province_stock`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=14;

--
-- AUTO_INCREMENT for table `region`
--
ALTER TABLE `region`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `region_stock`
--
ALTER TABLE `region_stock`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=16;

--
-- AUTO_INCREMENT for table `requisition`
--
ALTER TABLE `requisition`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=16;

--
-- AUTO_INCREMENT for table `requisition_amount_history`
--
ALTER TABLE `requisition_amount_history`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `requisition_item`
--
ALTER TABLE `requisition_item`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=16;

--
-- AUTO_INCREMENT for table `stock_transfer`
--
ALTER TABLE `stock_transfer`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=48;

--
-- AUTO_INCREMENT for table `unpaid_invoices`
--
ALTER TABLE `unpaid_invoices`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=87;

--
-- AUTO_INCREMENT for table `user`
--
ALTER TABLE `user`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=30;

--
-- AUTO_INCREMENT for table `user_change_history`
--
ALTER TABLE `user_change_history`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;

--
-- AUTO_INCREMENT for table `user_notification`
--
ALTER TABLE `user_notification`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=330;

--
-- AUTO_INCREMENT for table `user_session`
--
ALTER TABLE `user_session`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=310;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `accountant_balance`
--
ALTER TABLE `accountant_balance`
  ADD CONSTRAINT `accountant_balance_ibfk_1` FOREIGN KEY (`accountant_id`) REFERENCES `user` (`id`);

--
-- Constraints for table `bank_account`
--
ALTER TABLE `bank_account`
  ADD CONSTRAINT `bank_account_ibfk_1` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`);

--
-- Constraints for table `bank_account_transaction`
--
ALTER TABLE `bank_account_transaction`
  ADD CONSTRAINT `fk_bat_account` FOREIGN KEY (`bank_account_id`) REFERENCES `bank_account` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_bat_province` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `fk_bat_user` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `cashier_account`
--
ALTER TABLE `cashier_account`
  ADD CONSTRAINT `fk_ca_cashier` FOREIGN KEY (`cashier_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_ca_creator` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `fk_ca_shift` FOREIGN KEY (`shift_id`) REFERENCES `cashier_balance` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `cashier_balance`
--
ALTER TABLE `cashier_balance`
  ADD CONSTRAINT `cashier_balance_ibfk_1` FOREIGN KEY (`cashier_id`) REFERENCES `user` (`id`);

--
-- Constraints for table `cashier_shift_closure`
--
ALTER TABLE `cashier_shift_closure`
  ADD CONSTRAINT `fk_closure_cashier` FOREIGN KEY (`cashier_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_closure_shift` FOREIGN KEY (`shift_id`) REFERENCES `cashier_balance` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `cashier_shift_deposit`
--
ALTER TABLE `cashier_shift_deposit`
  ADD CONSTRAINT `fk_shift_deposit_bank` FOREIGN KEY (`bank_account_id`) REFERENCES `bank_account` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `fk_shift_deposit_deposit` FOREIGN KEY (`deposit_id`) REFERENCES `bank_deposit_new` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_shift_deposit_shift` FOREIGN KEY (`shift_id`) REFERENCES `cashier_balance` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_shift_deposit_user` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `cashier_shift_transfer`
--
ALTER TABLE `cashier_shift_transfer`
  ADD CONSTRAINT `fk_shift_transfer_shift` FOREIGN KEY (`shift_id`) REFERENCES `cashier_balance` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_shift_transfer_transfer` FOREIGN KEY (`transfer_id`) REFERENCES `cash_transfer` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_shift_transfer_user` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `cash_transfer`
--
ALTER TABLE `cash_transfer`
  ADD CONSTRAINT `cash_transfer_ibfk_1` FOREIGN KEY (`cashier_id`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `cash_transfer_ibfk_2` FOREIGN KEY (`accountant_id`) REFERENCES `user` (`id`);

--
-- Constraints for table `cash_transfer_denomination`
--
ALTER TABLE `cash_transfer_denomination`
  ADD CONSTRAINT `fk_denom_transfer` FOREIGN KEY (`transfer_id`) REFERENCES `cash_transfer` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `company_info`
--
ALTER TABLE `company_info`
  ADD CONSTRAINT `company_info_ibfk_2` FOREIGN KEY (`updated_by`) REFERENCES `user` (`id`);

--
-- Constraints for table `customer`
--
ALTER TABLE `customer`
  ADD CONSTRAINT `customer_ibfk_created_by` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `customer_balance`
--
ALTER TABLE `customer_balance`
  ADD CONSTRAINT `customer_balance_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`);

--
-- Constraints for table `customer_loan_ledger`
--
ALTER TABLE `customer_loan_ledger`
  ADD CONSTRAINT `customer_loan_ledger_customer_fk` FOREIGN KEY (`customer_id`) REFERENCES `customer` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `customer_loan_ledger_user_fk` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`);

--
-- Constraints for table `expense`
--
ALTER TABLE `expense`
  ADD CONSTRAINT `expense_ibfk_1` FOREIGN KEY (`requisition_id`) REFERENCES `requisition` (`id`),
  ADD CONSTRAINT `expense_ibfk_2` FOREIGN KEY (`cashier_id`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `expense_ibfk_3` FOREIGN KEY (`accountant_id`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `expense_ibfk_4` FOREIGN KEY (`approved_by`) REFERENCES `user` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `expense_receiver_fk` FOREIGN KEY (`receiver_user_id`) REFERENCES `user` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `field_observation`
--
ALTER TABLE `field_observation`
  ADD CONSTRAINT `field_observation_author_fk` FOREIGN KEY (`author_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `field_observation_depot_fk` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `field_observation_region_fk` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `invoice`
--
ALTER TABLE `invoice`
  ADD CONSTRAINT `fk_invoice_assigned_cashier` FOREIGN KEY (`assigned_cashier_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `invoice_ibfk_2` FOREIGN KEY (`requisition_id`) REFERENCES `requisition` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `invoice_ibfk_3` FOREIGN KEY (`stock_manager_id`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `invoice_ibfk_4` FOREIGN KEY (`province_stock_id`) REFERENCES `province_stock` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `invoice_ibfk_6` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `invoice_ibfk_7` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`),
  ADD CONSTRAINT `invoice_ibfk_8` FOREIGN KEY (`approved_by`) REFERENCES `user` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `invoice_items`
--
ALTER TABLE `invoice_items`
  ADD CONSTRAINT `invoice_items_ibfk_1` FOREIGN KEY (`invoice_id`) REFERENCES `unpaid_invoices` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `invoice_items_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`);

--
-- Constraints for table `loan_payment`
--
ALTER TABLE `loan_payment`
  ADD CONSTRAINT `loan_payment_customer_fk` FOREIGN KEY (`customer_id`) REFERENCES `customer` (`id`),
  ADD CONSTRAINT `loan_payment_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `customer` (`id`),
  ADD CONSTRAINT `loan_payment_ibfk_2` FOREIGN KEY (`order_id`) REFERENCES `order` (`id`),
  ADD CONSTRAINT `loan_payment_ibfk_3` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `loan_payment_invoice_fk` FOREIGN KEY (`invoice_id`) REFERENCES `paid_invoices` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `loan_payment_ledger_fk` FOREIGN KEY (`ledger_entry_id`) REFERENCES `customer_loan_ledger` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `loan_payment_order_fk` FOREIGN KEY (`order_id`) REFERENCES `order` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `loan_payment_user_fk` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`);

--
-- Constraints for table `log`
--
ALTER TABLE `log`
  ADD CONSTRAINT `log_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`);

--
-- Constraints for table `main_stock`
--
ALTER TABLE `main_stock`
  ADD CONSTRAINT `main_stock_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`);

--
-- Constraints for table `operation_manager_stock`
--
ALTER TABLE `operation_manager_stock`
  ADD CONSTRAINT `operation_manager_stock_ibfk_1` FOREIGN KEY (`operation_manager_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `operation_manager_stock_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `order`
--
ALTER TABLE `order`
  ADD CONSTRAINT `order_ibfk_1` FOREIGN KEY (`agent_id`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `order_ibfk_2` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`),
  ADD CONSTRAINT `order_ibfk_3` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`),
  ADD CONSTRAINT `order_ibfk_4` FOREIGN KEY (`approved_by_stock_manager`) REFERENCES `user` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `order_ibfk_5` FOREIGN KEY (`approved_by_operation_manager`) REFERENCES `user` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `order_ibfk_6` FOREIGN KEY (`credit_approved_by`) REFERENCES `user` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `order_ibfk_7` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `order_ibfk_8` FOREIGN KEY (`province_stock_id`) REFERENCES `province_stock` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `order_ibfk_9` FOREIGN KEY (`customer_id`) REFERENCES `customer` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `paid_invoices`
--
ALTER TABLE `paid_invoices`
  ADD CONSTRAINT `paid_invoices_customer_fk` FOREIGN KEY (`customer_id`) REFERENCES `customer` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `paid_invoices_ibfk_1` FOREIGN KEY (`stock_manager_id`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `paid_invoices_ibfk_2` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`),
  ADD CONSTRAINT `paid_invoices_ibfk_3` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `paid_invoices_served_by_fk` FOREIGN KEY (`served_by`) REFERENCES `user` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `paid_invoice_items`
--
ALTER TABLE `paid_invoice_items`
  ADD CONSTRAINT `paid_invoice_items_ibfk_1` FOREIGN KEY (`invoice_id`) REFERENCES `paid_invoices` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `paid_invoice_items_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `product_price_history`
--
ALTER TABLE `product_price_history`
  ADD CONSTRAINT `product_price_history_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `product_price_history_ibfk_2` FOREIGN KEY (`changed_by`) REFERENCES `user` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `province`
--
ALTER TABLE `province`
  ADD CONSTRAINT `fk_province_region` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `province_cash_account`
--
ALTER TABLE `province_cash_account`
  ADD CONSTRAINT `fk_pca_province` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`);

--
-- Constraints for table `province_cash_transaction`
--
ALTER TABLE `province_cash_transaction`
  ADD CONSTRAINT `fk_pct_province` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`),
  ADD CONSTRAINT `fk_pct_user` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`);

--
-- Constraints for table `province_stock`
--
ALTER TABLE `province_stock`
  ADD CONSTRAINT `province_stock_ibfk_1` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`),
  ADD CONSTRAINT `province_stock_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`);

--
-- Constraints for table `receipts`
--
ALTER TABLE `receipts`
  ADD CONSTRAINT `receipts_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`);

--
-- Constraints for table `region_stock`
--
ALTER TABLE `region_stock`
  ADD CONSTRAINT `region_stock_ibfk_1` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `region_stock_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `requisition`
--
ALTER TABLE `requisition`
  ADD CONSTRAINT `fk_requisition_assigned_cashier` FOREIGN KEY (`assigned_cashier_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `requisition_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `requisition_ibfk_4` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`),
  ADD CONSTRAINT `requisition_ibfk_5` FOREIGN KEY (`recipient_id`) REFERENCES `user` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `requisition_amount_history`
--
ALTER TABLE `requisition_amount_history`
  ADD CONSTRAINT `req_amount_history_requisition_fk` FOREIGN KEY (`requisition_id`) REFERENCES `requisition` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `req_amount_history_user_fk` FOREIGN KEY (`changed_by`) REFERENCES `user` (`id`);

--
-- Constraints for table `requisition_item`
--
ALTER TABLE `requisition_item`
  ADD CONSTRAINT `requisition_item_ibfk_1` FOREIGN KEY (`requisition_id`) REFERENCES `requisition` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `retail_stock`
--
ALTER TABLE `retail_stock`
  ADD CONSTRAINT `retail_stock_ibfk_1` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`),
  ADD CONSTRAINT `retail_stock_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`);

--
-- Constraints for table `stock_adjustment`
--
ALTER TABLE `stock_adjustment`
  ADD CONSTRAINT `stock_adjustment_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`),
  ADD CONSTRAINT `stock_adjustment_ibfk_2` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`),
  ADD CONSTRAINT `stock_adjustment_ibfk_3` FOREIGN KEY (`stock_manager_id`) REFERENCES `user` (`id`);

--
-- Constraints for table `stock_split`
--
ALTER TABLE `stock_split`
  ADD CONSTRAINT `stock_split_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`),
  ADD CONSTRAINT `stock_split_ibfk_2` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`),
  ADD CONSTRAINT `stock_split_ibfk_3` FOREIGN KEY (`stock_manager_id`) REFERENCES `user` (`id`);

--
-- Constraints for table `stock_transfer`
--
ALTER TABLE `stock_transfer`
  ADD CONSTRAINT `fk_stock_transfer_initiator` FOREIGN KEY (`initiator_id`) REFERENCES `user` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `fk_stock_transfer_operation_receiver` FOREIGN KEY (`operation_receiver_id`) REFERENCES `user` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `stock_transfer_ibfk_1` FOREIGN KEY (`operation_manager_id`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `stock_transfer_ibfk_2` FOREIGN KEY (`stock_manager_id`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `stock_transfer_ibfk_3` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`),
  ADD CONSTRAINT `stock_transfer_ibfk_4` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `stock_transfer_ibfk_5` FOREIGN KEY (`main_stock_id`) REFERENCES `main_stock` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `stock_transfer_ibfk_6` FOREIGN KEY (`province_stock_id`) REFERENCES `province_stock` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `stock_transfer_region_fk` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `supplier_product`
--
ALTER TABLE `supplier_product`
  ADD CONSTRAINT `supplier_product_ibfk_1` FOREIGN KEY (`supplier_id`) REFERENCES `supplier` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `supplier_product_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `unpaid_invoices`
--
ALTER TABLE `unpaid_invoices`
  ADD CONSTRAINT `unpaid_invoices_customer_fk` FOREIGN KEY (`customer_id`) REFERENCES `customer` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `unpaid_invoices_ibfk_1` FOREIGN KEY (`stock_manager_id`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `unpaid_invoices_ibfk_2` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`),
  ADD CONSTRAINT `unpaid_invoices_ibfk_3` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`);

--
-- Constraints for table `user`
--
ALTER TABLE `user`
  ADD CONSTRAINT `user_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`),
  ADD CONSTRAINT `user_ibfk_2` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `user_ibfk_region` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `user_department`
--
ALTER TABLE `user_department`
  ADD CONSTRAINT `fk_user_department_department` FOREIGN KEY (`department_id`) REFERENCES `department` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_user_department_user` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `user_notification`
--
ALTER TABLE `user_notification`
  ADD CONSTRAINT `fk_notification_user` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `user_session`
--
ALTER TABLE `user_session`
  ADD CONSTRAINT `user_session_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `wholesale_stock`
--
ALTER TABLE `wholesale_stock`
  ADD CONSTRAINT `wholesale_stock_ibfk_1` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`),
  ADD CONSTRAINT `wholesale_stock_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
