<?php

/**
 * Application-wide configuration for regions, departments and role metadata.
 * These structures are used to keep UI labels in sync with the business rules
 * shared by leadership (Technique, Commercial, Finance).
 */
return [
    'regions' => [
        ['code' => 'BJM', 'name' => 'Bujumbura'],
        ['code' => 'BRG', 'name' => 'Burunga'],
        ['code' => 'BTN', 'name' => 'Butanyerera'],
        ['code' => 'GTG', 'name' => 'Gitega'],
        ['code' => 'BHM', 'name' => 'Buhumuza'],
    ],
    'departments' => [
        'TECHNIQUE' => [
            'label' => 'Technique',
            'description' => 'Opérations terrain, gestion des transferts et supervision des stocks.',
        ],
        'COMMERCIAL' => [
            'label' => 'Commercial',
            'description' => 'Développement clients, marketing et suivi terrain.',
        ],
        'FINANCE' => [
            'label' => 'Finance',
            'description' => 'Comptabilité, paiements et supervision financière.',
        ],
    ],
    'role_aliases' => [
        'ADMIN' => 'Admin',
        'Conseil d\'Administration' => 'Board',
        'Conseil d\'administration' => 'Board',
        'Marketing Agent' => 'Agent Marketing',
        'Marketing Head' => 'Chef Marketing',
        'Finance Head' => 'Accountant',
        'Cashier' => 'Caissier_Comptable',
        'Senior Accountant' => 'Accountant',
        'Junior Accountant' => 'Accountant',
    ],
    // Internal role metadata (labels, department requirements, depot/region scope)
    'roles' => [
        'Board' => [
            'label' => 'Conseil d\'Administration',
            'departments' => [],
            'requires_depot' => false,
            'requires_region' => false,
        ],
        'DG' => [
            'label' => 'Directeur Gérant',
            'departments' => [],
            'requires_depot' => false,
            'requires_region' => false,
        ],
        'DGA' => [
            'label' => 'Directeur Général Adjoint',
            'departments' => [],
            'requires_depot' => false,
            'requires_region' => false,
        ],
        'Admin' => [
            'label' => 'Administrateur Système',
            'departments' => [],
            'requires_depot' => false,
            'requires_region' => false,
        ],
        'Operation Manager' => [
            'label' => 'Responsable Opérations Régionales',
            'departments' => ['TECHNIQUE'],
            'requires_depot' => false,
            'requires_region' => true,
        ],
        'Stock Manager' => [
            'label' => 'Gestionnaire de Stock (Dépôt)',
            'departments' => ['TECHNIQUE'],
            'requires_depot' => true,
            'requires_region' => false,
        ],
        'Stock Manager Assistant' => [
            'label' => 'Assistant Gestionnaire de Stock',
            'departments' => ['TECHNIQUE'],
            'requires_depot' => true,
            'requires_region' => false,
        ],
        'Caissier_Comptable' => [
            'label' => 'Caissier Comptable',
            'departments' => ['TECHNIQUE', 'COMMERCIAL'],
            'requires_depot' => true,
            'requires_region' => false,
        ],
        'Accountant' => [
            'label' => 'Chef Département Finance',
            'departments' => ['FINANCE'],
            'requires_depot' => false,
            'requires_region' => false,
        ],
        'Chef Marketing' => [
            'label' => 'Chef Marketing',
            'departments' => ['COMMERCIAL'],
            'requires_depot' => false,
            'requires_region' => false,
        ],
        'Agent Marketing' => [
            'label' => 'Agent Marketing',
            'departments' => ['COMMERCIAL'],
            'requires_depot' => false,
            'requires_region' => false,
        ],
        'Procurement Manager' => [
            'label' => 'Responsable Approvisionnement',
            'departments' => ['TECHNIQUE'],
            'requires_depot' => false,
            'requires_region' => false,
        ],
    ],
];
