<?php
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/auth.php';
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/functions.php';
require_login();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $current_password = $_POST['current_password'] ?? '';
    $new_password = $_POST['new_password'] ?? '';
    $confirm_password = $_POST['confirm_password'] ?? '';

    if ($new_password !== $confirm_password) {
        $error = "Les nouveaux mots de passe ne correspondent pas.";
    } elseif (strlen($new_password) < 6) {
        $error = "Le nouveau mot de passe doit contenir au moins 6 caractères.";
    } else {
        $conn = get_db_connection();
        $stmt = $conn->prepare("SELECT password FROM user WHERE id = ?");
        $stmt->bind_param("i", $_SESSION['user_id']);
        $stmt->execute();
        $result = $stmt->get_result();
        $user = $result->fetch_assoc();
        $stmt->close();

        if (password_verify($current_password, $user['password'])) {
            $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
            $stmt = $conn->prepare("UPDATE user SET password = ? WHERE id = ?");
            $stmt->bind_param("si", $hashed_password, $_SESSION['user_id']);
            $stmt->execute();
            $stmt->close();
            $conn->close();
            log_action($_SESSION['user_id'], 'change_password', "User {$_SESSION['full_name']} changed their password");
            header("Location: /masunzu_bar_hotel/dashboards/admin_dashboard.php");
            exit;
        } else {
            $error = "Le mot de passe actuel est incorrect.";
        }
        $conn->close();
    }
}
include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/header.php';
?>
<div class="form-container" style="padding: 20px; background-color: #F4F0E4; min-height: 70vh;">
    <h1 style="color: #4B2F1F; font-size: 28px; font-weight: bold; margin-bottom: 20px;">Changer le mot de passe</h1>
    <div class="form-content" style="background-color: #FFFFFF; padding: 20px; border-radius: 10px; box-shadow: 0 4px 8px rgba(0,0,0,0.1); max-width: 500px; margin: 0 auto;">
        <?php if (isset($error)): ?>
            <p style="color: red; font-size: 0.9em; margin-bottom: 10px;"><?php echo htmlspecialchars($error); ?></p>
        <?php endif; ?>
        <form method="POST">
            <div style="margin-bottom: 15px;">
                <label for="current_password" style="display: block; color: #4B2F1F; font-weight: bold; margin-bottom: 5px;">Mot de passe actuel <span style="color: red;">*</span></label>
                <input type="password" id="current_password" name="current_password" placeholder="Entrez votre mot de passe actuel" required style="width: 100%; padding: 12px; border: 2px solid #4B2F1F; border-radius: 8px; font-size: 16px; box-sizing: border-box;">
            </div>
            <div style="margin-bottom: 15px;">
                <label for="new_password" style="display: block; color: #4B2F1F; font-weight: bold; margin-bottom: 5px;">Nouveau mot de passe <span style="color: red;">*</span></label>
                <input type="password" id="new_password" name="new_password" placeholder="Entrez le nouveau mot de passe" required style="width: 100%; padding: 12px; border: 2px solid #4B2F1F; border-radius: 8px; font-size: 16px; box-sizing: border-box;">
            </div>
            <div style="margin-bottom: 20px;">
                <label for="confirm_password" style="display: block; color: #4B2F1F; font-weight: bold; margin-bottom: 5px;">Confirmer le nouveau mot de passe <span style="color: red;">*</span></label>
                <input type="password" id="confirm_password" name="confirm_password" placeholder="Confirmez le nouveau mot de passe" required style="width: 100%; padding: 12px; border: 2px solid #4B2F1F; border-radius: 8px; font-size: 16px; box-sizing: border-box;">
            </div>
            <button type="submit" style="background-color: #F4A261; color: #000000; padding: 12px; border: none; border-radius: 8px; cursor: pointer; width: 100%; font-size: 16px; font-weight: bold;"><?php echo htmlspecialchars($lang['submit']); ?></button>
        </form>
    </div>
</div>
<?php include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/footer.php'; ?>