<?php
session_start();

require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../config/database.php';

header('Content-Type: application/json; charset=utf-8');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode([
        'success' => false,
        'message' => 'Unauthorized'
    ]);
    exit;
}

require_login();

$conn = get_db_connection();
if (!$conn) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database connection failed'
    ]);
    exit;
}

$query = trim($_GET['q'] ?? '');
$limit = 50;

$sql = "
    SELECT id, full_name, nif, tel, can_pay_by_loan, loan_limit_bif, loan_balance_bif, loan_terms_days, loan_status
    FROM customer
    WHERE COALESCE(is_active, 1) = 1
";
$params = [];
$types = '';

if ($query !== '') {
    $sql .= " AND (full_name LIKE ? OR nif LIKE ? OR tel LIKE ?)";
    $like = '%' . $query . '%';
    $params = [$like, $like, $like];
    $types = 'sss';
}

$sql .= " ORDER BY full_name ASC LIMIT $limit";

$stmt = $conn->prepare($sql);
if ($stmt === false) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Failed to prepare search statement'
    ]);
    $conn->close();
    exit;
}

if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}

if (!$stmt->execute()) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Failed to execute customer search'
    ]);
    $stmt->close();
    $conn->close();
    exit;
}

$result = $stmt->get_result();
$customers = [];
while ($row = $result->fetch_assoc()) {
    $customers[] = [
        'id' => (int)$row['id'],
        'full_name' => trim($row['full_name']),
        'nif' => $row['nif'] ? trim($row['nif']) : null,
        'tel' => $row['tel'] ? trim($row['tel']) : null,
        'can_pay_by_loan' => (int)$row['can_pay_by_loan'],
        'loan_limit_bif' => isset($row['loan_limit_bif']) ? (int)$row['loan_limit_bif'] : 0,
        'loan_balance_bif' => isset($row['loan_balance_bif']) ? (int)$row['loan_balance_bif'] : 0,
        'loan_terms_days' => isset($row['loan_terms_days']) ? (int)$row['loan_terms_days'] : 0,
        'loan_status' => $row['loan_status'] ?? 'inactive',
        'display' => trim($row['full_name']) . ($row['nif'] ? ' - NIF: ' . trim($row['nif']) : '')
    ];
}
$stmt->close();
$conn->close();

echo json_encode([
    'success' => true,
    'customers' => $customers
]);
