<?php
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../includes/functions.php';

require_login();
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['available' => false, 'message' => 'Méthode non prise en charge.']);
    exit;
}

$shiftId = isset($_POST['shift_id']) ? (int)$_POST['shift_id'] : 0;
if ($shiftId <= 0) {
    http_response_code(400);
    echo json_encode(['available' => false, 'message' => 'Session invalide.']);
    exit;
}

$conn = get_db_connection();
if (!$conn) {
    http_response_code(500);
    echo json_encode(['available' => false, 'message' => 'Connexion BD indisponible.']);
    exit;
}

$userId = (int)($_SESSION['user_id'] ?? 0);
$provinceId = $_SESSION['province_id'] ?? null;

$statusSql = "
    SELECT cb.id
    FROM cashier_balance cb
    INNER JOIN user u ON cb.cashier_id = u.id
    LEFT JOIN cashier_shift_deposit csd ON cb.id = csd.shift_id
    LEFT JOIN cashier_shift_transfer cst ON cb.id = cst.shift_id
    WHERE cb.id = ?
      AND cb.cashier_id = ?
      AND cb.shift_end IS NOT NULL
      AND csd.shift_id IS NULL
      AND cst.shift_id IS NULL
";
if (!is_null($provinceId)) {
    $statusSql .= " AND u.province_id = ? ";
}
$statusSql .= " LIMIT 1";

$stmt = $conn->prepare($statusSql);
if (!$stmt) {
    http_response_code(500);
    echo json_encode(['available' => false, 'message' => 'Erreur serveur.']);
    exit;
}

if (!is_null($provinceId)) {
    $stmt->bind_param('iii', $shiftId, $userId, $provinceId);
} else {
    $stmt->bind_param('ii', $shiftId, $userId);
}
$stmt->execute();
$isAvailable = (bool)($stmt->get_result()->fetch_assoc()['id'] ?? null);
$stmt->close();

if ($isAvailable) {
    echo json_encode(['available' => true]);
    $conn->close();
    exit;
}

$diagnosticSql = "
    SELECT 
        cb.id,
        cb.cashier_id,
        cb.shift_end,
        csd.shift_id AS deposited,
        cst.shift_id AS transferred
    FROM cashier_balance cb
    LEFT JOIN cashier_shift_deposit csd ON cb.id = csd.shift_id
    LEFT JOIN cashier_shift_transfer cst ON cb.id = cst.shift_id
    WHERE cb.id = ?
    LIMIT 1
";
$stmtDiag = $conn->prepare($diagnosticSql);
if ($stmtDiag) {
    $stmtDiag->bind_param('i', $shiftId);
    $stmtDiag->execute();
    $diag = $stmtDiag->get_result()->fetch_assoc() ?: null;
    $stmtDiag->close();
}

$conn->close();

$message = 'Cette session n\'est plus disponible.';
if ($diag) {
    if (!empty($diag['deposited'])) {
        $message = 'Cette session a déjà été déposée.';
    } elseif (!empty($diag['transferred'])) {
        $message = 'Cette session a déjà été transférée.';
    } elseif ((int)$diag['cashier_id'] !== $userId) {
        $message = 'Cette session appartient à un autre caissier.';
    } elseif (empty($diag['shift_end'])) {
        $message = 'Cette session est encore active.';
    }
}

echo json_encode(['available' => false, 'message' => $message]);
