#!/bin/bash

# Script to create the file structure for Masunzu Bar Hotel system
# Run this in your htdocs/ directory: bash create_structure.sh
# It will create masunzu_bar_hotel/ and all subfolders/files

ROOT_DIR="masunzu_bar_hotel"

# Create root directory
mkdir -p "$ROOT_DIR"
cd "$ROOT_DIR" || exit

# Create root files
touch index.php
echo "<?php // Main entry point ?>" > index.php

touch .htaccess
echo "Options -Indexes" > .htaccess  # Basic security to deny directory listing

touch README.md
echo "# Masunzu Bar Hotel Management System" > README.md

# config/
mkdir -p config
touch config/database.php
echo "<?php // Database connection settings ?>" > config/database.php

touch config/app.php
echo "<?php // App config (languages, roles, provinces) ?>" > config/app.php

# includes/
mkdir -p includes
touch includes/header.php
echo "<?php // Common header with role-based menu ?>" > includes/header.php

touch includes/footer.php
echo "<?php // Common footer ?>" > includes/footer.php

touch includes/functions.php
echo "<?php // Utility functions ?>" > includes/functions.php

touch includes/auth.php
echo "<?php // Authentication and session management ?>" > includes/auth.php

touch includes/permissions.php
echo "<?php // Role-based permissions ?>" > includes/permissions.php

# assets/
mkdir -p assets/css
touch assets/css/style.css
echo "/* Global styles */" > assets/css/style.css

mkdir -p assets/js
touch assets/js/main.js
echo "// Common scripts" > assets/js/main.js

mkdir -p assets/images
touch assets/images/logo.png
echo "Placeholder logo" > assets/images/logo.png  # Dummy content, replace later

# lang/
mkdir -p lang/en
touch lang/en/translations.php
echo "<?php // English translations array ?>" > lang/en/translations.php

mkdir -p lang/fr
touch lang/fr/translations.php
echo "<?php // French translations array ?>" > lang/fr/translations.php

# modules/
mkdir -p modules/login
touch modules/login/login.php
echo "<?php // Login form and processing ?>" > modules/login/login.php

touch modules/login/logout.php
echo "<?php // Logout handler ?>" > modules/login/logout.php

mkdir -p modules/users
touch modules/users/manage.php
echo "<?php // User management (CRUD) ?>" > modules/users/manage.php

touch modules/users/profile.php
echo "<?php // User profile editing ?>" > modules/users/profile.php

mkdir -p modules/inventory
touch modules/inventory/stock.php
echo "<?php // Manage stocks ?>" > modules/inventory/stock.php

touch modules/inventory/suppliers.php
echo "<?php // Supplier management ?>" > modules/inventory/suppliers.php

touch modules/inventory/expiration.php
echo "<?php // Expiration tracking ?>" > modules/inventory/expiration.php

mkdir -p modules/sales
touch modules/sales/orders.php
echo "<?php // Order workflows ?>" > modules/sales/orders.php

touch modules/sales/invoices.php
echo "<?php // Invoice generation ?>" > modules/sales/invoices.php

touch modules/sales/credit.php
echo "<?php // Credit sales approval ?>" > modules/sales/credit.php

mkdir -p modules/requisitions
touch modules/requisitions/create.php
echo "<?php // Requisition creation ?>" > modules/requisitions/create.php

touch modules/requisitions/approve.php
echo "<?php // Requisition approvals ?>" > modules/requisitions/approve.php

touch modules/requisitions/history.php
echo "<?php // Requisition history ?>" > modules/requisitions/history.php

mkdir -p modules/expenses
touch modules/expenses/payments.php
echo "<?php // Payment handling ?>" > modules/expenses/payments.php

touch modules/expenses/receipts.php
echo "<?php // Receipt management ?>" > modules/expenses/receipts.php

mkdir -p modules/cashiers
touch modules/cashiers/operations.php
echo "<?php // Daily operations ?>" > modules/cashiers/operations.php

touch modules/cashiers/balance.php
echo "<?php // Balance calculations ?>" > modules/cashiers/balance.php

touch modules/cashiers/history.php
echo "<?php // Operation history ?>" > modules/cashiers/history.php

touch modules/cashiers/reports.php
echo "<?php // Cashier reports ?>" > modules/cashiers/reports.php

mkdir -p modules/reports
touch modules/reports/finance.php
echo "<?php // Finance reports ?>" > modules/reports/finance.php

touch modules/reports/analytics.php
echo "<?php // Analytics ?>" > modules/reports/analytics.php

# dashboards/
mkdir -p dashboards
touch dashboards/admin_dashboard.php
echo "<?php // DG/DGA/Board dashboard ?>" > dashboards/admin_dashboard.php

touch dashboards/stock_manager_dashboard.php
echo "<?php // Stock manager dashboard ?>" > dashboards/stock_manager_dashboard.php

touch dashboards/cashier_dashboard.php
echo "<?php // Cashier dashboard ?>" > dashboards/cashier_dashboard.php

touch dashboards/marketing_dashboard.php
echo "<?php // Marketing dashboard ?>" > dashboards/marketing_dashboard.php

touch dashboards/operation_dashboard.php
echo "<?php // Operation manager dashboard ?>" > dashboards/operation_dashboard.php

touch dashboards/procurement_dashboard.php
echo "<?php // Procurement dashboard ?>" > dashboards/procurement_dashboard.php

touch dashboards/finance_dashboard.php
echo "<?php // Finance head dashboard ?>" > dashboards/finance_dashboard.php

touch dashboards/default_dashboard.php
echo "<?php // Fallback dashboard ?>" > dashboards/default_dashboard.php

# database/
mkdir -p database
touch database/schema.sql
echo "-- Database schema" > database/schema.sql

touch database/seed.sql
echo "-- Seed data" > database/seed.sql

# logs/
mkdir -p logs
touch logs/audit.log
echo "Audit log started" > logs/audit.log

# Set permissions (though htdocs is 777, ensure writability)
chmod -R 777 .

echo "File structure created successfully in $ROOT_DIR!"